/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmr.server.base.extended;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmr.server.base.generated.dmw.HierarchicObjectDMW;
import org.dmd.dmr.shared.base.generated.dmo.HierarchicObjectDMO;
import org.dmd.dms.ClassDefinition;
import org.dmd.dms.generated.enums.DataTypeEnum;
import org.dmd.util.exceptions.ResultException;

public class HierarchicObject
extends HierarchicObjectDMW
implements Comparable<HierarchicObject> {
    static final Vector<HierarchicObject> emptyList = new Vector();
    private List<HierarchicObject> subcomps;
    protected HierarchicObject parent;
    static boolean sortSubComps = true;

    public HierarchicObject() {
        this.subcomps = null;
    }

    public Iterator<HierarchicObject> getSubComps() {
        if (this.subcomps == null) {
            return emptyList.iterator();
        }
        return new Vector<HierarchicObject>(this.subcomps).iterator();
    }

    protected HierarchicObject(HierarchicObjectDMO obj, ClassDefinition cd) {
        super(obj, cd);
    }

    public static void setSort(boolean f) {
        sortSubComps = f;
    }

    public void setParentObject(HierarchicObject p) throws ResultException, DmcValueException {
        this.setParentObject(p, true);
    }

    public void setParentObject(HierarchicObject p, boolean buildFQN) throws ResultException, DmcValueException {
        ResultException ex = new ResultException();
        ex.addError("Cannot set the parent of a root HierarchicObject.");
        throw ex;
    }

    public void resetParent(HierarchicObject newParent) throws ResultException, DmcValueException {
        ResultException ex = new ResultException();
        ex.addError("Cannot set the reset parent of a root HierarchicObject.");
        throw ex;
    }

    public HierarchicObject getParentObject() {
        return this.parent;
    }

    public int size() {
        if (this.subcomps == null) {
            return 0;
        }
        return this.subcomps.size();
    }

    public HierarchicObject get(int i) {
        if (this.subcomps == null || i > this.subcomps.size() - 1) {
            return null;
        }
        return this.subcomps.get(i);
    }

    public void removeSubcomponents() {
        if (this.subcomps != null) {
            this.subcomps.clear();
            this.subcomps = null;
        }
    }

    public void removeSubComponent(HierarchicObject ho) throws ResultException, DmcValueException {
        if (this.subcomps != null) {
            this.subcomps.remove(ho);
        }
    }

    public void addSubComponent(HierarchicObject ce) {
        if (this.subcomps == null) {
            this.subcomps = Collections.synchronizedList(new Vector());
        }
        this.subcomps.add(ce);
        if (sortSubComps) {
            Collections.sort(this.subcomps);
        }
    }

    @Override
    public int compareTo(HierarchicObject o) {
        if (o instanceof HierarchicObject) {
            HierarchicObject ho = o;
            if (ho.getFQN() == null) {
                if (this.getFQN() == null) {
                    return 0;
                }
                return 1;
            }
            if (this.getFQN() == null) {
                return -1;
            }
            return this.getFQN().compareTo(ho.getFQN());
        }
        return -1;
    }

    public String getName() {
        return this.getFQN().getNameString();
    }

    public void saveToFile(BufferedWriter out, int padding) throws IOException {
        out.write(this.toOIF(padding) + "\n");
        if (this.size() > 0) {
            for (int i = 0; i < this.size(); ++i) {
                this.get(i).saveToFile(out, padding, false);
            }
        }
    }

    public void saveToFile(BufferedWriter out, int padding, boolean persistentOnly) throws IOException {
        if (persistentOnly && this.getConstructionClass().getDataType() == DataTypeEnum.TRANSIENT) {
            return;
        }
        out.write(this.toOIF(padding) + "\n");
        if (this.size() > 0) {
            for (int i = 0; i < this.size(); ++i) {
                this.get(i).saveToFile(out, padding, persistentOnly);
            }
        }
    }

    public void saveToBuffer(StringBuffer sb, int padding) {
        sb.append(this.toOIF(padding) + "\n");
        if (this.size() > 0) {
            for (int i = 0; i < this.size(); ++i) {
                this.get(i).saveToBuffer(sb, padding, false);
            }
        }
    }

    public void saveToBuffer(StringBuffer sb, int padding, boolean persistentOnly) {
        if (persistentOnly && this.getConstructionClass().getDataType() == DataTypeEnum.TRANSIENT) {
            return;
        }
        sb.append(this.toOIF(padding) + "\n");
        if (this.size() > 0) {
            for (int i = 0; i < this.size(); ++i) {
                this.get(i).saveToBuffer(sb, padding, persistentOnly);
            }
        }
    }

    @Override
    public boolean equals(Object obj) {
        boolean rc = true;
        if (obj instanceof HierarchicObject) {
            if (!this.getFQN().equals(((HierarchicObject)obj).getFQN())) {
                rc = false;
            }
        } else {
            rc = false;
        }
        return rc;
    }
}

