/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmr.server.base.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dmd.dmp.server.extended.DMPEvent;
import org.dmd.dmr.server.base.util.EventListenerIF;

public class EventManager {
    List<EventListenerIF> listeners = Collections.synchronizedList(new ArrayList());

    public void addListener(EventListenerIF listener) {
        this.listeners.add(listener);
    }

    public void removeListener(EventListenerIF listener) {
        this.listeners.remove(listener);
    }

    public void notifyListeners(DMPEvent event) {
        for (EventListenerIF listener : this.listeners) {
            switch (event.getEventTypeDMP()) {
                case CREATED: {
                    listener.objectCreated(event);
                    break;
                }
                case DELETED: {
                    listener.objectDeleted(event);
                    break;
                }
                case MODIFIED: {
                    listener.objectModified(event);
                    break;
                }
            }
        }
    }
}

