/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmr.server.base.util;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.TreeMap;
import org.dmd.dmc.DmcHierarchicObjectName;
import org.dmd.dmc.DmcNameClashException;
import org.dmd.dmc.DmcNameResolverIF;
import org.dmd.dmc.DmcNamedObjectIF;
import org.dmd.dmc.DmcObject;
import org.dmd.dmc.DmcObjectName;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.rules.DmcRuleExceptionSet;
import org.dmd.dmc.types.FullyQualifiedName;
import org.dmd.dmr.server.base.extended.HierarchicObject;
import org.dmd.dmr.server.base.util.HierarchyParser;
import org.dmd.dms.SchemaManager;
import org.dmd.util.exceptions.ResultException;

public class HierarchicDataCache
implements DmcNameResolverIF {
    protected HierarchicObject root = new HierarchicObject();
    protected TreeMap<DmcHierarchicObjectName, HierarchicObject> data = new TreeMap();
    FullyQualifiedName nameKey = new FullyQualifiedName();

    public HierarchicObject getRoot() {
        return this.root;
    }

    public void addObject(HierarchicObject ho) {
        if (ho.getFQN().getParentName() == null) {
            this.root.addSubComponent(ho);
            this.data.put(ho.getFQN(), ho);
        } else {
            HierarchicObject parent = this.find(ho.getFQN().getParentName());
            if (parent == null) {
                this.data.put(ho.getFQN(), ho);
            } else {
                if (ho.getParentObject() == null) {
                    parent.addSubComponent(ho);
                }
                this.data.put(ho.getFQN(), ho);
            }
        }
    }

    public void deleteObject(DmcHierarchicObjectName FQN) {
        HierarchicObject ho = this.find(FQN);
        if (ho != null) {
            try {
                ho.getParentObject().removeSubComponent(ho);
            }
            catch (ResultException e) {
                e.printStackTrace();
            }
            catch (DmcValueException e) {
                e.printStackTrace();
            }
            this.data.remove(FQN);
        }
    }

    public HierarchicObject find(DmcHierarchicObjectName name) {
        return this.data.get(name);
    }

    public void loadData(SchemaManager sm, String fn) throws ResultException, DmcValueException, DmcRuleExceptionSet, DmcNameClashException {
        HierarchyParser parser = new HierarchyParser(sm, this);
        parser.readHierarchy(fn);
    }

    public void savePersistentData(String ofn, int padding) throws IOException {
        BufferedWriter out = new BufferedWriter(new FileWriter(ofn));
        for (int i = 0; i < this.root.size(); ++i) {
            this.root.get(i).saveToFile(out, padding, true);
        }
        out.close();
    }

    public DmcNamedObjectIF findNamedObject(String name) {
        try {
            this.nameKey.setNameString(name);
        }
        catch (DmcValueException e) {
            e.printStackTrace();
        }
        return this.data.get(this.nameKey);
    }

    @Override
    public DmcNamedObjectIF findNamedObject(DmcObjectName name) {
        return this.data.get(name);
    }

    @Override
    public DmcObject findNamedDMO(DmcObjectName name) {
        HierarchicObject ho = this.data.get(name);
        if (ho == null) {
            return null;
        }
        return ho.getDmcObject();
    }

    @Override
    public DmcNamedObjectIF findNamedObject(DmcObjectName name, int attributeID) {
        return this.findNamedObject(name);
    }
}

