/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmr.server.base.util;

import org.dmd.dmc.DmcHierarchicObjectName;
import org.dmd.dmc.DmcNameClashException;
import org.dmd.dmc.DmcNameResolverIF;
import org.dmd.dmc.DmcNamedObjectIF;
import org.dmd.dmc.DmcObject;
import org.dmd.dmc.DmcObjectName;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.DmcValueExceptionSet;
import org.dmd.dmc.rules.DmcRuleExceptionSet;
import org.dmd.dmc.types.FullyQualifiedName;
import org.dmd.dmc.util.DmcUncheckedObject;
import org.dmd.dmr.server.base.extended.HierarchicObject;
import org.dmd.dmr.server.base.util.HierarchicDataCache;
import org.dmd.dms.AttributeDefinition;
import org.dmd.dms.SchemaManager;
import org.dmd.dmw.DmwObjectFactory;
import org.dmd.util.exceptions.DebugInfo;
import org.dmd.util.exceptions.ResultException;
import org.dmd.util.parsing.DmcUncheckedOIFHandlerIF;
import org.dmd.util.parsing.DmcUncheckedOIFParser;

public class HierarchyParser
implements DmcUncheckedOIFHandlerIF,
DmcNameResolverIF {
    SchemaManager schema;
    DmwObjectFactory factory;
    DmcUncheckedOIFParser parser;
    HierarchicDataCache cache;
    HierarchicObject root;
    AttributeDefinition FQNAD;
    AttributeDefinition parentFQNAD;
    boolean setFileAndLine;

    public HierarchyParser(SchemaManager sm, HierarchicDataCache hdc) {
        this.schema = sm;
        this.cache = hdc;
        this.FQNAD = this.schema.adef("FQN");
        this.parentFQNAD = this.schema.adef("parentFQN");
        this.parser = new DmcUncheckedOIFParser(this);
        this.factory = new DmwObjectFactory(this.schema);
        this.setFileAndLine = false;
    }

    public HierarchyParser(SchemaManager sm, HierarchicDataCache hdc, boolean sfal) {
        this.schema = sm;
        this.cache = hdc;
        this.FQNAD = this.schema.adef("FQN");
        this.parentFQNAD = this.schema.adef("parentFQN");
        this.parser = new DmcUncheckedOIFParser(this);
        this.factory = new DmwObjectFactory(this.schema);
        this.setFileAndLine = sfal;
    }

    public HierarchicObject readHierarchy(String fn) throws ResultException, DmcValueException, DmcRuleExceptionSet, DmcNameClashException {
        this.root = null;
        this.parser.parseFile(fn);
        this.resolveReferences();
        return this.root;
    }

    void resolveReferences() throws ResultException {
        ResultException errors = null;
        for (HierarchicObject ho : this.cache.data.values()) {
            DebugInfo.debug(ho.getFQN().getNameString());
            try {
                ho.resolveReferences(this);
                if (this.setFileAndLine) continue;
                ho.remFile();
                ho.remLineNumber();
            }
            catch (DmcValueExceptionSet e) {
                if (errors == null) {
                    errors = new ResultException();
                }
                errors.addError("Couldn't resolve references in object:  " + ho.getFQN());
                errors.setLocationInfo(ho.getFile(), ho.getLineNumber());
                for (DmcValueException dve : e.getExceptions()) {
                    errors.moreMessages(dve.getMessage());
                }
            }
        }
        if (errors != null) {
            throw errors;
        }
    }

    @Override
    public void handleObject(DmcUncheckedObject uco, String infile, int lineNumber) throws ResultException, DmcValueException, DmcNameClashException {
        FullyQualifiedName fqn = null;
        DmcHierarchicObjectName parentFqn = null;
        HierarchicObject newEntry = null;
        HierarchicObject parentEntry = null;
        HierarchicObject currObj = null;
        try {
            currObj = (HierarchicObject)this.factory.createWrapper(uco);
            DebugInfo.debug("Loaded:\n\n" + currObj.toOIF(15));
        }
        catch (ClassNotFoundException e) {
            ResultException ex = new ResultException("Unknown object class: " + uco.classes.get(0));
            ex.result.lastResult().fileName(infile);
            ex.result.lastResult().lineNumber(lineNumber);
            throw ex;
        }
        catch (ResultException ex) {
            ex.setLocationInfo(infile, lineNumber);
            throw ex;
        }
        currObj.setLineNumber(lineNumber);
        currObj.setFile(infile);
        if (currObj.getFQN() == null) {
            ex = new ResultException();
            ex.addError("Missing FQN for object.");
            ex.setLocationInfo(currObj.getFile(), currObj.getLineNumber());
            throw ex;
        }
        fqn = currObj.getFQN();
        if (currObj.getFQN().getParentName() != null) {
            parentFqn = currObj.getFQN().getParentName();
        }
        if (parentFqn == null) {
            currObj.setParentObject(null);
            this.cache.addObject(currObj);
        } else {
            if (this.cache.find(fqn) == null) {
                parentEntry = this.cache.find(parentFqn);
                if (parentEntry == null) {
                    ex = new ResultException();
                    ex.addError("Missing parent: " + parentFqn + " for object: " + fqn);
                    ex.setLocationInfo(currObj.getFile(), currObj.getLineNumber());
                    throw ex;
                }
            } else {
                ex = new ResultException();
                ex.addError("Duplicate FQN: " + fqn);
                ex.setLocationInfo(currObj.getFile(), currObj.getLineNumber());
                throw ex;
            }
            newEntry = currObj;
            newEntry.setParentObject(parentEntry);
            this.cache.addObject(currObj);
            System.out.println("HierarchyParser read:\n" + newEntry.getFQN());
        }
    }

    @Override
    public DmcObject findNamedDMO(DmcObjectName name) {
        DmcObject rc = this.schema.findNamedDMO(name);
        if (rc == null) {
            return this.cache.findNamedDMO(name);
        }
        return rc;
    }

    @Override
    public DmcNamedObjectIF findNamedObject(DmcObjectName name) {
        DmcNamedObjectIF rc = this.schema.findNamedObject(name);
        if (rc == null) {
            return this.cache.findNamedObject(name);
        }
        return rc;
    }

    @Override
    public DmcNamedObjectIF findNamedObject(DmcObjectName name, int attributeID) {
        DmcNamedObjectIF rc = this.schema.findNamedObject(name);
        if (rc == null) {
            return this.cache.findNamedObject(name);
        }
        return rc;
    }
}

