/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmr.server.ldap.extended;

import java.util.Iterator;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcObjectNameIF;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmr.server.base.RepositoryIF;
import org.dmd.dmr.server.base.extended.HierarchicObject;
import org.dmd.dmr.server.ldap.generated.dmw.LDAPAttributeAUX;
import org.dmd.dmr.server.ldap.generated.dmw.LDAPClassAUX;
import org.dmd.dmr.server.ldap.generated.dmw.LDAPHierarchicObjectDMW;
import org.dmd.dmr.shared.ldap.generated.dmo.LDAPHierarchicObjectDMO;
import org.dmd.dms.AttributeDefinition;
import org.dmd.dms.ClassDefinition;
import org.dmd.util.exceptions.DebugInfo;
import org.dmd.util.exceptions.ResultException;

public class LDAPHierarchicObject
extends LDAPHierarchicObjectDMW {
    String repositoryID;
    RepositoryIF repository;

    protected LDAPHierarchicObject(LDAPHierarchicObjectDMO obj, ClassDefinition cd) {
        super(obj, cd);
    }

    public LDAPHierarchicObject() {
    }

    @Override
    public void setParentObject(HierarchicObject p) throws ResultException, DmcValueException {
        this.setParentObject(p, true);
    }

    @Override
    public void setParentObject(HierarchicObject p, boolean buildFQN) throws ResultException, DmcValueException {
        AttributeDefinition naAD = LDAPClassAUX.getNamingAttribute(this.getConstructionClass());
        DmcAttribute<?> nameAttr = this.core.get(naAD.getDmdID());
        if (nameAttr == null) {
            ResultException ex = new ResultException();
            ex.addError("Missing value for naming attribute: " + naAD.getName());
            throw ex;
        }
        if (p != null && p.getFQN() == null) {
            ResultException ex = new ResultException();
            ex.addErrorWithStack("The object being set as the parent hasn't been properly initialized. Ensure that its setParentObject() function has been called.", DebugInfo.getCurrentStack());
            throw ex;
        }
        this.parent = p;
        if (!buildFQN) {
            return;
        }
        if (this.parent == null) {
            this.setFQN(this.getConstructionClass().getShortestName() + ":" + nameAttr.getSV().toString());
            this.repositoryID = LDAPAttributeAUX.getReposName(naAD) + "=" + nameAttr.getSV().toString();
        } else {
            this.setFQN(this.parent.getFQN() + "/" + this.getConstructionClass().getShortestName() + ":" + nameAttr.getSV().toString());
            this.repositoryID = LDAPAttributeAUX.getReposName(naAD) + "=" + nameAttr.getSV().toString() + "," + ((LDAPHierarchicObject)this.parent).getRepositoryID();
            this.parent.addSubComponent(this);
        }
    }

    @Override
    public void resetParent(HierarchicObject newParent) throws ResultException, DmcValueException {
        AttributeDefinition naAD = LDAPClassAUX.getNamingAttribute(this.getConstructionClass());
        DmcAttribute<?> nameAttr = this.core.get(naAD.getDmdID());
        if (nameAttr == null) {
            ResultException ex = new ResultException();
            ex.addError("Missing value for naming attribute: " + naAD.getName());
            throw ex;
        }
        if (newParent == null) {
            this.setFQN(this.getConstructionClass().getShortestName() + ":" + nameAttr.getSV().toString());
            if (this.parent != null) {
                this.parent.removeSubComponent(this);
            }
            this.parent = newParent;
            this.repositoryID = LDAPAttributeAUX.getReposName(naAD) + "=" + nameAttr.getSV().toString();
        } else {
            if (newParent != this.parent) {
                if (this.parent != null) {
                    this.parent.removeSubComponent(this);
                }
                newParent.addSubComponent(this);
            }
            this.parent = newParent;
            this.setFQN(this.parent.getFQN() + "/" + this.getConstructionClass().getShortestName() + ":" + nameAttr.getSV().toString());
            this.repositoryID = LDAPAttributeAUX.getReposName(naAD) + "=" + nameAttr.getSV().toString() + "," + ((LDAPHierarchicObject)this.parent).getRepositoryID();
        }
        Iterator<HierarchicObject> it = this.getSubComps();
        while (it.hasNext()) {
            it.next().resetParent(this);
        }
    }

    public String getRepositoryID() throws ResultException {
        if (this.repositoryID == null) {
            AttributeDefinition naAD = LDAPClassAUX.getNamingAttribute(this.getConstructionClass());
            DmcAttribute<?> nameAttr = this.core.get(naAD.getName().getNameString());
            if (nameAttr == null) {
                ResultException ex = new ResultException();
                ex.addError("Missing value for naming attribute: " + naAD.getName());
                throw ex;
            }
            DmcObjectNameIF naAttr = (DmcObjectNameIF)nameAttr.getSV();
            this.repositoryID = LDAPAttributeAUX.getReposName(naAD) + "=" + naAttr.getNameString();
        }
        return this.repositoryID;
    }

    public void setRepositoryID(String id) {
        this.repositoryID = id;
    }

    public void setRepository(RepositoryIF r) {
        this.repository = r;
    }

    public RepositoryIF getRepository() {
        return this.repository;
    }
}

