/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmr.server.ldap.util;

import java.util.ArrayList;
import java.util.TreeMap;
import org.dmd.dmc.DmcHierarchicObjectName;
import org.dmd.dmc.DmcNameClashException;
import org.dmd.dmc.DmcNameResolverIF;
import org.dmd.dmc.DmcNamedObjectIF;
import org.dmd.dmc.DmcObject;
import org.dmd.dmc.DmcObjectName;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.DmcValueExceptionSet;
import org.dmd.dmc.rules.DmcRuleExceptionSet;
import org.dmd.dmc.types.FullyQualifiedName;
import org.dmd.dmc.types.StringName;
import org.dmd.dmc.util.DmcUncheckedObject;
import org.dmd.dmr.server.base.extended.HierarchicObject;
import org.dmd.dms.AttributeDefinition;
import org.dmd.dms.SchemaManager;
import org.dmd.dmw.DmwObjectFactory;
import org.dmd.util.exceptions.ResultException;
import org.dmd.util.parsing.DmcUncheckedOIFHandlerIF;
import org.dmd.util.parsing.DmcUncheckedOIFParser;

public class HierarchyParserOld
implements DmcUncheckedOIFHandlerIF,
DmcNameResolverIF {
    SchemaManager schema;
    DmwObjectFactory factory;
    DmcUncheckedOIFParser parser;
    HierarchicObject root;
    TreeMap<DmcHierarchicObjectName, HierarchicObject> keyMap;
    AttributeDefinition FQNAD;
    AttributeDefinition parentFQNAD;
    ArrayList<HierarchicObject> loadedObjects;
    StringName nameKey;

    public HierarchyParserOld(SchemaManager sm) {
        this.schema = sm;
        this.FQNAD = this.schema.adef("FQN");
        this.parentFQNAD = this.schema.adef("parentFQN");
        this.parser = new DmcUncheckedOIFParser(this);
        this.factory = new DmwObjectFactory(this.schema);
        this.nameKey = new StringName();
    }

    public HierarchicObject readHierarchy(String fn) throws ResultException, DmcValueException, DmcRuleExceptionSet, DmcNameClashException {
        this.keyMap = new TreeMap();
        this.root = null;
        this.loadedObjects = new ArrayList();
        this.parser.parseFile(fn);
        return this.root;
    }

    public void readHierarchicFile(TreeMap<DmcHierarchicObjectName, HierarchicObject> byFQN, String fn) throws ResultException, DmcValueException, DmcRuleExceptionSet, DmcNameClashException {
        this.keyMap = byFQN;
        this.loadedObjects = new ArrayList();
        this.parser.parseFile(fn);
    }

    public HierarchicObject readHierarchyBelowRoot(HierarchicObject existingRoot, String fn) throws ResultException, DmcValueException, DmcRuleExceptionSet, DmcNameClashException {
        this.keyMap = new TreeMap();
        this.keyMap.put(existingRoot.getFQN(), existingRoot);
        this.root = existingRoot;
        this.loadedObjects = new ArrayList();
        this.parser.parseFile(fn);
        return this.root;
    }

    void resolveReferences() throws ResultException {
        ResultException errors = null;
        for (HierarchicObject ho : this.loadedObjects) {
            try {
                ho.resolveReferences(this);
            }
            catch (DmcValueExceptionSet e) {
                if (errors == null) {
                    errors = new ResultException();
                }
                errors.addError("Couldn't resolve references in object:  " + ho.getName());
                errors.setLocationInfo(ho.getFile(), ho.getLineNumber());
                for (DmcValueException dve : e.getExceptions()) {
                    errors.moreMessages(dve.getMessage());
                }
            }
        }
        if (errors != null) {
            throw errors;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handleObject(DmcUncheckedObject uco, String infile, int lineNumber) throws ResultException, DmcValueException, DmcNameClashException {
        FullyQualifiedName fqn = null;
        DmcHierarchicObjectName parentFqn = null;
        HierarchicObject newEntry = null;
        HierarchicObject parentEntry = null;
        HierarchicObject currObj = null;
        try {
            currObj = (HierarchicObject)this.factory.createWrapper(uco);
        }
        catch (ClassNotFoundException e) {
            ResultException ex = new ResultException("Unknown object class: " + uco.classes.get(0));
            ex.result.lastResult().fileName(infile);
            ex.result.lastResult().lineNumber(lineNumber);
            throw ex;
        }
        catch (ResultException ex) {
            ex.setLocationInfo(infile, lineNumber);
            throw ex;
        }
        currObj.setLineNumber(lineNumber);
        currObj.setFile(infile);
        if (currObj.getFQN() == null) {
            ex = new ResultException();
            ex.addError("Missing FQN for object.");
            ex.setLocationInfo(currObj.getFile(), currObj.getLineNumber());
            throw ex;
        }
        fqn = currObj.getFQN();
        if (currObj.getFQN().getParentName() != null) {
            parentFqn = currObj.getFQN().getParentName();
        }
        if (parentFqn == null) {
            if (this.root == null) {
                this.root = currObj;
                this.root.setParentObject(null);
                this.keyMap.put(fqn, this.root);
                return;
            }
            ex = new ResultException();
            ex.addError("Missing parent for object:" + fqn);
            ex.setLocationInfo(currObj.getFile(), currObj.getLineNumber());
            throw ex;
        }
        if (this.keyMap.get(fqn) != null) {
            ex = new ResultException();
            ex.addError("Duplicate fqn: " + fqn);
            ex.setLocationInfo(currObj.getFile(), currObj.getLineNumber());
            throw ex;
        }
        parentEntry = this.keyMap.get(parentFqn);
        if (parentEntry == null) {
            ex = new ResultException();
            ex.addError("Missing parent: " + parentFqn + " for object: " + fqn);
            ex.setLocationInfo(currObj.getFile(), currObj.getLineNumber());
            throw ex;
        }
        newEntry = currObj;
        newEntry.setParentObject(parentEntry);
        this.keyMap.put(fqn, newEntry);
        System.out.println("HierarchyParser read:\n" + newEntry.getFQN());
    }

    public DmcNamedObjectIF findNamedObject(String name) {
        try {
            this.nameKey.setNameString(name);
        }
        catch (DmcValueException e) {
            e.printStackTrace();
        }
        return this.keyMap.get(this.nameKey);
    }

    @Override
    public DmcNamedObjectIF findNamedObject(DmcObjectName name) {
        DmcNamedObjectIF rc = this.schema.findNamedObject(name);
        if (rc == null) {
            return this.keyMap.get(name);
        }
        return rc;
    }

    @Override
    public DmcObject findNamedDMO(DmcObjectName name) {
        return null;
    }

    @Override
    public DmcNamedObjectIF findNamedObject(DmcObjectName name, int attributeID) {
        return null;
    }
}

