/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmr.server.ldap.util;

import java.util.Iterator;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.util.DmcUncheckedObject;
import org.dmd.dmr.server.ldap.generated.DmrldapSchemaAG;
import org.dmd.dmr.server.ldap.generated.dmw.LDAPAttributeAUX;
import org.dmd.dmr.server.ldap.generated.dmw.LDAPClassAUX;
import org.dmd.dmr.server.ldap.generated.dmw.LDAPSchemaAUX;
import org.dmd.dmr.shared.ldap.generated.dmo.LDAPClassAUXDMO;
import org.dmd.dms.ActionDefinition;
import org.dmd.dms.AttributeDefinition;
import org.dmd.dms.ClassDefinition;
import org.dmd.dms.EnumDefinition;
import org.dmd.dms.MetaSchema;
import org.dmd.dms.SchemaDefinition;
import org.dmd.dms.SchemaExtensionIF;
import org.dmd.dms.SchemaManager;
import org.dmd.dms.TypeDefinition;
import org.dmd.dms.generated.enums.DataTypeEnum;
import org.dmd.util.exceptions.DebugInfo;
import org.dmd.util.exceptions.ResultException;

public class LDAPSchemaExtension
implements SchemaExtensionIF {
    SchemaManager manager = null;
    DmrldapSchemaAG ourSchema;
    SchemaDefinition currSchema;
    boolean payAttention;
    String ldapIdPrefix;

    public LDAPSchemaExtension() {
        try {
            this.ourSchema = new DmrldapSchemaAG().getInstance();
        }
        catch (DmcValueException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addAction(ActionDefinition def) throws ResultException, DmcValueException {
    }

    @Override
    public void addAttribute(AttributeDefinition def) throws ResultException, DmcValueException {
        if (this.payAttention && def.getDataType() == DataTypeEnum.PERSISTENT) {
            LDAPAttributeAUX.setReposName(def, this.ldapIdPrefix + def.getName());
        }
    }

    @Override
    public void addClass(ClassDefinition def) throws ResultException, DmcValueException {
        DebugInfo.debug(def.getName().getNameString());
        if (this.payAttention) {
            DebugInfo.debug("paying attention: " + def.getName());
            if (def.getDerivedFrom() == DmrldapSchemaAG._LDAPHierarchicObject) {
                if (!LDAPClassAUX.hasAux(def)) {
                    def.addAux(DmrldapSchemaAG._LDAPClassAUX);
                }
                if (LDAPClassAUXDMO.getNamingAttribute(def.getDmcObject()) == null) {
                    ResultException ex = new ResultException();
                    ex.addError("The " + def.getName() + " class has the LDAPClassAUX extension but doesn't specify a namingAttribute.");
                    ex.setLocationInfo(def.getFile(), def.getLineNumber());
                    throw ex;
                }
            }
        }
    }

    @Override
    public void addEnum(EnumDefinition def) throws ResultException, DmcValueException {
    }

    @Override
    public void addSchema(SchemaDefinition def) throws ResultException, DmcValueException {
    }

    @Override
    public void addType(TypeDefinition def) throws ResultException, DmcValueException {
    }

    @Override
    public void setManager(SchemaManager sm) {
        this.manager = sm;
    }

    @Override
    public void schemaBeingLoaded(SchemaDefinition sd) throws ResultException {
        this.currSchema = sd;
        this.payAttention = LDAPSchemaAUX.hasAux(sd);
        if (this.payAttention) {
            this.ldapIdPrefix = LDAPSchemaAUX.getLdapIdPrefix(sd);
            if (this.ldapIdPrefix == null) {
                ResultException ex = new ResultException();
                ex.addError("The " + sd.getName() + " schema has the LDAPSchemaAUX extension but doesn't specify the ldapIdPrefix attribute.");
                ex.setLocationInfo(sd.getFile(), 0);
                throw ex;
            }
        } else {
            Iterator<String> extList = sd.getSchemaExtension();
            if (extList != null) {
                while (extList.hasNext()) {
                    if (!extList.next().equals("org.dmd.dmr.server.ldap.util.LDAPSchemaExtension")) continue;
                    ResultException ex = new ResultException();
                    ex.addError("The " + sd.getName() + " schema specifies the LDAPSchemaExtension but doesn't have the LDAPSchemaAUX class.");
                    ex.result.lastResult().moreMessages("You must decorate the SchemaDefinition with LDAPSchemaAUX and specify the ldapIdPrefix.");
                    ex.setLocationInfo(sd.getFile(), 0);
                    throw ex;
                }
            }
        }
    }

    @Override
    public void definitionPreAdd(DmcUncheckedObject uco) throws DmcValueException {
        String ccn = uco.classes.get(0);
        if (!ccn.equals(MetaSchema._AttributeDefinition.getName()) && !ccn.equals(MetaSchema._ClassDefinition.getName()) && ccn.equals(MetaSchema._SchemaDefinition.getName())) {
            uco.addAux(DmrldapSchemaAG._LDAPSchemaAUX.getName().getNameString());
        }
    }

    @Override
    public SchemaDefinition getExtensionSchema() {
        return this.ourSchema;
    }
}

