/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmr.shared.base.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmr.shared.base.generated.types.DmcTypeDotNamedObjectREF;
import org.dmd.dmr.shared.base.generated.types.DotNamedObjectREF;
import org.dmd.dms.generated.enums.ValueTypeEnum;

public class DmcTypeDotNamedObjectREFSET
extends DmcTypeDotNamedObjectREF
implements Serializable {
    private static final Iterator<DotNamedObjectREF> emptyList = new HashSet().iterator();
    protected Set<DotNamedObjectREF> value;

    public DmcTypeDotNamedObjectREFSET() {
        this.value = null;
    }

    public DmcTypeDotNamedObjectREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<DotNamedObjectREF>() : new TreeSet<DotNamedObjectREF>();
    }

    public DmcTypeDotNamedObjectREFSET getNew() {
        return new DmcTypeDotNamedObjectREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<DotNamedObjectREF> cloneIt() {
        DmcTypeDotNamedObjectREFSET dmcTypeDotNamedObjectREFSET = this;
        synchronized (dmcTypeDotNamedObjectREFSET) {
            DmcTypeDotNamedObjectREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (DotNamedObjectREF val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DotNamedObjectREF add(Object v) throws DmcValueException {
        DmcTypeDotNamedObjectREFSET dmcTypeDotNamedObjectREFSET = this;
        synchronized (dmcTypeDotNamedObjectREFSET) {
            DotNamedObjectREF rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DotNamedObjectREF del(Object v) {
        DmcTypeDotNamedObjectREFSET dmcTypeDotNamedObjectREFSET = this;
        synchronized (dmcTypeDotNamedObjectREFSET) {
            DotNamedObjectREF rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<DotNamedObjectREF> getMV() {
        DmcTypeDotNamedObjectREFSET dmcTypeDotNamedObjectREFSET = this;
        synchronized (dmcTypeDotNamedObjectREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<DotNamedObjectREF>(this.value).iterator();
            }
            return new TreeSet<DotNamedObjectREF>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DotNamedObjectREF> getMVCopy() {
        DmcTypeDotNamedObjectREFSET dmcTypeDotNamedObjectREFSET = this;
        synchronized (dmcTypeDotNamedObjectREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<DotNamedObjectREF>();
                }
                return new HashSet<DotNamedObjectREF>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<DotNamedObjectREF>(this.value);
            }
            return new TreeSet<DotNamedObjectREF>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeDotNamedObjectREFSET dmcTypeDotNamedObjectREFSET = this;
        synchronized (dmcTypeDotNamedObjectREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeDotNamedObjectREFSET dmcTypeDotNamedObjectREFSET = this;
        synchronized (dmcTypeDotNamedObjectREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                DotNamedObjectREF val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

