/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmr.shared.base.generated.types;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.FullyQualifiedName;
import org.dmd.dmr.shared.base.generated.types.DmcTypeHierarchicObjectREF;
import org.dmd.dmr.shared.base.generated.types.HierarchicObjectREF;
import org.dmd.dms.generated.enums.ValueTypeEnum;

public class DmcTypeHierarchicObjectREFMAP
extends DmcTypeHierarchicObjectREF
implements Serializable {
    private static final Iterator<HierarchicObjectREF> emptyList = new HashMap().values().iterator();
    protected Map<FullyQualifiedName, HierarchicObjectREF> value;

    public DmcTypeHierarchicObjectREFMAP() {
        this.value = null;
    }

    public DmcTypeHierarchicObjectREFMAP(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? new HashMap<FullyQualifiedName, HierarchicObjectREF>() : new TreeMap<FullyQualifiedName, HierarchicObjectREF>();
    }

    public FullyQualifiedName firstKey() {
        if (this.getAttributeInfo().valueType == ValueTypeEnum.TREEMAPPED) {
            if (this.value == null) {
                return null;
            }
            TreeMap map = (TreeMap)this.value;
            return (FullyQualifiedName)map.firstKey();
        }
        throw new IllegalStateException("Attribute " + this.getAttributeInfo().name + " is HASHMAPPED and doesn't support firstKey()");
    }

    public DmcTypeHierarchicObjectREFMAP getNew() {
        return new DmcTypeHierarchicObjectREFMAP(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<HierarchicObjectREF> cloneIt() {
        DmcTypeHierarchicObjectREFMAP dmcTypeHierarchicObjectREFMAP = this;
        synchronized (dmcTypeHierarchicObjectREFMAP) {
            DmcTypeHierarchicObjectREFMAP rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (HierarchicObjectREF val : this.value.values()) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HierarchicObjectREF add(Object v) throws DmcValueException {
        DmcTypeHierarchicObjectREFMAP dmcTypeHierarchicObjectREFMAP = this;
        synchronized (dmcTypeHierarchicObjectREFMAP) {
            FullyQualifiedName key;
            HierarchicObjectREF oldval;
            HierarchicObjectREF newval = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if ((oldval = this.value.put(key = (FullyQualifiedName)newval.getKey(), newval)) != null && oldval.valuesAreEqual(newval)) {
                newval = null;
            }
            return newval;
        }
    }

    @Override
    public HierarchicObjectREF del(Object key) {
        DmcTypeHierarchicObjectREFMAP dmcTypeHierarchicObjectREFMAP = this;
        synchronized (dmcTypeHierarchicObjectREFMAP) {
            if (this.value == null) {
                return null;
            }
            if (key instanceof FullyQualifiedName) {
                return this.value.remove(key);
            }
            throw new IllegalStateException("Incompatible key type: " + key.getClass().getName() + " passed to del():" + this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<HierarchicObjectREF> getMV() {
        DmcTypeHierarchicObjectREFMAP dmcTypeHierarchicObjectREFMAP = this;
        synchronized (dmcTypeHierarchicObjectREFMAP) {
            if (this.value == null) {
                return emptyList;
            }
            AbstractMap clone = null;
            clone = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? new HashMap<FullyQualifiedName, HierarchicObjectREF>(this.value) : new TreeMap<FullyQualifiedName, HierarchicObjectREF>(this.value);
            return clone.values().iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<FullyQualifiedName, HierarchicObjectREF> getMVCopy() {
        DmcTypeHierarchicObjectREFMAP dmcTypeHierarchicObjectREFMAP = this;
        synchronized (dmcTypeHierarchicObjectREFMAP) {
            AbstractMap clone = null;
            clone = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? (this.value == null ? new HashMap() : new HashMap<FullyQualifiedName, HierarchicObjectREF>(this.value)) : (this.value == null ? new TreeMap() : new TreeMap<FullyQualifiedName, HierarchicObjectREF>(this.value));
            return clone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeHierarchicObjectREFMAP dmcTypeHierarchicObjectREFMAP = this;
        synchronized (dmcTypeHierarchicObjectREFMAP) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    @Override
    public HierarchicObjectREF getByKey(Object key) {
        DmcTypeHierarchicObjectREFMAP dmcTypeHierarchicObjectREFMAP = this;
        synchronized (dmcTypeHierarchicObjectREFMAP) {
            if (this.value == null) {
                return null;
            }
            if (key instanceof FullyQualifiedName) {
                return this.value.get((FullyQualifiedName)key);
            }
            throw new IllegalStateException("Incompatible type: " + key.getClass().getName() + " passed to del():" + this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeHierarchicObjectREFMAP dmcTypeHierarchicObjectREFMAP = this;
        synchronized (dmcTypeHierarchicObjectREFMAP) {
            if (this.value == null) {
                return false;
            }
            try {
                HierarchicObjectREF val = this.typeCheck(v);
                return this.value.containsValue(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        DmcTypeHierarchicObjectREFMAP dmcTypeHierarchicObjectREFMAP = this;
        synchronized (dmcTypeHierarchicObjectREFMAP) {
            if (this.value == null) {
                return false;
            }
            if (key instanceof FullyQualifiedName) {
                return this.value.containsKey(key);
            }
            return false;
        }
    }
}

