/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmr.shared.base.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmr.shared.base.generated.types.DmcTypeHierarchicObjectREF;
import org.dmd.dmr.shared.base.generated.types.HierarchicObjectREF;
import org.dmd.dms.generated.enums.ValueTypeEnum;

public class DmcTypeHierarchicObjectREFSET
extends DmcTypeHierarchicObjectREF
implements Serializable {
    private static final Iterator<HierarchicObjectREF> emptyList = new HashSet().iterator();
    protected Set<HierarchicObjectREF> value;

    public DmcTypeHierarchicObjectREFSET() {
        this.value = null;
    }

    public DmcTypeHierarchicObjectREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<HierarchicObjectREF>() : new TreeSet<HierarchicObjectREF>();
    }

    public DmcTypeHierarchicObjectREFSET getNew() {
        return new DmcTypeHierarchicObjectREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<HierarchicObjectREF> cloneIt() {
        DmcTypeHierarchicObjectREFSET dmcTypeHierarchicObjectREFSET = this;
        synchronized (dmcTypeHierarchicObjectREFSET) {
            DmcTypeHierarchicObjectREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (HierarchicObjectREF val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HierarchicObjectREF add(Object v) throws DmcValueException {
        DmcTypeHierarchicObjectREFSET dmcTypeHierarchicObjectREFSET = this;
        synchronized (dmcTypeHierarchicObjectREFSET) {
            HierarchicObjectREF rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HierarchicObjectREF del(Object v) {
        DmcTypeHierarchicObjectREFSET dmcTypeHierarchicObjectREFSET = this;
        synchronized (dmcTypeHierarchicObjectREFSET) {
            HierarchicObjectREF rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<HierarchicObjectREF> getMV() {
        DmcTypeHierarchicObjectREFSET dmcTypeHierarchicObjectREFSET = this;
        synchronized (dmcTypeHierarchicObjectREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<HierarchicObjectREF>(this.value).iterator();
            }
            return new TreeSet<HierarchicObjectREF>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<HierarchicObjectREF> getMVCopy() {
        DmcTypeHierarchicObjectREFSET dmcTypeHierarchicObjectREFSET = this;
        synchronized (dmcTypeHierarchicObjectREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<HierarchicObjectREF>();
                }
                return new HashSet<HierarchicObjectREF>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<HierarchicObjectREF>(this.value);
            }
            return new TreeSet<HierarchicObjectREF>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeHierarchicObjectREFSET dmcTypeHierarchicObjectREFSET = this;
        synchronized (dmcTypeHierarchicObjectREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeHierarchicObjectREFSET dmcTypeHierarchicObjectREFSET = this;
        synchronized (dmcTypeHierarchicObjectREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                HierarchicObjectREF val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

