/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmr.shared.ldap.generated.types;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.FullyQualifiedName;
import org.dmd.dmr.shared.ldap.generated.types.DmcTypeLDAPHierarchicObjectREF;
import org.dmd.dmr.shared.ldap.generated.types.LDAPHierarchicObjectREF;
import org.dmd.dms.generated.enums.ValueTypeEnum;

public class DmcTypeLDAPHierarchicObjectREFMAP
extends DmcTypeLDAPHierarchicObjectREF
implements Serializable {
    private static final Iterator<LDAPHierarchicObjectREF> emptyList = new HashMap().values().iterator();
    protected Map<FullyQualifiedName, LDAPHierarchicObjectREF> value;

    public DmcTypeLDAPHierarchicObjectREFMAP() {
        this.value = null;
    }

    public DmcTypeLDAPHierarchicObjectREFMAP(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? new HashMap<FullyQualifiedName, LDAPHierarchicObjectREF>() : new TreeMap<FullyQualifiedName, LDAPHierarchicObjectREF>();
    }

    public FullyQualifiedName firstKey() {
        if (this.getAttributeInfo().valueType == ValueTypeEnum.TREEMAPPED) {
            if (this.value == null) {
                return null;
            }
            TreeMap map = (TreeMap)this.value;
            return (FullyQualifiedName)map.firstKey();
        }
        throw new IllegalStateException("Attribute " + this.getAttributeInfo().name + " is HASHMAPPED and doesn't support firstKey()");
    }

    public DmcTypeLDAPHierarchicObjectREFMAP getNew() {
        return new DmcTypeLDAPHierarchicObjectREFMAP(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<LDAPHierarchicObjectREF> cloneIt() {
        DmcTypeLDAPHierarchicObjectREFMAP dmcTypeLDAPHierarchicObjectREFMAP = this;
        synchronized (dmcTypeLDAPHierarchicObjectREFMAP) {
            DmcTypeLDAPHierarchicObjectREFMAP rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (LDAPHierarchicObjectREF val : this.value.values()) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LDAPHierarchicObjectREF add(Object v) throws DmcValueException {
        DmcTypeLDAPHierarchicObjectREFMAP dmcTypeLDAPHierarchicObjectREFMAP = this;
        synchronized (dmcTypeLDAPHierarchicObjectREFMAP) {
            FullyQualifiedName key;
            LDAPHierarchicObjectREF oldval;
            LDAPHierarchicObjectREF newval = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if ((oldval = this.value.put(key = (FullyQualifiedName)newval.getKey(), newval)) != null && oldval.valuesAreEqual(newval)) {
                newval = null;
            }
            return newval;
        }
    }

    @Override
    public LDAPHierarchicObjectREF del(Object key) {
        DmcTypeLDAPHierarchicObjectREFMAP dmcTypeLDAPHierarchicObjectREFMAP = this;
        synchronized (dmcTypeLDAPHierarchicObjectREFMAP) {
            if (this.value == null) {
                return null;
            }
            if (key instanceof FullyQualifiedName) {
                return this.value.remove(key);
            }
            throw new IllegalStateException("Incompatible key type: " + key.getClass().getName() + " passed to del():" + this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<LDAPHierarchicObjectREF> getMV() {
        DmcTypeLDAPHierarchicObjectREFMAP dmcTypeLDAPHierarchicObjectREFMAP = this;
        synchronized (dmcTypeLDAPHierarchicObjectREFMAP) {
            if (this.value == null) {
                return emptyList;
            }
            AbstractMap clone = null;
            clone = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? new HashMap<FullyQualifiedName, LDAPHierarchicObjectREF>(this.value) : new TreeMap<FullyQualifiedName, LDAPHierarchicObjectREF>(this.value);
            return clone.values().iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<FullyQualifiedName, LDAPHierarchicObjectREF> getMVCopy() {
        DmcTypeLDAPHierarchicObjectREFMAP dmcTypeLDAPHierarchicObjectREFMAP = this;
        synchronized (dmcTypeLDAPHierarchicObjectREFMAP) {
            AbstractMap clone = null;
            clone = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? (this.value == null ? new HashMap() : new HashMap<FullyQualifiedName, LDAPHierarchicObjectREF>(this.value)) : (this.value == null ? new TreeMap() : new TreeMap<FullyQualifiedName, LDAPHierarchicObjectREF>(this.value));
            return clone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeLDAPHierarchicObjectREFMAP dmcTypeLDAPHierarchicObjectREFMAP = this;
        synchronized (dmcTypeLDAPHierarchicObjectREFMAP) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    @Override
    public LDAPHierarchicObjectREF getByKey(Object key) {
        DmcTypeLDAPHierarchicObjectREFMAP dmcTypeLDAPHierarchicObjectREFMAP = this;
        synchronized (dmcTypeLDAPHierarchicObjectREFMAP) {
            if (this.value == null) {
                return null;
            }
            if (key instanceof FullyQualifiedName) {
                return this.value.get((FullyQualifiedName)key);
            }
            throw new IllegalStateException("Incompatible type: " + key.getClass().getName() + " passed to del():" + this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeLDAPHierarchicObjectREFMAP dmcTypeLDAPHierarchicObjectREFMAP = this;
        synchronized (dmcTypeLDAPHierarchicObjectREFMAP) {
            if (this.value == null) {
                return false;
            }
            try {
                LDAPHierarchicObjectREF val = this.typeCheck(v);
                return this.value.containsValue(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        DmcTypeLDAPHierarchicObjectREFMAP dmcTypeLDAPHierarchicObjectREFMAP = this;
        synchronized (dmcTypeLDAPHierarchicObjectREFMAP) {
            if (this.value == null) {
                return false;
            }
            if (key instanceof FullyQualifiedName) {
                return this.value.containsKey(key);
            }
            return false;
        }
    }
}

