/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmr.shared.ldap.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmr.shared.ldap.generated.types.DmcTypeLDAPHierarchicObjectREF;
import org.dmd.dmr.shared.ldap.generated.types.LDAPHierarchicObjectREF;
import org.dmd.dms.generated.enums.ValueTypeEnum;

public class DmcTypeLDAPHierarchicObjectREFSET
extends DmcTypeLDAPHierarchicObjectREF
implements Serializable {
    private static final Iterator<LDAPHierarchicObjectREF> emptyList = new HashSet().iterator();
    protected Set<LDAPHierarchicObjectREF> value;

    public DmcTypeLDAPHierarchicObjectREFSET() {
        this.value = null;
    }

    public DmcTypeLDAPHierarchicObjectREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<LDAPHierarchicObjectREF>() : new TreeSet<LDAPHierarchicObjectREF>();
    }

    public DmcTypeLDAPHierarchicObjectREFSET getNew() {
        return new DmcTypeLDAPHierarchicObjectREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<LDAPHierarchicObjectREF> cloneIt() {
        DmcTypeLDAPHierarchicObjectREFSET dmcTypeLDAPHierarchicObjectREFSET = this;
        synchronized (dmcTypeLDAPHierarchicObjectREFSET) {
            DmcTypeLDAPHierarchicObjectREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (LDAPHierarchicObjectREF val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LDAPHierarchicObjectREF add(Object v) throws DmcValueException {
        DmcTypeLDAPHierarchicObjectREFSET dmcTypeLDAPHierarchicObjectREFSET = this;
        synchronized (dmcTypeLDAPHierarchicObjectREFSET) {
            LDAPHierarchicObjectREF rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LDAPHierarchicObjectREF del(Object v) {
        DmcTypeLDAPHierarchicObjectREFSET dmcTypeLDAPHierarchicObjectREFSET = this;
        synchronized (dmcTypeLDAPHierarchicObjectREFSET) {
            LDAPHierarchicObjectREF rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<LDAPHierarchicObjectREF> getMV() {
        DmcTypeLDAPHierarchicObjectREFSET dmcTypeLDAPHierarchicObjectREFSET = this;
        synchronized (dmcTypeLDAPHierarchicObjectREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<LDAPHierarchicObjectREF>(this.value).iterator();
            }
            return new TreeSet<LDAPHierarchicObjectREF>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<LDAPHierarchicObjectREF> getMVCopy() {
        DmcTypeLDAPHierarchicObjectREFSET dmcTypeLDAPHierarchicObjectREFSET = this;
        synchronized (dmcTypeLDAPHierarchicObjectREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<LDAPHierarchicObjectREF>();
                }
                return new HashSet<LDAPHierarchicObjectREF>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<LDAPHierarchicObjectREF>(this.value);
            }
            return new TreeSet<LDAPHierarchicObjectREF>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeLDAPHierarchicObjectREFSET dmcTypeLDAPHierarchicObjectREFSET = this;
        synchronized (dmcTypeLDAPHierarchicObjectREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeLDAPHierarchicObjectREFSET dmcTypeLDAPHierarchicObjectREFSET = this;
        synchronized (dmcTypeLDAPHierarchicObjectREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                LDAPHierarchicObjectREF val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

