/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms;

import java.util.ArrayList;
import java.util.Iterator;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcObject;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.util.NamedStringArray;
import org.dmd.dms.ActionDefinition;
import org.dmd.dms.ClassDefinition;
import org.dmd.dms.MetaSchemaAG;
import org.dmd.dms.SchemaDefinition;
import org.dmd.dms.TypeDefinition;
import org.dmd.dms.generated.dmo.AttributeDefinitionDMO;
import org.dmd.dms.generated.dmo.MetaDMSAG;
import org.dmd.dms.generated.dmo.RuleDataDMO;
import org.dmd.dms.generated.dmw.AttributeDefinitionDMW;
import org.dmd.dms.generated.dmw.SchemaDefinitionDMW;
import org.dmd.dms.generated.enums.ValueTypeEnum;

public class AttributeDefinition
extends AttributeDefinitionDMW {
    TypeDefinition typeDef;
    ArrayList<ClassDefinition> usedByClasses;
    ArrayList<ActionDefinition> usedByActions;
    ArrayList<RuleDataDMO> classRules;
    ArrayList<RuleDataDMO> globalRules;
    DmcAttributeInfo attrInfo;

    public AttributeDefinition() {
        super(new AttributeDefinitionDMO(), MetaSchemaAG._AttributeDefinition);
        this.attrInfo = null;
    }

    public AttributeDefinition(AttributeDefinitionDMO obj) {
        super(obj);
        this.attrInfo = null;
    }

    public int getUsedByActionsSize() {
        if (this.usedByActions == null) {
            return 0;
        }
        return this.usedByActions.size();
    }

    public ActionDefinition getUsedByActionsNth(int i) {
        if (this.usedByActions == null) {
            return null;
        }
        return this.usedByActions.get(i);
    }

    public int getUsedByClassesSize() {
        if (this.usedByClasses == null) {
            return 0;
        }
        return this.usedByClasses.size();
    }

    public ClassDefinition getUsedByClassesNth(int i) {
        if (this.usedByClasses == null) {
            return null;
        }
        return this.usedByClasses.get(i);
    }

    public boolean hasRules() {
        if (this.classRules == null) {
            this.getClassRules();
        }
        return this.classRules.size() > 0 || this.globalRules.size() > 0;
    }

    public Iterator<RuleDataDMO> getClassRules() {
        if (this.classRules == null) {
            this.classRules = new ArrayList();
            this.globalRules = new ArrayList();
            ArrayList<DmcObject> referring = this.getDMO().getReferringObjects();
            if (referring != null) {
                for (DmcObject obj : referring) {
                    RuleDataDMO rd;
                    if (!(obj instanceof RuleDataDMO) || (rd = (RuleDataDMO)obj).get(MetaDMSAG.__applyToAttribute) == null) continue;
                    if (rd.getApplyToClass() == null) {
                        this.globalRules.add(rd);
                        continue;
                    }
                    this.classRules.add(rd);
                }
            }
        }
        return this.classRules.iterator();
    }

    public Iterator<RuleDataDMO> getGlobalRules() {
        if (this.globalRules == null) {
            this.getClassRules();
        }
        return this.globalRules.iterator();
    }

    AttributeDefinition(String n, TypeDefinition td) throws DmcValueException {
        super(n);
        this.typeDef = td;
        this.attrInfo = null;
    }

    protected AttributeDefinition(String mn) throws DmcValueException {
        super(mn);
        this.attrInfo = null;
    }

    void addUsingClass(ClassDefinition cd) {
        if (this.usedByClasses == null) {
            this.usedByClasses = new ArrayList();
        }
        if (!this.usedByClasses.contains(cd)) {
            this.usedByClasses.add(cd);
        }
    }

    void addUsingAction(ActionDefinition ad) {
        if (this.usedByActions == null) {
            this.usedByActions = new ArrayList();
        }
        if (!this.usedByActions.contains(ad)) {
            this.usedByActions.add(ad);
        }
    }

    public DmcAttributeInfo getAttributeInfo() {
        if (this.attrInfo == null) {
            int indexSize = 0;
            if (this.getIndexSize() != null) {
                indexSize = this.getIndexSize();
            }
            boolean weakRef = false;
            if (this.getWeakReference() != null) {
                weakRef = this.getWeakReference();
            }
            this.attrInfo = new DmcAttributeInfo(((SchemaDefinitionDMW)this.getDefinedIn()).getName().getNameString(), this.getName().getNameString(), this.getDmdID(), this.getType().getName().getNameString(), this.getValueType(), this.getDataType(), indexSize, weakRef);
        }
        return this.attrInfo;
    }

    public DmcAttribute<?> getAttributeInstance(DmcAttributeInfo ai) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        DmcAttribute<?> rc = this.getType().getAttributeHolder(ai);
        rc.setAttributeInfo(ai);
        return rc;
    }

    public String getDMSAGReference() {
        return ((SchemaDefinition)this.getDefinedIn()).getDMSASGName() + ".__" + this.getName();
    }

    public String getAdapterClassImport() {
        return ((SchemaDefinitionDMW)this.getType().getDefinedIn()).getSchemaPackage() + ".generated.types.adapters." + this.getAdapterClassName();
    }

    public String getAdapterClassName() {
        String suffix = "";
        String REF = "";
        if (this.getType().getIsRefType().booleanValue() && !this.getType().getIsExtendedRefType().booleanValue() && this.getType().getOriginalClass().getIsNamedBy() != null) {
            REF = "REF";
        }
        switch (this.getValueType()) {
            case HASHMAPPED: 
            case TREEMAPPED: {
                suffix = "MAP";
                break;
            }
            case HASHSET: 
            case TREESET: {
                suffix = "SET";
                break;
            }
            case MULTI: {
                suffix = "MV";
                break;
            }
            case SINGLE: {
                suffix = "SV";
            }
        }
        return this.getType().getName() + REF + suffix + "Adapter";
    }

    public String getTypeImport() {
        return this.getType().getTypeImport(this);
    }

    public String getContainerType() {
        return this.getType().getContainerType(this);
    }

    public String getValueModificationStatement(int uniqueNum, String indent, String prepend, NamedStringArray values) {
        StringBuffer sb = new StringBuffer();
        if (this.getValueType() == ValueTypeEnum.SINGLE) {
            sb.append(indent + this.getContainerType() + " " + values.getName() + "Value" + uniqueNum + " = null;\n");
            for (String value : values) {
                sb.append(indent + values.getName() + "Value" + uniqueNum + " = new " + this.getContainerType() + "(" + this.getDMSAGReference() + ");\n");
                sb.append(indent + values.getName() + "Value" + uniqueNum + ".set(\"" + value + "\");\n");
                sb.append(prepend + ".set(" + this.getDMSAGReference() + ", " + values.getName() + "Value" + uniqueNum + ");\n");
            }
        } else {
            sb.append(indent + this.getContainerType() + " " + values.getName() + "Value" + uniqueNum + " = new " + this.getContainerType() + "(" + this.getDMSAGReference() + ");\n");
            for (String value : values) {
                sb.append(indent + values.getName() + "Value" + uniqueNum + ".add(\"" + value + "\");\n");
            }
            sb.append(prepend + ".add(" + this.getDMSAGReference() + ", " + values.getName() + "Value" + uniqueNum + ");\n");
        }
        return sb.toString();
    }

    public String getValueModificationStatement(int uniqueNum, String indent, String prepend, DmcAttribute<?> attr) {
        StringBuffer sb = new StringBuffer();
        if (this.getValueType() == ValueTypeEnum.SINGLE) {
            sb.append(indent + this.getContainerType() + " " + attr.getName() + "Value" + uniqueNum + " = null;\n");
            sb.append(indent + attr.getName() + "Value" + uniqueNum + " = new " + this.getContainerType() + "(" + this.getDMSAGReference() + ");\n");
            sb.append(indent + attr.getName() + "Value" + uniqueNum + ".set(\"" + attr.getSV().toString() + "\");\n");
            sb.append(prepend + ".set(" + this.getDMSAGReference() + ", " + attr.getName() + "Value" + uniqueNum + ");\n");
        } else {
            sb.append(indent + this.getContainerType() + " " + attr.getName() + "Value" + uniqueNum + " = new " + this.getContainerType() + "(" + this.getDMSAGReference() + ");\n");
            Iterator<?> vals = attr.getMV();
            while (vals.hasNext()) {
                Object val = vals.next();
                sb.append(indent + attr.getName() + "Value" + uniqueNum + ".add(\"" + val.toString() + "\");\n");
            }
            sb.append(prepend + ".add(" + this.getDMSAGReference() + ", " + attr.getName() + "Value" + uniqueNum + ");\n");
        }
        return sb.toString();
    }
}

