/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcClassInfo;
import org.dmd.dmc.DmcObject;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.DefinitionName;
import org.dmd.dmc.types.IntegerVar;
import org.dmd.dmc.util.DmcUncheckedObject;
import org.dmd.dms.ActionDefinition;
import org.dmd.dms.AttributeDefinition;
import org.dmd.dms.MetaSchemaAG;
import org.dmd.dms.SchemaDefinition;
import org.dmd.dms.SchemaManager;
import org.dmd.dms.generated.dmo.ClassDefinitionDMO;
import org.dmd.dms.generated.dmo.MetaDMSAG;
import org.dmd.dms.generated.dmo.RuleDataDMO;
import org.dmd.dms.generated.dmw.AttributeDefinitionIterableDMW;
import org.dmd.dms.generated.dmw.ClassDefinitionDMW;
import org.dmd.dms.generated.dmw.ClassDefinitionIterableDMW;
import org.dmd.dms.generated.dmw.SchemaDefinitionDMW;
import org.dmd.dms.generated.enums.ClassTypeEnum;
import org.dmd.dms.generated.enums.WrapperTypeEnum;
import org.dmd.dms.generated.types.DmwTypeToWrapperType;
import org.dmd.dmw.DmwWrapper;
import org.dmd.util.codegen.ImportManager;
import org.dmd.util.exceptions.DebugInfo;
import org.dmd.util.exceptions.ResultException;

public class ClassDefinition
extends ClassDefinitionDMW {
    String shortest;
    Class<?> genobjclass;
    Class<?> dmoClass;
    TreeMap<DefinitionName, AttributeDefinition> attrMap;
    TreeMap<DefinitionName, AttributeDefinition> fullAttrMap;
    ArrayList<AttributeDefinition> persistentMust;
    ArrayList<AttributeDefinition> allPersistentMust;
    ArrayList<AttributeDefinition> persistentMay;
    ArrayList<AttributeDefinition> allPersistentMay;
    ArrayList<AttributeDefinition> cached;
    ArrayList<AttributeDefinition> allOnDemand;
    ArrayList<AttributeDefinition> allTransReplicated;
    ArrayList<AttributeDefinition> allTransientAndCached;
    TreeMap<DefinitionName, AttributeDefinition> allMust;
    TreeMap<DefinitionName, AttributeDefinition> allMay;
    ArrayList<ClassDefinition> baseClasses;
    TreeMap<DefinitionName, ClassDefinition> allDerived;
    TreeMap<DefinitionName, ClassDefinition> allowedSubcomps;
    ArrayList<ActionDefinition> attachedActions;
    HashMap<DefinitionName, ActionDefinition> allActions;
    HashMap<String, DmwTypeToWrapperType> wrapperTypeMap;
    private ArrayList<ClassDefinition> allImplemented;
    private ArrayList<ClassDefinition> allImplementors;
    DefinitionName nameKey;
    DmcClassInfo classInfo;
    ArrayList<RuleDataDMO> classRules;

    public ClassDefinition() {
        super(new ClassDefinitionDMO(), MetaSchemaAG._ClassDefinition);
        this.init();
        this.classInfo = null;
    }

    public ClassDefinition(ClassDefinitionDMO obj) {
        super(obj);
        this.init();
        this.classInfo = null;
    }

    public ClassDefinition(ClassDefinitionDMO obj, DmcClassInfo dci) {
        super(obj);
        this.init();
        this.classInfo = dci;
    }

    public DmcClassInfo getClassInfo() {
        return this.classInfo;
    }

    public DmcClassInfo getDynamicClassInfo() {
        if (this.classInfo == null) {
            DmcAttributeInfo na = null;
            if (this.getIsNamedBy() != null) {
                na = this.getIsNamedBy().getAttributeInfo();
            }
            this.classInfo = this.getDerivedFrom() == null ? new DmcClassInfo(this.getName().getNameString(), this.getDmoImport(), this.getDmdID(), this.getClassType(), this.getDataType(), null, na) : new DmcClassInfo(this.getName().getNameString(), this.getDmoImport(), this.getDmdID(), this.getClassType(), this.getDataType(), this.getDerivedFrom().getDynamicClassInfo(), na);
            if (this.getMaySize() > 0) {
                for (AttributeDefinition ad : this.getMay()) {
                    this.classInfo.addMay(ad.getAttributeInfo());
                }
            }
            if (this.getMustSize() > 0) {
                for (AttributeDefinition ad : this.getMust()) {
                    this.classInfo.addMust(ad.getAttributeInfo());
                }
            }
        }
        return this.classInfo;
    }

    public boolean allowsParent(ClassDefinition parent) {
        boolean rc = false;
        if (this.getAllowedParentsSize() > 0) {
            for (ClassDefinition cd : this.getAllowedParents()) {
                if (cd != parent) continue;
                rc = true;
                break;
            }
        }
        return rc;
    }

    protected ClassDefinition(String mn) throws DmcValueException {
        super(mn);
        this.init();
    }

    private void init() {
        this.attrMap = null;
        this.persistentMust = null;
        this.persistentMay = null;
        this.cached = null;
        this.allOnDemand = null;
        this.allMust = null;
        this.allMay = null;
        this.baseClasses = null;
        this.allDerived = null;
        this.allowedSubcomps = null;
        this.attachedActions = null;
        this.allActions = null;
        this.nameKey = new DefinitionName();
    }

    public AttributeDefinition hasAttribute(String name) {
        try {
            this.nameKey.setNameString(name);
        }
        catch (DmcValueException e) {
            e.printStackTrace();
        }
        return this.hasAttribute(this.nameKey);
    }

    public boolean isMust(DefinitionName name) {
        if (this.fullAttrMap == null) {
            this.getFullAttrMap();
        }
        return this.allMust.get(name) != null;
    }

    public boolean isAllowedAttribute(DefinitionName name) {
        if (this.fullAttrMap == null) {
            this.getFullAttrMap();
        }
        return this.fullAttrMap.get(name) != null;
    }

    private void initAttrMap() {
        if (this.attrMap == null) {
            AttributeDefinition ad;
            this.attrMap = new TreeMap();
            AttributeDefinitionIterableDMW it = this.getMust();
            if (it != null) {
                while (it.hasNext()) {
                    ad = (AttributeDefinition)it.next();
                    this.attrMap.put(ad.getName(), ad);
                }
            }
            if ((it = this.getMay()) != null) {
                while (it.hasNext()) {
                    ad = (AttributeDefinition)it.next();
                    this.attrMap.put(ad.getName(), ad);
                }
            }
        }
    }

    public AttributeDefinition hasAttribute(DefinitionName attrName) {
        AttributeDefinition rc = null;
        this.initAttrMap();
        rc = this.attrMap.get(attrName);
        if (rc == null && this.getDerivedFrom() != null) {
            rc = this.getDerivedFrom().hasAttribute(attrName);
        }
        return rc;
    }

    void initFullAttrMap(TreeMap<DefinitionName, AttributeDefinition> map, TreeMap<DefinitionName, AttributeDefinition> must, TreeMap<DefinitionName, AttributeDefinition> may) {
        AttributeDefinition ad;
        AttributeDefinitionIterableDMW it = this.getMust();
        if (it != null) {
            while (it.hasNext()) {
                ad = (AttributeDefinition)it.next();
                map.put(ad.getName(), ad);
                must.put(ad.getName(), ad);
            }
        }
        if ((it = this.getMay()) != null) {
            while (it.hasNext()) {
                ad = (AttributeDefinition)it.next();
                map.put(ad.getName(), ad);
                may.put(ad.getName(), ad);
            }
        }
        if (this.getDerivedFrom() != null) {
            this.getDerivedFrom().initFullAttrMap(map, must, may);
        }
    }

    public TreeMap<DefinitionName, AttributeDefinition> getAllMust() {
        this.getFullAttrMap();
        return this.allMust;
    }

    public TreeMap<DefinitionName, AttributeDefinition> getAllMay() {
        this.getFullAttrMap();
        return this.allMay;
    }

    public TreeMap<DefinitionName, AttributeDefinition> getAllAttributesAtThisLevel() {
        this.initAttrMap();
        return this.attrMap;
    }

    public TreeMap<DefinitionName, AttributeDefinition> getFullAttrMap() {
        if (this.fullAttrMap == null) {
            this.fullAttrMap = new TreeMap();
            if (this.allMust == null) {
                this.allMust = new TreeMap();
            }
            if (this.allMay == null) {
                this.allMay = new TreeMap();
            }
            this.initFullAttrMap(this.fullAttrMap, this.allMust, this.allMay);
        }
        return this.fullAttrMap;
    }

    void updateDerived(ClassDefinition derived) throws ResultException, DmcValueException {
        this.addDerivedClasses(derived);
        this.updateAllDerived(derived);
    }

    void updateAllDerived(ClassDefinition derived) {
        if (this.allDerived == null) {
            this.allDerived = new TreeMap();
        }
        this.allDerived.put(derived.getObjectName(), derived);
        if (this.getDerivedFrom() != null) {
            this.getDerivedFrom().updateAllDerived(derived);
        }
    }

    public ArrayList<ClassDefinition> getAllImplemented() {
        return this.allImplemented;
    }

    void addSubcomp(ClassDefinition subcomp) {
        if (this.allowedSubcomps == null) {
            this.allowedSubcomps = new TreeMap();
        }
        this.allowedSubcomps.put(subcomp.getObjectName(), subcomp);
    }

    public TreeMap<DefinitionName, ClassDefinition> getAllDerived() {
        if (this.allDerived == null) {
            this.updateAllDerived(this);
        }
        return this.allDerived;
    }

    public ArrayList<ClassDefinition> getAllImplementors() {
        return this.allImplementors;
    }

    public TreeMap<DefinitionName, ClassDefinition> getAllowedSubcomps() {
        return this.allowedSubcomps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DmwWrapper newInstance() throws ResultException {
        DmwWrapper rc = null;
        if (this.genobjclass == null) {
            try {
                ClassDefinition classDefinition = this;
                synchronized (classDefinition) {
                    this.adjustJavaClass(this.getDMWPackage(), true);
                    this.genobjclass = Class.forName(this.getJavaClass());
                }
            }
            catch (Exception e) {
                ResultException ex = new ResultException(e);
                ex.result.addResult(4, "Couldn't load Java class: " + this.getJavaClass());
                ex.result.lastResult().moreMessages(e.getMessage());
                ex.result.lastResult().moreMessages(DebugInfo.extractTheStack(e));
                throw ex;
            }
        }
        if (this.genobjclass != null) {
            if (this.getClassType() == ClassTypeEnum.ABSTRACT) {
                ResultException ex = new ResultException();
                ex.result.addResult(3, "Can't instantiate an ABSTRACT class: " + this.getObjectName());
                throw ex;
            }
            try {
                rc = (DmwWrapper)this.genobjclass.newInstance();
            }
            catch (Exception e) {
                ResultException ex = new ResultException(e);
                ex.result.addResult(4, "Couldn't instantiate Java class: " + this.getJavaClass());
                ex.result.lastResult().moreMessages("This may be because the class doesn't have a constructor that takes no arguments.");
                ex.result.lastResult().moreMessages(DebugInfo.getCurrentStack());
                throw ex;
            }
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DmcObject newDMOInstance() throws ResultException {
        DmcObject rc = null;
        if (this.dmoClass == null) {
            try {
                ClassDefinition classDefinition = this;
                synchronized (classDefinition) {
                    this.dmoClass = Class.forName(this.getDmoImport());
                }
            }
            catch (Exception e) {
                ResultException ex = new ResultException();
                ex.result.addResult(4, "Couldn't load Java class: " + this.getJavaClass());
                ex.result.lastResult().moreMessages(e.getMessage());
                ex.result.lastResult().moreMessages(DebugInfo.extractTheStack(e));
                throw ex;
            }
        }
        if (this.dmoClass != null) {
            if (this.getClassType() == ClassTypeEnum.ABSTRACT) {
                ResultException ex = new ResultException();
                ex.result.addResult(3, "Can't instantiate an ABSTRACT class: " + this.getObjectName());
                throw ex;
            }
            try {
                rc = (DmcObject)this.dmoClass.newInstance();
            }
            catch (Exception e) {
                ResultException ex = new ResultException();
                ex.result.addResult(4, "Couldn't instantiate Java class: " + this.getJavaClass());
                ex.result.lastResult().moreMessages("This may be because the class doesn't have a constructor that takes no arguments.");
                ex.result.lastResult().moreMessages(DebugInfo.getCurrentStack());
                throw ex;
            }
        }
        return rc;
    }

    public boolean isInstanceOfThis(ClassDefinition cd) {
        boolean rc = false;
        if (this.getObjectName().getNameString().equals(cd.getName().getNameString())) {
            rc = true;
        } else {
            ArrayList<ClassDefinition> classes = this.getBaseClasses();
            if (classes != null) {
                for (ClassDefinition cdef : classes) {
                    if (!cd.getObjectName().getNameString().equals(cdef.getName().getNameString())) continue;
                    rc = true;
                    break;
                }
            }
        }
        return rc;
    }

    public ArrayList<ClassDefinition> getBaseClasses() {
        if (this.baseClasses == null && this.getDerivedFrom() != null) {
            this.baseClasses = new ArrayList();
            ArrayList<ClassDefinition> b = this.getDerivedFrom().getBaseClasses();
            if (b != null) {
                for (int i = 0; i < b.size(); ++i) {
                    this.baseClasses.add(b.get(i));
                }
            }
            this.baseClasses.add(this.getDerivedFrom());
        }
        return this.baseClasses;
    }

    public void adjustJavaClass() {
        String genPackage = this.getDMWPackage();
        this.adjustJavaClass(genPackage, false);
    }

    private void adjustJavaClass(String genPackage, boolean instantiating) {
        block12: {
            if (instantiating && this.getJavaClass().startsWith("org.dmd.dms")) {
                return;
            }
            if (this.getUseWrapperType() == WrapperTypeEnum.BASE) {
                try {
                    this.setJavaClass(genPackage + ".generated.dmw." + this.getName() + "DMW");
                }
                catch (DmcValueException e) {
                    e.printStackTrace();
                }
            } else if (this.getUseWrapperType() == WrapperTypeEnum.EXTENDED) {
                try {
                    if (this.getSubpackage() != null) {
                        this.setJavaClass(genPackage + ".extended." + this.getSubpackage() + "." + this.getName());
                        break block12;
                    }
                    this.setJavaClass(genPackage + ".extended." + this.getName());
                }
                catch (DmcValueException e) {
                    e.printStackTrace();
                }
            } else {
                return;
            }
        }
        try {
            this.setDmwImport(this.getJavaClass());
        }
        catch (DmcValueException e) {
            e.printStackTrace();
        }
    }

    public String getDMWPackage() {
        String rc = null;
        rc = ((SchemaDefinitionDMW)this.getDefinedIn()).getDmwPackage();
        return rc;
    }

    public void adjustJavaClass(String genContext, String genSuffix) {
        block12: {
            String genPackage = this.getDmwPackage(genContext);
            if (this.getDmwWrapperType(genContext) == WrapperTypeEnum.BASE) {
                try {
                    this.setJavaClass(genPackage + ".generated." + genContext + "." + this.getName() + genSuffix);
                }
                catch (DmcValueException e) {
                    e.printStackTrace();
                }
            } else if (this.getUseWrapperType() == WrapperTypeEnum.EXTENDED) {
                try {
                    if (((SchemaDefinitionDMW)this.getDefinedIn()).getName().getNameString().equals(MetaDMSAG.instance().getSchemaName())) {
                        this.setJavaClass(genPackage + "." + this.getName());
                        this.setDmeImport(genPackage + "." + this.getName());
                        break block12;
                    }
                    if (this.getSubpackage() != null) {
                        this.setJavaClass(genPackage + ".extended." + this.getSubpackage() + "." + this.getName());
                        this.setDmeImport(genPackage + ".extended." + this.getSubpackage() + "." + this.getName());
                        break block12;
                    }
                    this.setJavaClass(genPackage + ".extended." + this.getName());
                    this.setDmeImport(genPackage + ".extended." + this.getName());
                }
                catch (DmcValueException e) {
                    e.printStackTrace();
                }
            } else {
                return;
            }
        }
        try {
            this.setDmwImport(this.getJavaClass());
        }
        catch (DmcValueException e) {
            e.printStackTrace();
        }
    }

    public String getDmwPackage(String context) {
        return ((SchemaDefinition)this.getDefinedIn()).getDmwPackage(context);
    }

    public WrapperTypeEnum getDmwWrapperType(String context) {
        DmwTypeToWrapperType existing;
        if (this.wrapperTypeMap == null) {
            this.wrapperTypeMap = new HashMap();
            Iterator<DmwTypeToWrapperType> it = this.getDmwWrapperType();
            if (it != null) {
                while (it.hasNext()) {
                    DmwTypeToWrapperType curr = it.next();
                    DmwTypeToWrapperType existing2 = this.wrapperTypeMap.get(curr.getDmwType());
                    if (existing2 != null) {
                        throw new IllegalStateException("Multiple dmwWrapperType values with the same context on class " + this.getName());
                    }
                    this.wrapperTypeMap.put(curr.getDmwType(), curr);
                }
            }
            if (this.getUseWrapperType() == WrapperTypeEnum.EXTENDED) {
                try {
                    DmwTypeToWrapperType ttw = new DmwTypeToWrapperType("dmw", WrapperTypeEnum.EXTENDED);
                    this.wrapperTypeMap.put(ttw.getDmwType(), ttw);
                }
                catch (DmcValueException e) {
                    e.printStackTrace();
                }
            }
        }
        if ((existing = this.wrapperTypeMap.get(context)) == null) {
            return WrapperTypeEnum.BASE;
        }
        return existing.getWrapperType();
    }

    public boolean generateWrapper(String context) {
        DmcAttribute<?> exclude;
        boolean rc = true;
        if (this.getExcludeFromContextSize() > 0 && (exclude = this.getDMO().get(MetaDMSAG.__excludeFromContext)).contains(context)) {
            rc = false;
        }
        if (rc && this.getDerivedFrom() != null) {
            rc = this.getDerivedFrom().generateWrapper(context);
        }
        return rc;
    }

    public String getShortestName() {
        if (this.shortest == null) {
            this.shortest = this.getName().getNameString();
            if (this.getAbbrev() != null && this.getAbbrev().length() < this.getName().getNameString().length()) {
                this.shortest = this.getAbbrev();
            }
        }
        return this.shortest;
    }

    public void addImportsForAdditionalAttributes(SchemaManager sm, ImportManager imports, DmcUncheckedObject uco) throws ResultException {
        ResultException ex = null;
        Iterator<String> attrNames = uco.getAttributeNames();
        if (attrNames != null) {
            while (attrNames.hasNext()) {
                String name = attrNames.next();
                DefinitionName attr = null;
                try {
                    attr = new DefinitionName(name);
                }
                catch (DmcValueException e) {
                    e.printStackTrace();
                }
                if (this.isAllowedAttribute(attr)) continue;
                if (this.getClassType() == ClassTypeEnum.EXTENSIBLE) {
                    AttributeDefinition ad = sm.isAttribute(name);
                    if (ad == null) {
                        if (ex == null) {
                            ex = new ResultException();
                        }
                        ex.addError("The " + attr + " attribute is not defined, but used in " + uco.getConstructionClass());
                        this.setExceptionLocation(ex, uco);
                        continue;
                    }
                    imports.addImport(ad.getTypeImport(), "Support for addition of " + name + " values to the extensible " + uco.getConstructionClass() + " class");
                    continue;
                }
                if (ex == null) {
                    ex = new ResultException();
                }
                ex.addError("The " + attr + " attribute is not valid for class " + uco.getConstructionClass());
                this.setExceptionLocation(ex, uco);
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    void setExceptionLocation(ResultException ex, DmcUncheckedObject uco) {
        try {
            int ln = Integer.parseInt(uco.getSV(MetaDMSAG.__lineNumber.name));
            String file = uco.getSV(MetaDMSAG.__file.name);
            ex.setLocationInfo(file, ln);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    public boolean hasRules() {
        if (this.classRules == null) {
            this.getClassRules();
        }
        return this.classRules.size() > 0;
    }

    public Iterator<RuleDataDMO> getClassRules() {
        if (this.classRules == null) {
            this.classRules = new ArrayList();
            ArrayList<DmcObject> referring = this.getDMO().getReferringObjectsViaAttribute(MetaDMSAG.__applyToClass);
            DebugInfo.debug("\n" + this.getDMO().getBackRefs());
            if (this.getName().getNameString().equals("ValueLengthRuleData")) {
                DebugInfo.debug("HERE");
            }
            if (referring != null) {
                for (DmcObject obj : referring) {
                    RuleDataDMO rd;
                    if (!(obj instanceof RuleDataDMO) || (rd = (RuleDataDMO)obj).get(MetaDMSAG.__applyToAttribute) != null) continue;
                    this.classRules.add(rd);
                }
            }
        }
        return this.classRules.iterator();
    }

    public int derivationDepth() {
        IntegerVar depth = new IntegerVar(0);
        this.determineDepth(depth);
        return depth.intValue();
    }

    void determineDepth(IntegerVar depth) {
        if (this.getDerivedFrom() != null) {
            depth.set(depth.intValue() + 1);
            this.getDerivedFrom().determineDepth(depth);
        }
    }

    public void getDerivedClassesDepthFirst(ArrayList<ClassDefinition> classes) {
        classes.add(this);
        if (this.getDerivedClassesSize() > 0) {
            ClassDefinitionIterableDMW cdit = this.getDerivedClasses();
            while (cdit.hasNext()) {
                ClassDefinition cd = (ClassDefinition)cdit.next();
                cd.getDerivedClassesDepthFirst(classes);
            }
        }
    }
}

