/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms;

import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.rules.RuleIF;
import org.dmd.dms.MetaSchemaAG;
import org.dmd.dms.RuleCategory;
import org.dmd.dms.generated.dmo.RuleDefinitionDMO;
import org.dmd.dms.generated.dmw.RuleDefinitionDMW;
import org.dmd.dms.generated.dmw.SchemaDefinitionDMW;
import org.dmd.dms.generated.enums.OperationalContextEnum;
import org.dmd.dms.generated.enums.RuleTypeEnum;
import org.dmd.util.exceptions.DebugInfo;
import org.dmd.util.exceptions.ResultException;

public class RuleDefinition
extends RuleDefinitionDMW {
    public RuleDefinition() {
        super(new RuleDefinitionDMO(), MetaSchemaAG._RuleDefinition);
    }

    public RuleDefinition(RuleDefinitionDMO obj) {
        super(obj);
    }

    protected RuleDefinition(String mn) throws DmcValueException {
        super(mn);
    }

    public boolean isDMOCompliant() {
        boolean rc = true;
        for (RuleCategory cat : this.getRuleCategory()) {
            if (cat.getOpContext() != OperationalContextEnum.FULLJAVA) continue;
            rc = false;
            break;
        }
        return rc;
    }

    public RuleTypeEnum getRuleType() {
        RuleTypeEnum rc = RuleTypeEnum.CLASS;
        for (RuleCategory cat : this.getRuleCategory()) {
            if (cat.getRuleType() != RuleTypeEnum.ATTRIBUTE) continue;
            rc = RuleTypeEnum.ATTRIBUTE;
            break;
        }
        return rc;
    }

    public String getRuleDefinitionImport() {
        StringBuffer sb = new StringBuffer();
        if (this.isDMOCompliant()) {
            sb.append(((SchemaDefinitionDMW)this.getDefinedIn()).getSchemaPackage() + ".extended.rulesdmo." + this.getName());
        } else {
            sb.append(((SchemaDefinitionDMW)this.getDefinedIn()).getSchemaPackage() + ".extended.rulesfulljava." + this.getName());
        }
        return sb.toString();
    }

    public RuleIF newRuleInstance() throws ResultException {
        RuleIF rc = null;
        Class<?> ruleClass = null;
        try {
            ruleClass = Class.forName(this.getRuleDefinitionImport());
        }
        catch (ClassNotFoundException e) {
            ResultException ex = new ResultException();
            ex.result.addResult(4, "Couldn't load Java class: " + this.getRuleDefinitionImport());
            ex.result.lastResult().moreMessages(DebugInfo.getCurrentStack());
            throw ex;
        }
        try {
            rc = (RuleIF)ruleClass.newInstance();
        }
        catch (Exception e) {
            ResultException ex = new ResultException();
            ex.result.addResult(4, "Couldn't instantiate Java class: " + this.getRuleDefinitionImport());
            ex.result.lastResult().moreMessages("This may be because the class doesn't have a constructor that takes no arguments.");
            ex.result.lastResult().moreMessages(DebugInfo.getCurrentStack());
            throw ex;
        }
        return rc;
    }
}

