/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms;

import java.util.Iterator;
import java.util.TreeMap;
import org.dmd.dmc.DmcNameClashException;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.rules.DynamicInitIF;
import org.dmd.dmc.rules.RuleIF;
import org.dmd.dmc.types.RuleName;
import org.dmd.dmc.types.StringToString;
import org.dmd.dmc.util.DmcUncheckedObject;
import org.dmd.dmg.util.GeneratorUtils;
import org.dmd.dms.ActionDefinition;
import org.dmd.dms.AttributeDefinition;
import org.dmd.dms.ClassDefinition;
import org.dmd.dms.ComplexTypeDefinition;
import org.dmd.dms.DSDefinitionModule;
import org.dmd.dms.DmsDefinition;
import org.dmd.dms.EnumDefinition;
import org.dmd.dms.ExtendedReferenceTypeDefinition;
import org.dmd.dms.RuleDefinition;
import org.dmd.dms.SchemaManager;
import org.dmd.dms.SliceDefinition;
import org.dmd.dms.TypeDefinition;
import org.dmd.dms.generated.dmo.RuleDataDMO;
import org.dmd.dms.generated.dmw.AttributeDefinitionIterableDMW;
import org.dmd.dms.generated.dmw.ClassDefinitionIterableDMW;
import org.dmd.dms.generated.dmw.SchemaDefinitionDMW;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dms.util.DmoObjectFactory;
import org.dmd.dms.util.DynamicCompactSchema;
import org.dmd.util.exceptions.ResultException;

public class SchemaDefinition
extends SchemaDefinitionDMW {
    protected String staticRefName;
    protected boolean defsCompleteV;
    protected String version;
    protected TreeMap<String, String> dependsOnSchemaClasses;
    protected boolean generatedSchema;
    TreeMap<String, StringToString> dmwToPackageMapping;
    TreeMap<RuleName, DmcUncheckedObject> parsedRules;
    TreeMap<RuleName, RuleDataDMO> parsedRulesDMOs;
    TreeMap<RuleName, RuleIF> ruleInstances;
    TreeMap<RuleName, RuleIF> resolvedRules;

    public SchemaDefinition() {
        this.dependsOnSchemaClasses = new TreeMap();
        this.generatedSchema = false;
    }

    protected SchemaDefinition(String mn) throws DmcValueException {
        this.getDMO().setName(mn);
        this.dependsOnSchemaClasses = new TreeMap();
        this.generatedSchema = false;
    }

    public String getDependsOnClass(String schemaName) {
        return this.dependsOnSchemaClasses.get(schemaName);
    }

    public SchemaDefinition getInstance() throws DmcValueException {
        return null;
    }

    public String getDmwPackage(String context) {
        StringToString existing;
        if (this.dmwToPackageMapping == null) {
            this.dmwToPackageMapping = new TreeMap();
            Iterator<StringToString> mapping = this.getDmwTypeToPackage();
            if (mapping != null) {
                while (mapping.hasNext()) {
                    StringToString curr = mapping.next();
                    StringToString existing2 = this.dmwToPackageMapping.get(curr.getKey());
                    if (existing2 != null) {
                        throw new IllegalStateException("Multiple dmwTypeToPackage values with same key in schema: " + this.getName());
                    }
                    this.dmwToPackageMapping.put(curr.getKeyAsString(), curr);
                }
            }
            if (this.getDmwPackage() != null) {
                StringToString entry = new StringToString("dmw", this.getDmwPackage());
                this.dmwToPackageMapping.put(entry.getKeyAsString(), entry);
            }
        }
        if ((existing = this.dmwToPackageMapping.get(context)) == null) {
            return null;
        }
        return existing.getValue();
    }

    public String getDMSASGName() {
        String rc = GeneratorUtils.dotNameToCamelCase(this.getName().getNameString()) + "DMSAG";
        return rc;
    }

    public String getDMSASGImport() {
        String name = GeneratorUtils.dotNameToCamelCase(this.getName().getNameString()) + "DMSAG";
        return this.getSchemaPackage() + ".generated.dmo." + name;
    }

    public boolean isGeneratedSchema() {
        return this.generatedSchema;
    }

    public String getStaticRefName() {
        return this.staticRefName;
    }

    public boolean defsComplete() {
        return this.defsCompleteV;
    }

    public void setVersion(String v) {
        this.version = v;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public void dumpInfo() {
        AttributeDefinitionIterableDMW al;
        int ccount = 0;
        int acount = 0;
        int sv = 0;
        int mv = 0;
        ClassDefinitionIterableDMW cl = this.getClassDefList();
        if (cl != null) {
            while (cl.hasNext()) {
                cl.next();
                ++ccount;
            }
        }
        if ((al = this.getAttributeDefList()) != null) {
            while (al.hasNext()) {
                AttributeDefinition ad = (AttributeDefinition)al.next();
                ++acount;
                if (ad.getValueType() == ValueTypeEnum.SINGLE) {
                    ++sv;
                    continue;
                }
                ++mv;
            }
        }
        System.out.println("Classes:    " + ccount);
        System.out.println("Attributes: " + acount);
        System.out.println("        SV: " + sv);
        System.out.println("        MV: " + mv);
    }

    public int classChanges(SchemaDefinition pred, StringBuffer sb) {
        int rc = 0;
        return rc;
    }

    public int attributeChanges(SchemaDefinition pred, StringBuffer sb, SchemaManager currManager) {
        int rc = 0;
        return rc;
    }

    public int typeChanges(SchemaDefinition pred, StringBuffer sb) {
        int rc = 0;
        return rc;
    }

    public void addDefinition(DmsDefinition def) throws ResultException, DmcValueException {
        if (def instanceof AttributeDefinition) {
            this.addAttributeDefList((AttributeDefinition)def);
        } else if (def instanceof ClassDefinition) {
            this.addClassDefList((ClassDefinition)def);
        } else if (def instanceof ActionDefinition) {
            this.addActionDefList((ActionDefinition)def);
        } else if (def instanceof TypeDefinition) {
            this.addTypeDefList((TypeDefinition)def);
        } else if (def instanceof EnumDefinition) {
            this.addEnumDefList((EnumDefinition)def);
        } else if (def instanceof SliceDefinition) {
            this.addSliceDefList((SliceDefinition)def);
        } else if (def instanceof ExtendedReferenceTypeDefinition) {
            this.addExtendedReferenceTypeDefList((ExtendedReferenceTypeDefinition)def);
        } else if (def instanceof ComplexTypeDefinition) {
            this.addComplexTypeDefList((ComplexTypeDefinition)def);
        } else if (def instanceof RuleDefinition) {
            this.addRuleDefinitionList((RuleDefinition)def);
        } else if (def instanceof DSDefinitionModule) {
            this.addDsdModuleList((DSDefinitionModule)def);
        } else {
            ResultException ex = new ResultException();
            ex.addError("The specified object is not a DMD object: \n" + def.toOIF());
            throw ex;
        }
    }

    public Iterator<DmcUncheckedObject> getParsedRules() {
        if (this.parsedRules == null) {
            return null;
        }
        return this.parsedRules.values().iterator();
    }

    public boolean hasParsedRules() {
        return this.parsedRules != null;
    }

    public Iterator<RuleDataDMO> getParsedRulesDMOs(SchemaManager sm) throws DmcNameClashException {
        if (this.parsedRulesDMOs == null) {
            this.parsedRulesDMOs = new TreeMap();
            this.ruleInstances = new TreeMap();
            if (this.parsedRules != null) {
                DmoObjectFactory dmofactory = new DmoObjectFactory(sm);
                for (DmcUncheckedObject uco : this.parsedRules.values()) {
                    try {
                        ClassDefinition ruleDataCD = sm.cdef(uco.getConstructionClass());
                        RuleDataDMO dmo = (RuleDataDMO)dmofactory.createObject(uco);
                        RuleDefinition ruleDEF = ruleDataCD.getRuleDefinition();
                        DynamicInitIF rule = (DynamicInitIF)((Object)ruleDEF.newRuleInstance());
                        rule.setRuleData(dmo);
                        this.parsedRulesDMOs.put(dmo.getObjectName(), dmo);
                        this.ruleInstances.put(dmo.getObjectName(), (RuleIF)((Object)rule));
                    }
                    catch (ResultException e) {
                        e.printStackTrace();
                    }
                    catch (DmcValueException e) {
                        e.printStackTrace();
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return this.parsedRulesDMOs.values().iterator();
    }

    public void setResolvedRules(TreeMap<RuleName, RuleIF> rr) {
        this.resolvedRules = rr;
    }

    public TreeMap<RuleName, RuleIF> getResolvedRules() {
        return this.resolvedRules;
    }

    public TreeMap<RuleName, RuleIF> getRuleInstances(SchemaManager sm) throws DmcNameClashException {
        if (this.ruleInstances == null) {
            this.getParsedRulesDMOs(sm);
        }
        return this.ruleInstances;
    }

    public void addParsedRule(DmcUncheckedObject uco) throws ResultException, DmcValueException {
        RuleName rn;
        DmcUncheckedObject existing;
        String ruleName = uco.getSV("ruleName");
        if (ruleName == null) {
            ResultException ex = new ResultException();
            ex.addError("The specified rule instance doesn't have a ruleName: \n" + uco.toOIF());
            throw ex;
        }
        if (this.parsedRules == null) {
            this.parsedRules = new TreeMap();
        }
        if ((existing = this.parsedRules.get(rn = new RuleName(ruleName))) != null) {
            ResultException ex = new ResultException();
            ex.addError("Clashing ruleNames: \n\n" + existing.toOIF() + "\n" + uco.toOIF());
            throw ex;
        }
        this.parsedRules.put(rn, uco);
    }

    public DynamicCompactSchema getCompactSchema() {
        DynamicCompactSchema rc = new DynamicCompactSchema(this.getName().getNameString());
        if (this.getAttributeDefListSize() > 0) {
            for (AttributeDefinition def : this.getAttributeDefList()) {
                rc.addAttrInfo(def.getAttributeInfo());
            }
        }
        if (this.getClassDefListSize() > 0) {
            for (ClassDefinition cd : this.getClassDefList()) {
                rc.addClassInfo(cd.getDynamicClassInfo());
            }
        }
        return rc;
    }
}

