/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcClassInfo;
import org.dmd.dmc.DmcNameClashException;
import org.dmd.dmc.DmcNameClashObjectSet;
import org.dmd.dmc.DmcNameClashResolverIF;
import org.dmd.dmc.DmcNameResolverWithClashSupportIF;
import org.dmd.dmc.DmcNamedObjectIF;
import org.dmd.dmc.DmcObject;
import org.dmd.dmc.DmcObjectName;
import org.dmd.dmc.DmcObjectNameIF;
import org.dmd.dmc.DmcOmni;
import org.dmd.dmc.DmcUniqueNameResolverIF;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.DmcValueExceptionSet;
import org.dmd.dmc.definitions.DmcDefinitionSet;
import org.dmd.dmc.rules.RuleIF;
import org.dmd.dmc.types.DefinitionName;
import org.dmd.dmc.types.DotName;
import org.dmd.dmc.types.RuleName;
import org.dmd.dmc.util.DmcUncheckedObject;
import org.dmd.dmc.util.NamedStringArray;
import org.dmd.dms.ActionDefinition;
import org.dmd.dms.AttributeDefinition;
import org.dmd.dms.ClassDefinition;
import org.dmd.dms.ComplexTypeDefinition;
import org.dmd.dms.DSDefinition;
import org.dmd.dms.DSDefinitionModule;
import org.dmd.dms.DmsDefinition;
import org.dmd.dms.EnumDefinition;
import org.dmd.dms.ExtendedReferenceTypeDefinition;
import org.dmd.dms.MetaSchema;
import org.dmd.dms.MetaSchemaAG;
import org.dmd.dms.RuleCategory;
import org.dmd.dms.RuleData;
import org.dmd.dms.RuleDefinition;
import org.dmd.dms.SchemaDefinition;
import org.dmd.dms.SchemaDefinitionListenerIF;
import org.dmd.dms.SchemaExtensionIF;
import org.dmd.dms.SliceDefinition;
import org.dmd.dms.TypeDefinition;
import org.dmd.dms.generated.dmo.DmsDefinitionDMO;
import org.dmd.dms.generated.dmo.MetaDMSAG;
import org.dmd.dms.generated.dmw.ActionDefinitionIterableDMW;
import org.dmd.dms.generated.dmw.AttributeDefinitionIterableDMW;
import org.dmd.dms.generated.dmw.ClassDefinitionIterableDMW;
import org.dmd.dms.generated.dmw.ComplexTypeDefinitionIterableDMW;
import org.dmd.dms.generated.dmw.DSDefinitionModuleIterableDMW;
import org.dmd.dms.generated.dmw.EnumDefinitionIterableDMW;
import org.dmd.dms.generated.dmw.ExtendedReferenceTypeDefinitionIterableDMW;
import org.dmd.dms.generated.dmw.RuleCategoryIterableDMW;
import org.dmd.dms.generated.dmw.RuleDefinitionIterableDMW;
import org.dmd.dms.generated.dmw.SchemaDefinitionDMW;
import org.dmd.dms.generated.dmw.SliceDefinitionIterableDMW;
import org.dmd.dms.generated.dmw.TypeDefinitionIterableDMW;
import org.dmd.dms.generated.enums.ClassTypeEnum;
import org.dmd.dms.generated.enums.RuleTypeEnum;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dms.generated.enums.WrapperTypeEnum;
import org.dmd.dmw.DmwWrapper;
import org.dmd.util.exceptions.DebugInfo;
import org.dmd.util.exceptions.ResultException;
import org.dmd.util.formatting.PrintfFormat;

public class SchemaManager
implements DmcNameResolverWithClashSupportIF,
DmcNameClashResolverIF,
DmcUniqueNameResolverIF {
    SchemaDefinition meta;
    public HashMap<DotName, DmsDefinition> globallyUniqueMAP;
    public HashMap<DotName, ArrayList<DmsDefinition>> clashMAP;
    boolean debugClashmap = false;
    DmcNameClashResolverIF currentResolver;
    DmcDefinitionSet<EnumDefinition> enumDefinitions;
    public int longestEnumName;
    public HashMap<DefinitionName, TypeDefinition> typeDefs;
    public int longestTypeName;
    public HashMap<DefinitionName, TypeDefinition> internalTypeDefs;
    public DmcDefinitionSet<AttributeDefinition> attributeDefinitions;
    public TreeMap<Integer, ClassDefinition> classesByID;
    public TreeMap<String, ClassDefinition> classesByJavaClass;
    public TreeMap<Integer, AttributeDefinition> attrByID;
    public HashMap<DefinitionName, ActionDefinition> actionDefs;
    public int longestActionName;
    DmcDefinitionSet<ClassDefinition> classDefinitions;
    public int longestClassName;
    boolean debugClassAdditions;
    public HashMap<DefinitionName, ComplexTypeDefinition> complexTypeDefs;
    public int longestComplexTypeName;
    public HashMap<DefinitionName, ExtendedReferenceTypeDefinition> extendedReferenceTypeDefs;
    public int longestExtendedReferenceTypeName;
    public HashMap<DefinitionName, SliceDefinition> sliceDefs;
    public int longestSliceName;
    public HashMap<DefinitionName, RuleCategory> ruleCategoryDefs;
    public int longestRuleCategoryName;
    public TreeMap<Integer, RuleCategory> ruleCategoriesByID;
    public TreeMap<RuleName, RuleData> ruleData;
    public HashMap<DefinitionName, RuleDefinition> ruleDefs;
    public HashMap<DotName, RuleDefinition> ruleDefsByDot;
    public int longestRuleName;
    TreeMap<DefinitionName, ClassDefinition> hierarchicObjects;
    public HashMap<DefinitionName, ClassDefinition> classAbbrevs;
    public HashMap<DefinitionName, AttributeDefinition> attrAbbrevs;
    TreeMap<DefinitionName, SchemaDefinition> schemaDefs;
    public int longestSchemaName;
    TreeMap<DefinitionName, DSDefinitionModule> definitionModuleDefs;
    SchemaDefinition currentSchema;
    TreeMap<String, SchemaExtensionIF> extensions;
    boolean performIDChecks;
    ArrayList<SchemaDefinitionListenerIF> listeners;

    public SchemaManager() throws ResultException, DmcValueException, DmcNameClashException {
        this.init();
        this.debugClashmap = false;
        this.debugClassAdditions = false;
    }

    public SchemaManager(SchemaDefinition sd) throws ResultException, DmcValueException, DmcNameClashException {
        this.init();
        this.manageSchema(sd);
    }

    void init() throws ResultException, DmcValueException, DmcNameClashException {
        this.globallyUniqueMAP = new HashMap();
        this.clashMAP = new HashMap();
        this.currentResolver = this;
        this.enumDefinitions = new DmcDefinitionSet();
        this.typeDefs = new HashMap();
        this.internalTypeDefs = new HashMap();
        this.attributeDefinitions = new DmcDefinitionSet();
        this.classDefinitions = new DmcDefinitionSet();
        this.attrByID = new TreeMap();
        this.classesByID = new TreeMap();
        this.classesByJavaClass = new TreeMap();
        this.actionDefs = new HashMap();
        this.complexTypeDefs = new HashMap();
        this.extendedReferenceTypeDefs = new HashMap();
        this.sliceDefs = new HashMap();
        this.ruleCategoryDefs = new HashMap();
        this.ruleCategoriesByID = new TreeMap();
        this.ruleDefs = new HashMap();
        this.ruleDefsByDot = new HashMap();
        this.ruleData = new TreeMap();
        this.schemaDefs = new TreeMap();
        this.definitionModuleDefs = new TreeMap();
        this.classAbbrevs = new HashMap();
        this.attrAbbrevs = new HashMap();
        this.hierarchicObjects = null;
        this.extensions = new TreeMap();
        this.performIDChecks = true;
        this.meta = MetaSchema._metaSchema == null ? new MetaSchema() : MetaSchema._metaSchema;
        this.manageSchemaInternal(this.meta);
        this.resolveReferences(this.meta, this);
        AttributeDefinitionIterableDMW adl = this.meta.getAttributeDefList();
        this.resolveNameTypes(adl);
    }

    public void addDefinitionListener(SchemaDefinitionListenerIF listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(listener);
    }

    public TreeMap<DefinitionName, ClassDefinition> getHierarchicObjects() {
        if (this.hierarchicObjects == null) {
            this.hierarchicObjects = new TreeMap();
            for (ClassDefinition cd : this.classDefinitions.values()) {
                if (cd.getIsNamedBy() == null || !cd.getIsNamedBy().getType().getIsHierarchicName().booleanValue()) continue;
                if (cd.getAllowedParentsSize() == 0) {
                    this.hierarchicObjects.put(cd.getName(), cd);
                    continue;
                }
                for (ClassDefinition parent : cd.getAllowedParents()) {
                    parent.addSubcomp(cd);
                }
            }
        }
        return this.hierarchicObjects;
    }

    public DmwWrapper wrapIt(DmcObject dmo) throws DmcNameClashException, DmcValueException {
        ClassDefinition cd = this.isClass(dmo.getConstructionClassName());
        if (cd == null) {
            throw new IllegalStateException("Cannot create DmwWrapper for unknown class: " + dmo.getConstructionClassName());
        }
        DmwWrapper rc = null;
        try {
            rc = cd.newInstance();
        }
        catch (ResultException e) {
            throw new IllegalStateException("Cannot create DmwWrapper for class: " + dmo.getConstructionClassName(), e);
        }
        rc.setDmcObject(dmo);
        return rc;
    }

    public DmcObjectName getNameValueInstance(Integer id) throws Exception {
        AttributeDefinition ad = this.attrByID.get(id);
        if (ad == null) {
            return null;
        }
        DmcObjectName rc = null;
        rc = ad.getType().getNameValue();
        return rc;
    }

    public DmcAttribute<?> getAttributeInstance(Integer id) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        AttributeDefinition ad = this.attrByID.get(id);
        DmcAttributeInfo ai = DmcOmni.instance().getInfo(id);
        if (ad == null) {
            throw new IllegalStateException("Tried to deserialize attribute with unknown ID: " + id);
        }
        if (ai == null) {
            throw new IllegalStateException("Tried to deserialize attribute with unknown ID: " + id);
        }
        DmcAttribute<?> rc = ad.getType().getAttributeHolder(ai);
        rc.setAttributeInfo(ai);
        return rc;
    }

    public TypeDefinition findInternalType(DefinitionName name) {
        return this.internalTypeDefs.get(name);
    }

    public DmcAttribute<DmcObjectNameIF> getNameAttributeInstance(DmcObjectName oni) {
        DmcAttribute<DmcObjectNameIF> rc;
        TypeDefinition td = this.isType(oni.getNameClass());
        if (td == null) {
            throw new IllegalStateException("Unable to find type definition for type: " + oni.getNameClass());
        }
        AttributeDefinition ad = td.getNameAttributeDef();
        if (ad == null) {
            throw new IllegalStateException("No naming attribute has been defined of type: " + oni.getNameClass());
        }
        DmcAttributeInfo ai = DmcOmni.instance().getInfo(ad.getDmdID());
        if (ai == null) {
            throw new IllegalStateException("No attribute info for attribute: " + ad.getName() + " id: " + ad.getDmdID());
        }
        try {
            rc = ad.getType().getAttributeHolder(ai);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to instantiate naming attribute of type: " + oni.getNameClass(), e);
        }
        return rc;
    }

    public void schemaBeingLoaded(SchemaDefinition sd) throws ResultException {
        for (SchemaExtensionIF currext : this.extensions.values()) {
            currext.schemaBeingLoaded(sd);
        }
    }

    public void definitionPreAdd(DmcUncheckedObject def) throws DmcValueException {
        for (SchemaExtensionIF currext : this.extensions.values()) {
            currext.definitionPreAdd(def);
        }
    }

    public void schemaPreAdd(DmcUncheckedObject sd) throws ResultException, DmcValueException, DmcNameClashException {
        NamedStringArray attr = sd.get(MetaSchema._schemaExtension.getName().getNameString());
        if (attr != null) {
            for (String ext : attr) {
                Class<?> extclass;
                try {
                    extclass = Class.forName(ext);
                }
                catch (Exception e) {
                    ResultException ex = new ResultException();
                    ex.result.addResult(4, "Couldn't load schemaExtension class: " + ext);
                    ex.result.lastResult().moreMessages(e.getMessage());
                    ex.result.lastResult().moreMessages(DebugInfo.extractTheStack(e));
                    throw ex;
                }
                int lastDot = ext.lastIndexOf(".");
                String className = ext.substring(lastDot + 1);
                if (this.extensions.get(className) != null) continue;
                SchemaExtensionIF extInstance = null;
                try {
                    extInstance = (SchemaExtensionIF)extclass.newInstance();
                }
                catch (Exception e) {
                    ResultException ex = new ResultException();
                    ex.result.addResult(4, "Couldn't instantiate Java class: " + ext);
                    ex.result.lastResult().moreMessages("This may be because the class doesn't have a constructor that takes no arguments.");
                    ex.result.lastResult().moreMessages("Or it may be that the class doesn't implement the SchemaExtensionIF interface.");
                    throw ex;
                }
                SchemaDefinition extschema = extInstance.getExtensionSchema();
                this.loadGeneratedSchema(extschema);
                this.extensions.put(className, extInstance);
                extInstance.setManager(this);
                extInstance.definitionPreAdd(sd);
            }
        }
    }

    private void loadGeneratedSchema(SchemaDefinition sd) throws ResultException, DmcValueException, DmcNameClashException {
        for (String schemaName : sd.dependsOnSchemaClasses.keySet()) {
            String schemaClassName = sd.dependsOnSchemaClasses.get(schemaName);
            SchemaDefinition depSchema = this.isSchema(schemaName);
            if (depSchema != null) continue;
            Class<?> schemaClass = null;
            try {
                schemaClass = Class.forName(schemaClassName);
            }
            catch (Exception e) {
                ResultException ex = new ResultException();
                ex.result.addResult(4, "Couldn't load generated schema class: " + schemaClassName);
                ex.result.lastResult().moreMessages(e.getMessage());
                ex.result.lastResult().moreMessages(DebugInfo.extractTheStack(e));
                throw ex;
            }
            try {
                depSchema = (SchemaDefinition)schemaClass.newInstance();
            }
            catch (Exception e) {
                ResultException ex = new ResultException();
                ex.result.addResult(4, "Couldn't instantiate Java class: " + schemaClassName);
                ex.result.lastResult().moreMessages("This may be because the class doesn't have a constructor that takes no arguments.");
                ex.result.lastResult().moreMessages("Or it may be that the class isn't derived from SchemaDefinition.");
                throw ex;
            }
            this.loadGeneratedSchema(depSchema);
        }
        SchemaDefinition theInstance = sd.getInstance();
        this.manageSchemaInternal(theInstance);
        this.resolveReferences(theInstance, this);
        AttributeDefinitionIterableDMW adl = sd.getAttributeDefList();
        this.resolveNameTypes(adl);
    }

    public void manageSchema(SchemaDefinition sd) throws ResultException, DmcValueException, DmcNameClashException {
        this.performIDChecks = !sd.generatedSchema;
        if (sd.isGeneratedSchema()) {
            this.loadGeneratedSchema(sd);
        } else {
            this.manageSchemaInternal(sd);
        }
    }

    public void manageSchemaInternal(SchemaDefinition sd, boolean checkIDs) throws ResultException, DmcValueException, DmcNameClashException {
        this.performIDChecks = checkIDs;
        this.manageSchemaInternal(sd);
    }

    public void manageSchemaInternal(SchemaDefinition sd) throws ResultException, DmcValueException, DmcNameClashException {
        ClassDefinition cd = null;
        EnumDefinition evd = null;
        TypeDefinition td = null;
        AttributeDefinition ad = null;
        ActionDefinition actd = null;
        ComplexTypeDefinition ctd = null;
        ExtendedReferenceTypeDefinition exrtd = null;
        SliceDefinition slice = null;
        RuleCategory category = null;
        RuleDefinition rule = null;
        DSDefinitionModule dsdModule = null;
        ActionDefinitionIterableDMW itACD = null;
        AttributeDefinitionIterableDMW itATD = null;
        ClassDefinitionIterableDMW itCD = null;
        EnumDefinitionIterableDMW itEVD = null;
        TypeDefinitionIterableDMW itTD = null;
        ComplexTypeDefinitionIterableDMW cTD = null;
        ExtendedReferenceTypeDefinitionIterableDMW exrTD = null;
        SliceDefinitionIterableDMW sliceIT = null;
        RuleCategoryIterableDMW categoryIT = null;
        RuleDefinitionIterableDMW ruleIT = null;
        DSDefinitionModuleIterableDMW dsdModuleIT = null;
        this.currentSchema = sd;
        itTD = sd.getTypeDefList();
        if (itTD != null) {
            while (itTD.hasNext()) {
                td = (TypeDefinition)itTD.next();
                this.addType(td);
            }
        }
        if ((cTD = sd.getComplexTypeDefList()) != null) {
            while (cTD.hasNext()) {
                ctd = (ComplexTypeDefinition)cTD.next();
                this.addComplexType(ctd);
            }
        }
        if ((exrTD = sd.getExtendedReferenceTypeDefList()) != null) {
            while (exrTD.hasNext()) {
                exrtd = (ExtendedReferenceTypeDefinition)exrTD.next();
                this.addExtendedReferenceType(exrtd);
            }
        }
        if ((itEVD = sd.getEnumDefList()) != null) {
            while (itEVD.hasNext()) {
                evd = (EnumDefinition)itEVD.next();
                this.addEnum(evd);
            }
        }
        if ((itATD = sd.getAttributeDefList()) != null) {
            while (itATD.hasNext()) {
                ad = (AttributeDefinition)itATD.next();
                this.addAttribute(ad);
            }
        }
        if ((itACD = sd.getActionDefList()) != null) {
            while (itACD.hasNext()) {
                actd = (ActionDefinition)itACD.next();
                this.addAction(actd);
            }
        }
        if ((ruleIT = sd.getRuleDefinitionList()) != null) {
            while (ruleIT.hasNext()) {
                rule = (RuleDefinition)ruleIT.next();
                this.addRuleDefinition(rule);
            }
        }
        if ((dsdModuleIT = sd.getDsdModuleList()) != null) {
            while (dsdModuleIT.hasNext()) {
                dsdModule = (DSDefinitionModule)dsdModuleIT.next();
                this.addDefinitionModule(dsdModule, true);
            }
        }
        if ((itCD = sd.getClassDefList()) != null) {
            while (itCD.hasNext()) {
                cd = (ClassDefinition)itCD.next();
                if (cd.getDMO().getRuleDefinition() != null) continue;
                this.addClass(cd);
            }
        }
        if ((sliceIT = sd.getSliceDefList()) != null) {
            while (sliceIT.hasNext()) {
                slice = (SliceDefinition)sliceIT.next();
                this.addSlice(slice);
            }
        }
        if ((categoryIT = sd.getRuleCategoryList()) != null) {
            while (categoryIT.hasNext()) {
                category = (RuleCategory)categoryIT.next();
                this.addRuleCategory(category);
            }
        }
        this.addSchema(sd);
    }

    public Iterator<SchemaDefinition> getSchemas() {
        return this.schemaDefs.values().iterator();
    }

    public TypeDefinition isType(String name) {
        return this.typeDefs.get(this.getDefName(name));
    }

    public AttributeDefinition isAttribute(String name) {
        AttributeDefinition rc = null;
        try {
            DotName dn = new DotName(name + "." + MetaDMSAG.__AttributeDefinition.name);
            ArrayList<DmsDefinition> defs = this.clashMAP.get(dn);
            if (defs == null) {
                return rc;
            }
            if (defs.size() != 1) {
                StringBuffer sb = new StringBuffer();
                for (DmsDefinition def : defs) {
                    sb.append(def.getDotName().getNameString() + " ");
                }
                throw new IllegalStateException("Looking for attribute: " + name + " resulted in multiple definitions: " + sb.toString() + "\n\n" + DebugInfo.getCurrentStack());
            }
            rc = (AttributeDefinition)defs.get(0);
        }
        catch (DmcValueException e) {
            e.printStackTrace();
        }
        return rc;
    }

    public EnumDefinition isEnum(String name) {
        EnumDefinition rc = null;
        try {
            rc = this.enumDefinitions.getDefinition(name);
        }
        catch (DmcNameClashException e) {
            e.printStackTrace();
        }
        catch (DmcValueException e) {
            e.printStackTrace();
        }
        return rc;
    }

    public AttributeDefinition isAttribute(Integer id) {
        return this.attrByID.get(id);
    }

    public ClassDefinition isClass(Integer id) {
        return this.classesByID.get(id);
    }

    public ClassDefinition getClassByJavaClassName(String cn) {
        return this.classesByJavaClass.get(cn);
    }

    public ActionDefinition isAction(String name) {
        return this.actionDefs.get(this.getDefName(name));
    }

    public ClassDefinition isClass(String name) throws DmcNameClashException, DmcValueException {
        return this.classDefinitions.getDefinition(name);
    }

    public SchemaDefinition isSchema(String name) {
        return this.schemaDefs.get(this.getDefName(name));
    }

    void addSchema(SchemaDefinition sd) throws ResultException, DmcValueException {
        this.currentSchema = sd;
        if (!this.checkAndAdd((Object)sd.getObjectName(), (Object)sd, this.schemaDefs)) {
            ResultException ex = new ResultException();
            ex.addError(this.clashMsg(sd.getObjectName(), (DmsDefinition)sd, this.schemaDefs, "schema names"));
            this.currentSchema = null;
            throw ex;
        }
        if (!this.checkAndAddDOT(sd.getDotName(), sd, this.globallyUniqueMAP, null)) {
            ResultException ex = new ResultException();
            ex.addError(this.clashMsgDOT(sd.getObjectName(), sd, this.globallyUniqueMAP, "definition names"));
            this.currentSchema = null;
            throw ex;
        }
        if (sd.getObjectName().getNameString().length() > this.longestSchemaName) {
            this.longestSchemaName = sd.getObjectName().getNameString().length();
        }
        this.currentSchema = null;
        if (this.extensions.size() > 0) {
            for (SchemaExtensionIF ext : this.extensions.values()) {
                ext.addSchema(sd);
            }
        }
    }

    void addDefinitionModule(DSDefinitionModule ddm, boolean managingSchema) throws ResultException, DmcValueException {
        if (!this.checkAndAdd((Object)ddm.getObjectName(), (Object)ddm, this.definitionModuleDefs)) {
            ResultException ex = new ResultException();
            ex.addError(this.clashMsg(ddm.getObjectName(), (DmsDefinition)ddm, this.definitionModuleDefs, "DSDefinitionModule names"));
            this.currentSchema = null;
            throw ex;
        }
        if (!this.checkAndAddDOT(ddm.getDotName(), ddm, this.globallyUniqueMAP, null)) {
            ResultException ex = new ResultException();
            ex.addError(this.clashMsgDOT(ddm.getObjectName(), ddm, this.globallyUniqueMAP, "definition names"));
            throw ex;
        }
        if (managingSchema) {
            return;
        }
        if (ddm.getDmdID() != null && ddm.getDmdID() != 1) {
            ResultException ex = new ResultException("The dmdID of a DSDefinitionModule must be 1");
            ex.setLocationInfo(ddm.getFile(), ddm.getLineNumber());
            throw ex;
        }
        try {
            ddm.resolveReferences(this, this.currentResolver);
        }
        catch (DmcValueExceptionSet e) {
            ResultException ex = new ResultException();
            ex.addError("Unresolved references in DSDefinitionModule: " + ddm.getName());
            for (DmcValueException dve : e.getExceptions()) {
                ex.moreMessages(dve.getMessage());
            }
            throw ex;
        }
        DefinitionName moduleClassName = new DefinitionName(ddm.getModuleClassName());
        ClassDefinition cd = new ClassDefinition();
        cd.setName(moduleClassName);
        cd.setClassType((Object)ClassTypeEnum.STRUCTURAL);
        cd.setDmdID(ddm.getDmdID());
        cd.setIsNamedBy(MetaSchemaAG._name);
        cd.setInternallyGenerated(true);
        cd.setDsdModuleDefinition(ddm);
        if (ddm.getSupportDynamicSchemaLoading().booleanValue()) {
            cd.addMay(MetaSchema._loadSchemaClass);
        }
        cd.setDerivedFrom((ClassDefinition)ddm.getBaseDefinition());
        DotName className = new DotName(((DotName)ddm.getDotName().getParentName()).getNameString() + ".ClassDefinition");
        cd.setDotName(className);
        cd.addMust(MetaSchemaAG._name);
        cd.addMay(MetaSchemaAG._description);
        cd.addMay(MetaSchemaAG._defFiles);
        cd.setFile(ddm.getFile());
        cd.setLineNumber(ddm.getLineNumber());
        cd.setDefinedIn(ddm.getDefinedIn());
        cd.setUseWrapperType((Object)WrapperTypeEnum.EXTENDED);
        if (ddm.getDescription() != null) {
            Iterator<String> it = ddm.getDescription();
            while (it.hasNext()) {
                cd.addDescription(it.next());
            }
        }
        for (AttributeDefinition ad : ddm.getMay()) {
            cd.addMay(ad);
        }
        for (AttributeDefinition ad : ddm.getMust()) {
            cd.addMust(ad);
        }
        this.addDependenceAttributes(cd, ddm, new TreeSet<String>());
        this.addClass(cd);
        ddm.getDefinedIn().addClassDefList(cd);
    }

    void addDependenceAttributes(ClassDefinition cd, DSDefinitionModule module, TreeSet<String> modules) throws DmcValueException {
        cd.addMay(module.getModuleDependenceAttribute());
        modules.add(module.getName().getNameString());
        if (module.getRefersToDefsFromDSDSize() > 0) {
            DSDefinitionModuleIterableDMW it = module.getRefersToDefsFromDSD();
            while (it.hasNext()) {
                DSDefinitionModule mod = (DSDefinitionModule)it.next();
                if (modules.contains(mod.getName().getNameString())) continue;
                this.addDependenceAttributes(cd, mod, modules);
            }
        }
    }

    void addComplexType(ComplexTypeDefinition ctd) throws ResultException, DmcValueException {
        if (!this.checkAndAdd(ctd.getObjectName(), ctd, this.complexTypeDefs)) {
            ResultException ex = new ResultException();
            ex.addError(this.clashMsg(ctd.getObjectName(), (DmsDefinition)ctd, this.complexTypeDefs, "complex type names"));
            throw ex;
        }
        if (!this.checkAndAddDOT(ctd.getDotName(), ctd, this.globallyUniqueMAP, null)) {
            ResultException ex = new ResultException();
            ex.addError(this.clashMsgDOT(ctd.getObjectName(), ctd, this.globallyUniqueMAP, "definition names"));
            this.currentSchema = null;
            throw ex;
        }
        TypeDefinition td = new TypeDefinition(ctd);
        td.setInternallyGenerated(true);
        td.setName(ctd.getName());
        DotName typeName = new DotName((DotName)ctd.getDotName().getParentName(), "TypeDefinition");
        td.setDotName(typeName);
        td.addDescription("This is an internally generated type to represent complex type " + ctd.getName() + " values.");
        td.setIsEnumType(false);
        td.setIsRefType(false);
        td.setTypeClassName(((SchemaDefinitionDMW)ctd.getDefinedIn()).getSchemaPackage() + ".generated.types.DmcType" + ctd.getName());
        td.setPrimitiveType(((SchemaDefinitionDMW)ctd.getDefinedIn()).getSchemaPackage() + ".generated.types." + ctd.getName());
        td.setDefinedIn((SchemaDefinition)ctd.getDefinedIn());
        ((SchemaDefinitionDMW)ctd.getDefinedIn()).addInternalTypeDefList(td);
        this.internalTypeDefs.put(td.getName(), td);
        if (this.typeDefs.get(td.getName()) == null) {
            this.addType(td);
        }
    }

    void addExtendedReferenceType(ExtendedReferenceTypeDefinition ertd) throws ResultException, DmcValueException {
        if (!this.checkAndAdd(ertd.getObjectName(), ertd, this.extendedReferenceTypeDefs)) {
            ResultException ex = new ResultException();
            ex.addError(this.clashMsg(ertd.getObjectName(), (DmsDefinition)ertd, this.extendedReferenceTypeDefs, "extended reference type names"));
            throw ex;
        }
        if (!this.checkAndAddDOT(ertd.getDotName(), ertd, this.globallyUniqueMAP, null)) {
            ResultException ex = new ResultException();
            ex.addError(this.clashMsgDOT(ertd.getObjectName(), ertd, this.globallyUniqueMAP, "definition names"));
            this.currentSchema = null;
            throw ex;
        }
        TypeDefinition td = new TypeDefinition();
        td.setInternallyGenerated(true);
        td.setIsExtendedRefType(true);
        td.setName(ertd.getName());
        td.getDMO().setOriginalClass(ertd.getDMO().getExtendedReferenceClass().cloneMe());
        DotName typeName = new DotName((DotName)ertd.getDotName().getParentName(), "TypeDefinition");
        td.setDotName(typeName);
        td.addDescription("This is an internally generated type to represent extendedreference type " + ertd.getName() + " values.");
        td.setIsEnumType(false);
        td.setIsRefType(true);
        td.setTypeClassName(((SchemaDefinitionDMW)ertd.getDefinedIn()).getSchemaPackage() + ".generated.types.DmcType" + ertd.getName());
        td.setPrimitiveType(((SchemaDefinitionDMW)ertd.getDefinedIn()).getSchemaPackage() + ".generated.types." + ertd.getName());
        td.setDefinedIn((SchemaDefinition)ertd.getDefinedIn());
        ((SchemaDefinitionDMW)ertd.getDefinedIn()).addInternalTypeDefList(td);
        ((SchemaDefinitionDMW)ertd.getDefinedIn()).addTypeDefList(td);
        this.internalTypeDefs.put(td.getName(), td);
        if (this.typeDefs.get(td.getName()) == null) {
            this.addType(td);
        }
        ertd.setInternalType(td);
    }

    void addSlice(SliceDefinition sd) throws ResultException, DmcValueException {
        if (!this.checkAndAdd(sd.getObjectName(), sd, this.sliceDefs)) {
            ResultException ex = new ResultException();
            ex.addError(this.clashMsg(sd.getObjectName(), (DmsDefinition)sd, this.sliceDefs, "slice names"));
            throw ex;
        }
        if (!this.checkAndAddDOT(sd.getDotName(), sd, this.globallyUniqueMAP, null)) {
            ResultException ex = new ResultException();
            ex.addError(this.clashMsgDOT(sd.getObjectName(), sd, this.globallyUniqueMAP, "definition names"));
            throw ex;
        }
    }

    void addRuleCategory(RuleCategory rc) throws ResultException, DmcValueException {
        if (!this.checkAndAdd(rc.getObjectName(), rc, this.ruleCategoryDefs)) {
            ResultException ex = new ResultException();
            ex.addError(this.clashMsg(rc.getObjectName(), (DmsDefinition)rc, this.ruleCategoryDefs, "rule categories"));
            throw ex;
        }
        if (!this.checkAndAddDOT(rc.getDotName(), rc, this.globallyUniqueMAP, null)) {
            ResultException ex = new ResultException();
            ex.addError(this.clashMsgDOT(rc.getObjectName(), rc, this.globallyUniqueMAP, "definition names"));
            throw ex;
        }
        if (this.performIDChecks) {
            int base = ((SchemaDefinitionDMW)rc.getDefinedIn()).getSchemaBaseID();
            int range = ((SchemaDefinitionDMW)rc.getDefinedIn()).getSchemaIDRange();
            int current = rc.getRuleCategoryID();
            if (current >= range) {
                ResultException ex = new ResultException("Number of rule categories exceeds schema ID range: " + rc.getName());
                throw ex;
            }
            rc.setRuleCategoryID(base + current);
        }
        if (this.ruleCategoriesByID.get(rc.getRuleCategoryID()) != null) {
            ResultException ex = new ResultException();
            ex.addError(this.clashingIDsMsg(rc.getRuleCategoryID(), rc, this.ruleCategoriesByID, "ruleCategoryID"));
            throw ex;
        }
    }

    void addRuleDefinition(RuleDefinition rd) throws ResultException, DmcValueException, DmcNameClashException {
        ClassDefinition existing;
        try {
            rd.resolveReferences(this, this.currentResolver);
        }
        catch (DmcValueExceptionSet e) {
            ResultException ex = new ResultException();
            ex.addError("Unresolved references in RuleDefinition: " + rd.getName());
            for (DmcValueException dve : e.getExceptions()) {
                ex.moreMessages(dve.getMessage());
            }
            throw ex;
        }
        DefinitionName ruleClassName = new DefinitionName(rd.getName().getNameString() + "Data");
        if (!this.checkAndAdd(rd.getObjectName(), rd, this.ruleDefs)) {
            ResultException ex = new ResultException();
            ex.addError(this.clashMsg(rd.getObjectName(), (DmsDefinition)rd, this.ruleDefs, "rule definitions"));
            throw ex;
        }
        this.ruleDefsByDot.put((DotName)rd.getDotName().getParentName(), rd);
        if (!this.checkAndAddDOT(rd.getDotName(), rd, this.globallyUniqueMAP, null)) {
            ResultException ex = new ResultException();
            ex.addError(this.clashMsgDOT(rd.getObjectName(), rd, this.globallyUniqueMAP, "definition names"));
            throw ex;
        }
        int originalRefDefID = rd.getDmdID();
        if (this.performIDChecks) {
            int base = ((SchemaDefinitionDMW)rd.getDefinedIn()).getSchemaBaseID();
            int range = ((SchemaDefinitionDMW)rd.getDefinedIn()).getSchemaIDRange();
            int current = base + rd.getDmdID();
            if (current > base + range) {
                ResultException ex = new ResultException("Number of rules exceeds schema ID range: " + rd.getName());
                ex.moreMessages("The dmdID must be less than " + range);
                ex.setLocationInfo(rd.getFile(), rd.getLineNumber());
                throw ex;
            }
            rd.setDmdID(base + current);
        }
        if ((existing = this.classDefinitions.getDefinition(ruleClassName.getNameString())) != null && existing.getInternallyGenerated().booleanValue()) {
            return;
        }
        if (this.classesByID.get(rd.getDmdID()) != null) {
            ResultException ex = new ResultException();
            ex.addError(this.clashingIDsMsg(rd.getDmdID(), rd, this.classesByID, "dmdID"));
            throw ex;
        }
        ClassDefinition cd = new ClassDefinition();
        cd.setName(ruleClassName);
        if (rd.getIsExtensible().booleanValue()) {
            cd.setClassType((Object)ClassTypeEnum.EXTENSIBLE);
        } else {
            cd.setClassType((Object)ClassTypeEnum.STRUCTURAL);
        }
        cd.setDmdID(originalRefDefID);
        cd.setDerivedFrom(MetaSchemaAG._RuleData);
        cd.setInternallyGenerated(true);
        cd.setRuleDefinition(rd);
        cd.setIsNamedBy(MetaSchemaAG._ruleName);
        DotName className = new DotName(((DotName)rd.getDotName().getParentName()).getNameString() + "Data.ClassDefinition");
        cd.setDotName(className);
        cd.addMust(MetaSchemaAG._ruleName);
        cd.addMust(MetaSchemaAG._ruleTitle);
        cd.addMay(MetaSchemaAG._description);
        if (rd.getRuleType() == RuleTypeEnum.ATTRIBUTE) {
            cd.addMust(MetaSchemaAG._applyToAttribute);
        }
        cd.setFile(rd.getFile());
        cd.setLineNumber(rd.getLineNumber());
        cd.setDefinedIn((SchemaDefinition)rd.getDefinedIn());
        if (rd.getDescription() != null) {
            Iterator<String> it = rd.getDescription();
            while (it.hasNext()) {
                cd.addDescription(it.next());
            }
        }
        for (AttributeDefinition ad : rd.getMay()) {
            cd.addMay(ad);
        }
        for (AttributeDefinition ad : rd.getMust()) {
            cd.addMust(ad);
        }
        this.addClass(cd);
        ((SchemaDefinitionDMW)rd.getDefinedIn()).addClassDefList(cd);
    }

    void addClass(ClassDefinition cd) throws ResultException, DmcValueException {
        this.classDefinitions.add(cd);
        DotName refName = new DotName((DotName)cd.getDotName().getParentName(), "ClassDefinitionREF");
        if (this.debugClassAdditions) {
            DebugInfo.debug("Adding class: " + cd.getDotName() + "   " + refName);
        }
        if (!this.checkAndAddDOT(cd.getDotName(), cd, this.globallyUniqueMAP, refName)) {
            ResultException ex = new ResultException();
            ex.addError(this.clashMsgDOT(cd.getObjectName(), cd, this.globallyUniqueMAP, "definition names"));
            throw ex;
        }
        if (cd.getDmdID() == null) {
            ResultException ex = new ResultException("Missing dmdID for class: " + cd.getName());
            ex.setLocationInfo(cd.getFile(), cd.getLineNumber());
            throw ex;
        }
        if (cd.getDefinedIn() == null) {
            ResultException ex = new ResultException("definedIn missing for class: " + cd.getName());
            ex.setLocationInfo(cd.getFile(), cd.getLineNumber());
            throw ex;
        }
        if (this.performIDChecks && (((SchemaDefinitionDMW)cd.getDefinedIn()).getSchemaBaseID() == null || ((SchemaDefinitionDMW)cd.getDefinedIn()).getSchemaIDRange() == null)) {
            ResultException ex = new ResultException("schemaBaseID or schemaIDRange missing for schema: " + ((SchemaDefinitionDMW)cd.getDefinedIn()).getName());
            throw ex;
        }
        if (this.performIDChecks) {
            int base = ((SchemaDefinitionDMW)cd.getDefinedIn()).getSchemaBaseID();
            int range = ((SchemaDefinitionDMW)cd.getDefinedIn()).getSchemaIDRange();
            int current = base + cd.getDmdID();
            if (current > base + range) {
                ResultException ex = new ResultException("Number of classes exceeds schema ID range: " + cd.getName());
                ex.moreMessages("The dmdID must be less than " + range);
                ex.setLocationInfo(cd.getFile(), cd.getLineNumber());
                throw ex;
            }
            cd.setDmdID(base + current);
        }
        if (this.classesByID.get(cd.getDmdID()) != null) {
            ResultException ex = new ResultException();
            ex.addError(this.clashingIDsMsg(cd.getDmdID(), cd, this.classesByID, "dmdID"));
            throw ex;
        }
        this.classesByID.put(cd.getDmdID(), cd);
        if (cd.getObjectName().getNameString().length() > this.longestClassName) {
            this.longestClassName = cd.getObjectName().getNameString().length();
        }
        try {
            cd.resolveReferences(this, this.currentResolver);
        }
        catch (DmcValueExceptionSet e) {
            ResultException ex = new ResultException();
            ex.addError("Unresolved references in ClassDefinition: " + cd.getName());
            ex.addError(cd.toOIF());
            for (DmcValueException dve : e.getExceptions()) {
                ex.moreMessages(dve.getMessage());
            }
            throw ex;
        }
        if (cd.getDerivedFrom() != null) {
            cd.getDerivedFrom().updateDerived(cd);
        }
        cd.setDmoImport(((SchemaDefinitionDMW)cd.getDefinedIn()).getSchemaPackage() + ".generated.dmo." + cd.getName() + "DMO");
        cd.setDmoClass(cd.getName() + "DMO");
        cd.setDmwImport(((SchemaDefinitionDMW)cd.getDefinedIn()).getDmwPackage() + ".generated.dmw." + cd.getName() + "DMW");
        cd.setDmwClass(cd.getName() + "DMW");
        cd.setDmwIteratorImport(((SchemaDefinitionDMW)cd.getDefinedIn()).getDmwPackage() + ".generated.dmw." + cd.getName() + "IterableDMW");
        cd.setDmwIteratorClass(cd.getName() + "IterableDMW");
        cd.setDmtImport(((SchemaDefinitionDMW)cd.getDefinedIn()).getSchemaPackage() + ".generated.types.DmcType" + cd.getName() + "REF");
        cd.setDmtREFImport(((SchemaDefinitionDMW)cd.getDefinedIn()).getSchemaPackage() + ".generated.types." + cd.getName() + "REF");
        cd.setDmtClass(cd.getName() + "REF");
        if (cd.getUseWrapperType() == WrapperTypeEnum.EXTENDED) {
            if (cd.getSubpackage() == null) {
                cd.setDmeImport(((SchemaDefinitionDMW)cd.getDefinedIn()).getDmwPackage() + ".extended." + cd.getName());
            } else {
                cd.setDmeImport(((SchemaDefinitionDMW)cd.getDefinedIn()).getDmwPackage() + ".extended." + cd.getSubpackage() + "." + cd.getName());
            }
            cd.setDmeClass(cd.getName());
        } else {
            cd.setDmeImport("THE WRAPPER FOR " + cd.getName() + " ISN'T EXTENDED - YOU'VE GOT A CODE GENERATION ERROR! DWEEB!");
            cd.setDmeClass("THE WRAPPER FOR " + cd.getName() + " ISN'T EXTENDED - YOU'VE GOT A CODE GENERATION ERROR! DWEEB!");
        }
        if (cd.getClassType() == ClassTypeEnum.AUXILIARY) {
            cd.setDmoAuxClass(cd.getName() + "DMO");
            cd.setDmoAuxClassImport(((SchemaDefinitionDMW)cd.getDefinedIn()).getSchemaPackage() + ".generated.auxw." + cd.getName() + "DMO");
            if (((SchemaDefinitionDMW)cd.getDefinedIn()).getDmwPackage() != null) {
                cd.setDmwAuxClass(cd.getName());
                cd.setDmwAuxClassImport(((SchemaDefinitionDMW)cd.getDefinedIn()).getDmwPackage() + ".generated.auxw." + cd.getName());
            }
        }
        if (cd.getJavaClass() == null) {
            if (cd.getUseWrapperType() == WrapperTypeEnum.BASE) {
                cd.setJavaClass(cd.getDmwImport());
            } else if (cd.getUseWrapperType() == WrapperTypeEnum.EXTENDED) {
                cd.setJavaClass(cd.getDmeImport());
            }
        }
        this.classesByJavaClass.put(cd.getJavaClass(), cd);
        AttributeDefinitionIterableDMW adit = null;
        adit = cd.getMay();
        if (adit != null) {
            while (adit.hasNext()) {
                AttributeDefinition ad = (AttributeDefinition)adit.next();
                ad.addUsingClass(cd);
            }
        }
        if ((adit = cd.getMust()) != null) {
            while (adit.hasNext()) {
                AttributeDefinition ad = (AttributeDefinition)adit.next();
                ad.addUsingClass(cd);
            }
        }
        ActionDefinitionIterableDMW acdit = null;
        acdit = cd.getActions();
        if (acdit != null) {
            while (acdit.hasNext()) {
                ActionDefinition ad = (ActionDefinition)acdit.next();
                ad.addUsingClass(cd);
            }
        }
        if (cd.getClassType() != ClassTypeEnum.AUXILIARY) {
            TypeDefinition td = new TypeDefinition();
            td.setInternallyGenerated(true);
            td.setName(cd.getName());
            DotName typeName = new DotName((DotName)cd.getDotName().getParentName(), "TypeDefinition");
            td.setDotName(typeName);
            td.addDescription("This is an internally generated type to allow references to " + cd.getName() + " values.");
            td.setIsEnumType(false);
            td.setIsRefType(true);
            if (cd.getIsNamedBy() != null) {
                td.setHelperClassName(((SchemaDefinitionDMW)cd.getDefinedIn()).getSchemaPackage() + ".generated.types." + cd.getName() + "REF");
                if (cd.getIsNamedBy().getValueType() != ValueTypeEnum.SINGLE) {
                    ResultException ex = new ResultException();
                    ex.addError("The naming attribute: " + cd.getIsNamedBy().getName() + " for class: " + cd.getName() + " must be valueType SINGLE");
                    ex.result.lastResult().fileName(cd.getIsNamedBy().getFile());
                    ex.result.lastResult().lineNumber(cd.getIsNamedBy().getLineNumber());
                    throw ex;
                }
            }
            td.setTypeClassName(cd.getDmtImport());
            td.setPrimitiveType(cd.getDmoImport());
            td.setDefinedIn((SchemaDefinition)cd.getDefinedIn());
            if (cd.getJavaClass() != null) {
                td.setAuxHolderImport(cd.getJavaClass());
            }
            td.setDmwIteratorClass(cd.getDmwIteratorClass());
            td.setDmwIteratorImport(cd.getDmwIteratorImport());
            td.setOriginalClass(cd);
            cd.setInternalTypeRef(td);
            ((SchemaDefinitionDMW)cd.getDefinedIn()).addInternalTypeDefList(td);
            this.internalTypeDefs.put(td.getName(), td);
            if (!this.checkAndAddDOT(td.getDotName(), td, this.globallyUniqueMAP, null)) {
                ResultException ex = new ResultException();
                ex.addError(this.clashMsgDOT(td.getObjectName(), td, this.globallyUniqueMAP, "definition names"));
                throw ex;
            }
        }
        if (this.extensions.size() > 0) {
            for (SchemaExtensionIF ext : this.extensions.values()) {
                ext.addClass(cd);
            }
        }
    }

    void addAttribute(AttributeDefinition ad) throws ResultException, DmcValueException {
        this.attributeDefinitions.add(ad);
        if (!this.checkAndAddDOT(ad.getDotName(), ad, this.globallyUniqueMAP, null)) {
            ResultException ex = new ResultException();
            ex.addError(this.clashMsgDOT(ad.getObjectName(), ad, this.globallyUniqueMAP, "definition names"));
            throw ex;
        }
        if (ad.getDmdID() == null) {
            ResultException ex = new ResultException("Missing dmdID for attribute: " + ad.getName());
            throw ex;
        }
        if (ad.getDefinedIn() == null) {
            ResultException ex = new ResultException("definedIn missing for attribute: " + ad.getName());
            throw ex;
        }
        if (this.performIDChecks && (((SchemaDefinitionDMW)ad.getDefinedIn()).getSchemaBaseID() == null || ((SchemaDefinitionDMW)ad.getDefinedIn()).getSchemaIDRange() == null)) {
            ResultException ex = new ResultException("schemaBaseID or schemaIDRange missing for schema: " + ((SchemaDefinitionDMW)ad.getDefinedIn()).getName());
            throw ex;
        }
        if (this.performIDChecks) {
            int base = ((SchemaDefinitionDMW)ad.getDefinedIn()).getSchemaBaseID();
            int range = ((SchemaDefinitionDMW)ad.getDefinedIn()).getSchemaIDRange();
            int current = ad.getDmdID();
            if (current >= range) {
                ResultException ex = new ResultException("Number of attributes exceeds schema ID range: " + ad.getName());
                throw ex;
            }
            ad.setDmdID(base + current);
        }
        if (this.attrByID.get(ad.getDmdID()) != null) {
            ResultException ex = new ResultException();
            ex.addError(this.clashingIDsMsg(ad.getDmdID(), ad, this.attrByID, "dmdID"));
            throw ex;
        }
        this.attrByID.put(ad.getDmdID(), ad);
        if (ad.getAbbrev() != null) {
            DefinitionName abbrevName = new DefinitionName(ad.getAbbrev());
            DotName dotAbbrevName = new DotName(((SchemaDefinitionDMW)ad.getDefinedIn()).getName() + "." + ad.getAbbrev());
            if (!this.checkAndAddDOT(dotAbbrevName, ad, this.globallyUniqueMAP, null)) {
                DefinitionName errName = new DefinitionName(((SchemaDefinitionDMW)ad.getDefinedIn()).getName() + "." + ad.getAbbrev());
                ResultException ex = new ResultException();
                ex.addError(this.clashMsgDOT(errName, ad, this.globallyUniqueMAP, "definition names"));
                throw ex;
            }
            this.attrAbbrevs.put(abbrevName, ad);
        }
        if (this.extensions.size() > 0) {
            for (SchemaExtensionIF ext : this.extensions.values()) {
                ext.addAttribute(ad);
            }
        }
    }

    void addType(TypeDefinition td) throws ResultException, DmcValueException {
        DmcNamedObjectIF sd;
        if (!this.checkAndAdd(td.getObjectName(), td, this.typeDefs)) {
            ResultException ex = new ResultException();
            ex.addError(this.clashMsg(td.getObjectName(), (DmsDefinition)td, this.typeDefs, "type names"));
            throw ex;
        }
        if (!this.checkAndAddDOT(td.getDotName(), td, this.globallyUniqueMAP, null)) {
            ResultException ex = new ResultException();
            ex.addError(this.clashMsgDOT(td.getObjectName(), td, this.globallyUniqueMAP, "definition names"));
            throw ex;
        }
        if (td.getObjectName().getNameString().length() > this.longestTypeName) {
            this.longestTypeName = td.getObjectName().getNameString().length();
        }
        if ((sd = td.getDefinedIn()) != null && ((SchemaDefinitionDMW)sd).getDmwPackage() != null) {
            td.setDmwIteratorClass(td.getName().getNameString() + "IterableDMW");
            td.setDmwIteratorImport(((SchemaDefinitionDMW)sd).getDmwPackage() + ".generated.dmw." + td.getDmwIteratorClass());
        }
        if (this.extensions.size() > 0) {
            for (SchemaExtensionIF ext : this.extensions.values()) {
                ext.addType(td);
            }
        }
    }

    public void addDefinition(DmsDefinition def, DmcNameClashResolverIF clashResolver) throws ResultException, DmcValueException, DmcNameClashException {
        this.currentResolver = clashResolver;
        this.addDefinition(def);
        this.currentResolver = this;
    }

    void addDefinition(DmsDefinition def) throws ResultException, DmcValueException, DmcNameClashException {
        if (def.getDotName() == null) {
            DebugInfo.debug("NO DOT NAME");
        }
        if (def instanceof AttributeDefinition) {
            this.addAttribute((AttributeDefinition)def);
        } else if (def instanceof ClassDefinition) {
            this.addClass((ClassDefinition)def);
        } else if (def instanceof ActionDefinition) {
            this.addAction((ActionDefinition)def);
        } else if (def instanceof TypeDefinition) {
            this.addType((TypeDefinition)def);
        } else if (def instanceof EnumDefinition) {
            this.addEnum((EnumDefinition)def);
        } else if (def instanceof SliceDefinition) {
            this.addSlice((SliceDefinition)def);
        } else if (def instanceof RuleCategory) {
            this.addRuleCategory((RuleCategory)def);
        } else if (def instanceof RuleDefinition) {
            this.addRuleDefinition((RuleDefinition)def);
        } else if (def instanceof ExtendedReferenceTypeDefinition) {
            this.addExtendedReferenceType((ExtendedReferenceTypeDefinition)def);
        } else if (def instanceof ComplexTypeDefinition) {
            this.addComplexType((ComplexTypeDefinition)def);
        } else if (def instanceof SchemaDefinition) {
            this.addSchema((SchemaDefinition)def);
        } else if (def instanceof DSDefinitionModule) {
            this.addDefinitionModule((DSDefinitionModule)def, false);
        } else {
            ResultException ex = new ResultException();
            ex.addError("The specified object is not a DmsDefinition object: \n" + def.toOIF());
            throw ex;
        }
        if (this.listeners != null) {
            for (SchemaDefinitionListenerIF listener : this.listeners) {
                listener.definitionAdded(def.getDMO());
            }
        }
    }

    public void addRuleData(RuleData rule) throws ResultException {
        RuleData existing = this.ruleData.get(rule.getObjectName());
        if (existing != null) {
            ResultException ex = new ResultException();
            ex.addError("The following rules have a name clash:\n\n" + existing.toOIF() + "\n" + rule.toOIF());
            throw ex;
        }
        this.ruleData.put(rule.getObjectName(), rule);
    }

    boolean addEnum(EnumDefinition evd) throws ResultException, DmcValueException {
        this.enumDefinitions.add(evd);
        if (!this.checkAndAddDOT(evd.getDotName(), evd, this.globallyUniqueMAP, null)) {
            ResultException ex = new ResultException();
            ex.addError(this.clashMsgDOT(evd.getObjectName(), evd, this.globallyUniqueMAP, "definition names"));
            throw ex;
        }
        TypeDefinition td = new TypeDefinition();
        td.setInternallyGenerated(true);
        td.setName(evd.getName());
        DotName typeName = new DotName((DotName)evd.getDotName().getParentName(), "TypeDefinition");
        td.setDotName(typeName);
        td.setEnumName(evd.getName().getNameString());
        td.addDescription("This is an internally generated type to allow references to " + evd.getName() + " values.");
        td.setIsEnumType(true);
        td.setTypeClassName(((SchemaDefinitionDMW)evd.getDefinedIn()).getSchemaPackage() + ".generated.types.DmcType" + evd.getName());
        td.setPrimitiveType(((SchemaDefinitionDMW)evd.getDefinedIn()).getSchemaPackage() + ".generated.enums." + evd.getName());
        td.setDefinedIn((SchemaDefinition)evd.getDefinedIn());
        if (evd.getNullReturnValue() != null) {
            td.setNullReturnValue(evd.getNullReturnValue());
        }
        this.internalTypeDefs.put(td.getName(), td);
        ((SchemaDefinitionDMW)evd.getDefinedIn()).addInternalTypeDefList(td);
        this.addType(td);
        if (evd.getObjectName().getNameString().length() > this.longestEnumName) {
            this.longestActionName = evd.getObjectName().getNameString().length();
        }
        if (this.extensions.size() > 0) {
            for (SchemaExtensionIF ext : this.extensions.values()) {
                ext.addEnum(evd);
            }
        }
        return true;
    }

    void addAction(ActionDefinition actd) throws ResultException, DmcValueException {
        AttributeDefinition ad;
        try {
            actd.resolveReferences(this, this.currentResolver);
        }
        catch (DmcValueExceptionSet e) {
            e.printStackTrace();
        }
        if (!this.checkAndAdd(actd.getObjectName(), actd, this.actionDefs)) {
            ResultException ex = new ResultException();
            ex.addError(this.clashMsg(actd.getObjectName(), (DmsDefinition)actd, this.actionDefs, "action names"));
            throw ex;
        }
        if (!this.checkAndAddDOT(actd.getDotName(), actd, this.globallyUniqueMAP, null)) {
            ResultException ex = new ResultException();
            ex.addError(this.clashMsgDOT(actd.getObjectName(), actd, this.globallyUniqueMAP, "definition names"));
            throw ex;
        }
        if (actd.getObjectName().getNameString().length() > this.longestActionName) {
            this.longestActionName = actd.getObjectName().getNameString().length();
        }
        AttributeDefinitionIterableDMW it = null;
        it = actd.getMayParm();
        if (it != null) {
            while (it.hasNext()) {
                ad = (AttributeDefinition)it.next();
                ad.addUsingAction(actd);
            }
        }
        if ((it = actd.getMustParm()) != null) {
            while (it.hasNext()) {
                ad = (AttributeDefinition)it.next();
                ad.addUsingAction(actd);
            }
        }
        ClassDefinitionIterableDMW cdit = null;
        cdit = actd.getAttachToClass();
        if (cdit != null) {
            while (cdit.hasNext()) {
                ClassDefinition cd = (ClassDefinition)cdit.next();
                actd.addAttachedToClass(cd);
            }
        }
        if (this.extensions.size() > 0) {
            for (SchemaExtensionIF ext : this.extensions.values()) {
                ext.addAction(actd);
            }
        }
    }

    private boolean checkAndAdd(DefinitionName key, DmsDefinition obj, HashMap map) {
        if (map.containsKey(key)) {
            return false;
        }
        map.put(key, obj);
        return true;
    }

    private boolean checkAndAddDOT(DotName key, DmsDefinition obj, HashMap<DotName, DmsDefinition> map, DotName refName) {
        if (map.containsKey(key)) {
            DebugInfo.debug("Could not add to globallyUniqueMAP: " + key);
            return false;
        }
        map.put(key, obj);
        if (refName != null) {
            map.put(refName, obj);
        }
        DotName defAndType = key.trimRoot();
        if (obj instanceof SchemaDefinition) {
            defAndType = (DotName)key.getParentName();
        }
        ArrayList<DmsDefinition> defs = this.clashMAP.get(defAndType);
        if (this.debugClashmap) {
            DebugInfo.debug("Adding to clashMAP - " + obj.getConstructionClassName() + ": " + defAndType + "\n\n");
        }
        if (defs == null) {
            defs = new ArrayList(1);
            defs.add(obj);
            this.clashMAP.put(defAndType, defs);
            if (obj.getConstructionClassInfo() == MetaDMSAG.__ClassDefinition) {
                this.addBaseClassVariants(obj, obj.getConstructionClassInfo().derivedFrom, map);
            }
        } else {
            if (this.debugClashmap) {
                DebugInfo.debug("CLASHING definition");
            }
            defs.add(obj);
        }
        if (refName != null) {
            DotName classRefKey = refName.trimRoot();
            if (this.debugClashmap) {
                DebugInfo.debug("Adding REF Type: " + refName + "    *" + classRefKey + "*   clashMap: " + System.identityHashCode(this.clashMAP));
            }
            if ((defs = this.clashMAP.get(classRefKey)) == null) {
                defs = new ArrayList(1);
                defs.add(obj);
                this.clashMAP.put(classRefKey, defs);
            } else {
                if (this.debugClashmap) {
                    DebugInfo.debug("CLASHING CLASSREF definition");
                }
                defs.add(obj);
            }
        }
        return true;
    }

    void addBaseClassVariants(DmsDefinition obj, DmcClassInfo ci, HashMap<DotName, DmsDefinition> map) {
        if (ci != null) {
            try {
                DotName dn = new DotName(obj.getName() + "." + ci.name);
                ArrayList<DmsDefinition> defs = this.clashMAP.get(dn);
                if (this.debugClassAdditions) {
                    DebugInfo.debug("Adding to VARIANT clashMAP - " + obj.getConstructionClassName() + ": " + dn + "\n\n");
                }
                if (defs == null) {
                    defs = new ArrayList(1);
                    defs.add(obj);
                    this.clashMAP.put(dn, defs);
                } else {
                    if (this.debugClassAdditions) {
                        DebugInfo.debug("CLASHING definition");
                    }
                    defs.add(obj);
                }
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Couldn't construct a DotName from \"" + obj.getName() + "." + ci.name + "\"");
            }
        }
        if (ci.derivedFrom != null) {
            this.addBaseClassVariants(obj, ci.derivedFrom, map);
        }
    }

    private boolean checkAndAdd(Object key, Object obj, TreeMap map) {
        if (map.containsKey(key)) {
            return false;
        }
        map.put(key, obj);
        return true;
    }

    public String toString() {
        int longest = this.longestClassName;
        StringBuffer sb = new StringBuffer();
        PrintfFormat format = null;
        if (this.attributeDefinitions.getLongestName() > longest) {
            longest = this.attributeDefinitions.getLongestName();
        }
        String longestStr = "" + longest;
        format = new PrintfFormat("%-" + longestStr + "s ");
        sb.append("*** Attributes\n");
        TreeMap<DefinitionName, AttributeDefinition> sattrs = new TreeMap<DefinitionName, AttributeDefinition>();
        for (AttributeDefinition ad : this.attributeDefinitions.values()) {
            sattrs.put(ad.getName(), ad);
        }
        for (AttributeDefinition ad : sattrs.values()) {
            sb.append(format.sprintf(ad.getObjectName()) + ((SchemaDefinitionDMW)ad.getDefinedIn()).getName() + "\n");
        }
        sb.append("*** Classes\n");
        for (ClassDefinition cd : this.classDefinitions.values()) {
            sb.append(format.sprintf(cd.getObjectName()));
            if (cd.getAbbrev() != null) {
                sb.append(" AB " + cd.getAbbrev());
            }
            sb.append(((SchemaDefinitionDMW)cd.getDefinedIn()).getName() + "\n");
        }
        return new String(sb.toString());
    }

    @Override
    public DmcNamedObjectIF findNamedObject(DmcObjectName name) {
        throw new IllegalStateException("The SchemaManager is designed to work with ambiguous naming. Use DmcObject.resolveReferences(DmcNameResolverWithClashSupportIF, DmcNameClashResolverIF)\n\n" + DebugInfo.getCurrentStack());
    }

    @Override
    public DmcNamedObjectIF findNamedObject(DmcObjectName name, int attributeID) {
        DmcNamedObjectIF def;
        AttributeDefinition ad;
        DmcNamedObjectIF def2;
        if (attributeID == MetaDMSAG.__internalTypeRef.id) {
            DmcNamedObjectIF def3 = this.internalTypeDefs.get(name);
            return def3;
        }
        if (attributeID == MetaDMSAG.__type.id) {
            def2 = this.internalTypeDefs.get(name);
            if (def2 != null) {
                return def2;
            }
        } else if (attributeID == MetaDMSAG.__internalTypeDefList.id) {
            def2 = this.internalTypeDefs.get(name);
            if (def2 != null) {
                return def2;
            }
        } else if (attributeID == MetaDMSAG.__enumDefList.id) {
            def2 = null;
            try {
                def2 = this.enumDefinitions.getDefinition(name.getNameString());
            }
            catch (DmcNameClashException e) {
                e.printStackTrace();
            }
            catch (DmcValueException e) {
                e.printStackTrace();
            }
            if (def2 != null) {
                return def2;
            }
        } else if (attributeID == MetaDMSAG.__extendedReferenceTypeDefList.id ? (def2 = (DmcNamedObjectIF)this.extendedReferenceTypeDefs.get(name)) != null : attributeID == MetaDMSAG.__complexTypeDefList.id && (def2 = (DmcNamedObjectIF)this.complexTypeDefs.get(name)) != null) {
            return def2;
        }
        if ((ad = this.attrByID.get(attributeID)) != null && ad.getDMO().getType().getObjectName().getNameString().equals(MetaDMSAG.__type_TypeDefinition.name) && (def = (DmcNamedObjectIF)this.internalTypeDefs.get(name)) != null) {
            return def;
        }
        return this.findNamedObject(name);
    }

    @Override
    public DmcObject findNamedDMO(DmcObjectName name) {
        throw new IllegalStateException("The SchemaManager is designed to work with ambiguous naming. Use DmcObject.resolveReferences(DmcNameResolverWithClashSupportIF, DmcNameClashResolverIF)\n\n" + DebugInfo.getCurrentStack());
    }

    public DmcNamedObjectIF findNamedObject(String name) {
        throw new IllegalStateException("The SchemaManager is designed to work with ambiguous naming. Use DmcObject.resolveReferences(DmcNameResolverWithClashSupportIF, DmcNameClashResolverIF)\n\n" + DebugInfo.getCurrentStack());
    }

    String clashMsg(DefinitionName defName, DmsDefinition newDef, HashMap<DefinitionName, ? extends DmsDefinition> defMap, String defType) {
        DmsDefinition existing = defMap.get(defName);
        DmcNamedObjectIF ga1 = existing.getDefinedIn();
        DmcNamedObjectIF ga2 = newDef.getDefinedIn();
        if (ga2 == null) {
            return new String("Clashing " + defType + ": " + defName + " - Initially defined as part of " + ((SchemaDefinitionDMW)ga1).getObjectName() + " - Redefined in " + this.currentSchema.getObjectName());
        }
        return new String("Clashing " + defType + ": " + defName + " - Initially defined as part of " + ((SchemaDefinitionDMW)ga1).getObjectName() + " - Redefined in " + ((SchemaDefinitionDMW)ga2).getObjectName());
    }

    String clashMsgDOT(DefinitionName defName, DmsDefinition newDef, HashMap<DotName, ? extends DmsDefinition> defMap, String defType) {
        DmsDefinition existing = defMap.get(defName);
        DmcNamedObjectIF ga1 = existing.getDefinedIn();
        DmcNamedObjectIF ga2 = newDef.getDefinedIn();
        if (ga2 == null) {
            return new String("Clashing " + defType + ": " + defName + " - Initially defined as part of " + ((SchemaDefinitionDMW)ga1).getObjectName() + " - Redefined in " + this.currentSchema.getObjectName());
        }
        return new String("Clashing " + defType + ": " + defName + " - Initially defined as part of " + ((SchemaDefinitionDMW)ga1).getObjectName() + " - Redefined in " + ((SchemaDefinitionDMW)ga2).getObjectName());
    }

    String clashMsg(DefinitionName defName, DmsDefinition newDef, TreeMap<DefinitionName, ? extends DmsDefinition> defMap, String defType) {
        DmsDefinition existing = defMap.get(defName);
        DmcNamedObjectIF ga1 = existing.getDefinedIn();
        DmcNamedObjectIF ga2 = newDef.getDefinedIn();
        if (existing instanceof SchemaDefinition) {
            return new String("Clashing " + defType + ": " + defName);
        }
        if (ga2 == null) {
            return new String("Clashing " + defType + ": " + defName + " - Initially defined as part of " + ((SchemaDefinitionDMW)ga1).getObjectName() + " - Redefined in " + this.currentSchema.getObjectName());
        }
        return new String("Clashing " + defType + ": " + defName + " - Initially defined as part of " + ((SchemaDefinitionDMW)ga1).getObjectName() + " - Redefined in " + ((SchemaDefinitionDMW)ga2).getObjectName());
    }

    String clashingIDsMsg(Integer defID, DmsDefinition newDef, TreeMap<Integer, ? extends DmsDefinition> defMap, String defType) {
        DmsDefinition existing = defMap.get(defID);
        DmcNamedObjectIF ga1 = existing.getDefinedIn();
        DmcNamedObjectIF ga2 = newDef.getDefinedIn();
        DebugInfo.debugWithTrace("clashMsg()");
        if (existing instanceof SchemaDefinition) {
            return new String("Clashing " + defType + ": " + defID);
        }
        if (ga2 == null) {
            return new String("Clashing " + defType + ": " + defID + " " + newDef.getName() + "(" + this.justFileName(newDef) + ") - Initially defined in " + ((SchemaDefinitionDMW)ga1).getObjectName() + " existing: " + existing.getName() + "(" + this.justFileName(existing) + ") - Redefined in " + this.currentSchema.getObjectName());
        }
        return new String("Clashing " + defType + ": " + defID + " " + newDef.getName() + "(" + this.justFileName(newDef) + ") - Initially defined in " + ((SchemaDefinitionDMW)ga1).getObjectName() + " existing: " + existing.getName() + "(" + this.justFileName(existing) + ") - Redefined in " + ((SchemaDefinitionDMW)ga2).getObjectName());
    }

    String justFileName(DmsDefinition def) {
        if (def.getFile() == null) {
            return "";
        }
        int lastslash = def.getFile().lastIndexOf(47);
        if (lastslash == -1) {
            return "";
        }
        return def.getFile().substring(lastslash + 1);
    }

    public void diff(SchemaManager predecessor, StringBuffer sb) {
        int deleted;
        int added = this.newSchemas(predecessor, sb);
        if (added + (deleted = this.deletedSchemas(predecessor, sb)) == 0) {
            sb.append("No schemas were added or deleted");
        }
        sb.append("\n");
        if (this.newClasses(predecessor, sb) == 0) {
            sb.append("No classes were added or deleted");
        }
        sb.append("\n");
        if (this.newAttributes(predecessor, sb) == 0) {
            sb.append("No attributes were added or deleted");
        }
        sb.append("\n");
        if (this.newTypes(predecessor, sb) == 0) {
            sb.append("No types were added or deleted");
        }
        sb.append("\n");
    }

    int newSchemas(SchemaManager predecessor, StringBuffer sb) {
        Iterator<SchemaDefinition> it = this.schemaDefs.values().iterator();
        int rc = 0;
        while (it.hasNext()) {
            SchemaDefinition sd = it.next();
            if (predecessor.schemaDefs.get(sd.getObjectName()) != null) continue;
            sb.append("Schema added: " + sd.getObjectName() + "\n");
            ++rc;
        }
        return rc;
    }

    int deletedSchemas(SchemaManager predecessor, StringBuffer sb) {
        Iterator<SchemaDefinition> it = predecessor.schemaDefs.values().iterator();
        int rc = 0;
        while (it.hasNext()) {
            SchemaDefinition sd = it.next();
            if (this.schemaDefs.get(sd.getObjectName()) != null) continue;
            sb.append("Schema removed: " + sd.getObjectName() + "\n");
            ++rc;
        }
        return rc;
    }

    int newClasses(SchemaManager predecessor, StringBuffer sb) {
        Iterator<SchemaDefinition> it = this.schemaDefs.values().iterator();
        int rc = 0;
        StringBuffer classDiff = new StringBuffer();
        while (it.hasNext()) {
            int changes;
            SchemaDefinition curr = it.next();
            SchemaDefinition pred = predecessor.schemaDefs.get(curr.getObjectName());
            if (pred == null || (changes = curr.classChanges(pred, classDiff)) <= 0) continue;
            rc += changes;
            sb.append("\nClass changes for schema: " + curr.getObjectName() + "\n");
            sb.append(classDiff.toString());
            classDiff.setLength(0);
        }
        return rc;
    }

    int newAttributes(SchemaManager predecessor, StringBuffer sb) {
        Iterator<SchemaDefinition> it = this.schemaDefs.values().iterator();
        int rc = 0;
        StringBuffer attrDiff = new StringBuffer();
        while (it.hasNext()) {
            int changes;
            SchemaDefinition curr = it.next();
            SchemaDefinition pred = predecessor.schemaDefs.get(curr.getObjectName());
            if (pred == null || (changes = curr.attributeChanges(pred, attrDiff, this)) <= 0) continue;
            rc += changes;
            sb.append("\nAttribute changes for schema: " + curr.getObjectName() + "\n");
            sb.append(attrDiff.toString());
            attrDiff.setLength(0);
        }
        return rc;
    }

    int newTypes(SchemaManager predecessor, StringBuffer sb) {
        Iterator<SchemaDefinition> it = this.schemaDefs.values().iterator();
        int rc = 0;
        StringBuffer typeDiff = new StringBuffer();
        while (it.hasNext()) {
            int changes;
            SchemaDefinition curr = it.next();
            SchemaDefinition pred = predecessor.schemaDefs.get(curr.getObjectName());
            if (pred == null || (changes = curr.typeChanges(pred, typeDiff)) <= 0) continue;
            rc += changes;
            sb.append("\nType changes for schema: " + curr.getObjectName() + "\n");
            sb.append(typeDiff.toString());
            typeDiff.setLength(0);
        }
        return rc;
    }

    public AttributeDefinition adef(String n) {
        AttributeDefinition rc = this.isAttribute(n);
        if (rc == null) {
            return null;
        }
        return rc;
    }

    public AttributeDefinition adef(ClassDefinition cd, String n) throws DmcValueException {
        AttributeDefinition rc = null;
        try {
            rc = this.attributeDefinitions.getDefinition(n);
        }
        catch (DmcNameClashException ex) {
            Iterator<DmcNamedObjectIF> matches = ex.getMatches();
            AttributeDefinition fromMeta = null;
            AttributeDefinition exact = null;
            while (matches.hasNext()) {
                AttributeDefinition adef = (AttributeDefinition)matches.next();
                if (((SchemaDefinitionDMW)adef.getDefinedIn()).getName().equals(((SchemaDefinitionDMW)cd.getDefinedIn()).getName())) {
                    exact = adef;
                    break;
                }
                if (!((SchemaDefinitionDMW)adef.getDefinedIn()).getName().equals("meta")) continue;
                fromMeta = adef;
            }
            rc = exact != null ? exact : fromMeta;
        }
        return rc;
    }

    public AttributeDefinition adef(DotName dn) {
        return this.attributeDefinitions.getDefinition(dn);
    }

    public ClassDefinition cdef(String n) throws DmcNameClashException, DmcValueException {
        ClassDefinition rc;
        if (n.contains(".")) {
            try {
                DefinitionName dn = new DefinitionName(n);
                DmsDefinition def = this.globallyUniqueMAP.get(dn);
                if (def instanceof ClassDefinition) {
                    return (ClassDefinition)def;
                }
                return null;
            }
            catch (DmcValueException e) {
                e.printStackTrace();
            }
        }
        if ((rc = this.isClass(n)) == null) {
            return null;
        }
        return rc;
    }

    public TypeDefinition tdef(String n) {
        TypeDefinition rc = this.isType(n);
        if (rc == null) {
            return null;
        }
        return rc;
    }

    public ActionDefinition actdef(String n) {
        ActionDefinition rc = this.isAction(n);
        if (rc == null) {
            return null;
        }
        return rc;
    }

    DefinitionName getDefName(String n) {
        DefinitionName rc = null;
        try {
            rc = new DefinitionName(n);
        }
        catch (DmcValueException e) {
            e.printStackTrace();
        }
        return rc;
    }

    public void resolveReferences(SchemaDefinition sd, DmcNameClashResolverIF clashResolver) throws ResultException, DmcNameClashException, DmcValueException {
        SliceDefinitionIterableDMW sdl;
        TypeDefinitionIterableDMW tdl;
        EnumDefinitionIterableDMW edl;
        ClassDefinitionIterableDMW cdl;
        AttributeDefinitionIterableDMW adl;
        ActionDefinitionIterableDMW actdl;
        ExtendedReferenceTypeDefinitionIterableDMW ertdl;
        ComplexTypeDefinitionIterableDMW ctdl;
        AttributeDefinitionIterableDMW preadl = sd.getAttributeDefList();
        if (preadl != null) {
            while (preadl.hasNext()) {
                AttributeDefinition d = (AttributeDefinition)preadl.next();
                try {
                    d.resolveReferences(this, clashResolver);
                }
                catch (DmcValueExceptionSet e) {
                    e.printStackTrace();
                }
            }
        }
        if ((ctdl = sd.getComplexTypeDefList()) != null) {
            while (ctdl.hasNext()) {
                ComplexTypeDefinition ctd = (ComplexTypeDefinition)ctdl.next();
                try {
                    ctd.resolveReferences(this, clashResolver);
                }
                catch (DmcValueExceptionSet e) {
                    ResultException ex = new ResultException();
                    ex.addError(e.toString());
                    ex.result.lastResult().fileName(ctd.getFile());
                    ex.result.lastResult().lineNumber(ctd.getLineNumber());
                    throw ex;
                }
            }
        }
        if ((ertdl = sd.getExtendedReferenceTypeDefList()) != null) {
            while (ertdl.hasNext()) {
                ExtendedReferenceTypeDefinition ertd = (ExtendedReferenceTypeDefinition)ertdl.next();
                try {
                    ertd.resolveReferences(this, clashResolver);
                }
                catch (DmcValueExceptionSet e1) {
                    e1.printStackTrace();
                }
                if (ertd.getExtendedReferenceClass().getIsNamedBy() != null) continue;
                ResultException ex = new ResultException();
                ex.addError("The class: " + ertd.getExtendedReferenceClass().getObjectName().getNameString() + " referred to in ExtendedReferenceTypeDefinition " + ertd.getName() + " is not a named object.");
                ex.result.lastResult().fileName(ertd.getFile());
                ex.result.lastResult().lineNumber(ertd.getLineNumber());
                throw ex;
            }
        }
        if ((actdl = sd.getActionDefList()) != null) {
            while (actdl.hasNext()) {
                ActionDefinition d = (ActionDefinition)actdl.next();
                try {
                    d.resolveReferences(this, clashResolver);
                }
                catch (DmcValueExceptionSet e) {
                    ResultException ex = new ResultException();
                    ex.addError("Unresolved references in ActionDefinition: " + d.getName());
                    ex.setLocationInfo(d.getFile(), d.getLineNumber());
                    for (DmcValueException dve : e.getExceptions()) {
                        ex.moreMessages(dve.getMessage());
                    }
                    throw ex;
                }
            }
        }
        if ((adl = sd.getAttributeDefList()) != null) {
            while (adl.hasNext()) {
                AttributeDefinition d = (AttributeDefinition)adl.next();
                try {
                    d.resolveReferences(this, clashResolver);
                }
                catch (DmcValueExceptionSet e) {
                    ResultException ex = new ResultException();
                    ex.addError("Unresolved references in AttributeDefinition: " + d.getName());
                    ex.setLocationInfo(d.getFile(), d.getLineNumber());
                    for (DmcValueException dve : e.getExceptions()) {
                        ex.moreMessages(dve.getMessage());
                    }
                    throw ex;
                }
                if (d.getValueType() != ValueTypeEnum.HASHMAPPED && d.getValueType() != ValueTypeEnum.TREEMAPPED || d.getType().getKeyClass() != null) continue;
                if (d.getType().getIsRefType().booleanValue()) {
                    if (d.getType().getIsExtendedRefType().booleanValue()) {
                        ResultException ex = new ResultException();
                        ex.addError("AttributeDefinition: " + d.getName() + " cannot have valueType HASHMAPPED/TREEMAPPED since extended reference types are not keyed.");
                        ex.setLocationInfo(d.getFile(), d.getLineNumber());
                        throw ex;
                    }
                    if (d.getType().getOriginalClass().getIsNamedBy() != null) continue;
                    ResultException ex = new ResultException();
                    ex.addError("AttributeDefinition: " + d.getName() + " cannot have valueType HASHMAPPED/TREEMAPPED since the " + d.getType().getName() + " type does not refer to a named object.");
                    ex.setLocationInfo(d.getFile(), d.getLineNumber());
                    throw ex;
                }
                ResultException ex = new ResultException();
                ex.addError("AttributeDefinition: " + d.getName() + " cannot have valueType HASHMAPPED/TREEMAPPED since the " + d.getType().getName() + " type does not have a specified keyClass.");
                ex.setLocationInfo(d.getFile(), d.getLineNumber());
                throw ex;
            }
        }
        if ((cdl = sd.getClassDefList()) != null) {
            while (cdl.hasNext()) {
                ClassDefinition d = (ClassDefinition)cdl.next();
                try {
                    d.resolveReferences(this, clashResolver);
                    if (d.getAllowedParentsSize() <= 0) continue;
                    if (d.getIsNamedBy() == null) {
                        ResultException ex = new ResultException();
                        ex.addError("The following class indicates that it has allowed parents, but isn't a named object: " + d.getName());
                        throw ex;
                    }
                    if (d.getIsNamedBy().getType().getIsHierarchicName().booleanValue()) continue;
                    ResultException ex = new ResultException();
                    ex.addError("The following class indicates that it has allowed parents, but its naming attribute isn't heirarchic: " + d.getName());
                    ex.result.lastResult().moreMessages("isNamedBy: " + d.getIsNamedBy().getName());
                    throw ex;
                }
                catch (DmcValueExceptionSet e) {
                    ResultException ex = new ResultException();
                    ex.addError("Unresolved references in ClassDefinition: " + d.getName());
                    ex.setLocationInfo(d.getFile(), d.getLineNumber());
                    for (DmcValueException dve : e.getExceptions()) {
                        ex.moreMessages(dve.getMessage());
                    }
                    throw ex;
                }
            }
        }
        if ((edl = sd.getEnumDefList()) != null) {
            while (edl.hasNext()) {
                EnumDefinition d = (EnumDefinition)edl.next();
                try {
                    d.resolveReferences(this, clashResolver);
                }
                catch (DmcValueExceptionSet e) {
                    ResultException ex = new ResultException();
                    ex.addError("Unresolved references in EnumDefinition: " + d.getName());
                    ex.setLocationInfo(d.getFile(), d.getLineNumber());
                    for (DmcValueException dve : e.getExceptions()) {
                        ex.moreMessages(dve.getMessage());
                    }
                    throw ex;
                }
            }
        }
        if ((tdl = sd.getTypeDefList()) != null) {
            while (tdl.hasNext()) {
                TypeDefinition d = (TypeDefinition)tdl.next();
                try {
                    d.resolveReferences(this, clashResolver);
                }
                catch (DmcValueExceptionSet e) {
                    ResultException ex = new ResultException();
                    ex.addError("Unresolved references in TypeDefinition: " + d.getName());
                    ex.setLocationInfo(d.getFile(), d.getLineNumber());
                    for (DmcValueException dve : e.getExceptions()) {
                        ex.moreMessages(dve.getMessage());
                    }
                    throw ex;
                }
            }
        }
        if ((sdl = sd.getSliceDefList()) != null) {
            while (sdl.hasNext()) {
                SliceDefinition s = (SliceDefinition)sdl.next();
                try {
                    s.resolveReferences(this, clashResolver);
                }
                catch (DmcValueExceptionSet e) {
                    ResultException ex = new ResultException();
                    ex.addError("Unresolved references in SliceDefinition: " + s.getName());
                    ex.setLocationInfo(s.getFile(), s.getLineNumber());
                    for (DmcValueException dve : e.getExceptions()) {
                        ex.moreMessages(dve.getMessage());
                    }
                    throw ex;
                }
            }
        }
        TreeMap<RuleName, RuleIF> theRules = sd.getRuleInstances(this);
        for (RuleIF rule : theRules.values()) {
            try {
                if (rule.getRuleDataDMO().getRuleName().equals("dmvRRRApplyToAttribute")) {
                    DebugInfo.debug("HERE");
                }
                rule.getRuleDataDMO().resolveReferences(this, clashResolver);
            }
            catch (DmcValueExceptionSet e) {
                ResultException ex = new ResultException();
                ex.addError("Unresolved references in rule data: " + rule.getRuleDataDMO().getRuleName());
                for (DmcValueException dve : e.getExceptions()) {
                    ex.moreMessages(dve.getMessage());
                }
                throw ex;
            }
        }
        sd.setResolvedRules(theRules);
        if (!sd.isGeneratedSchema() && (cdl = sd.getClassDefList()) != null) {
            while (cdl.hasNext()) {
                ClassDefinition cd = (ClassDefinition)cdl.next();
                if (cd.getDsdModuleDefinition() == null) continue;
                ClassDefinition base = (ClassDefinition)cd.getDsdModuleDefinition().getBaseDefinition();
                base.setPartOfDefinitionModule(cd.getDsdModuleDefinition());
                TreeMap<DefinitionName, ClassDefinition> derived = base.getAllDerived();
                for (ClassDefinition d : derived.values()) {
                    d.setPartOfDefinitionModule(cd.getDsdModuleDefinition());
                }
            }
        }
    }

    public void resolveNameTypes(Iterator<AttributeDefinition> adl) throws ResultException {
        if (adl != null) {
            while (adl.hasNext()) {
                AttributeDefinition ad = adl.next();
                if (!ad.getType().getIsNameType().booleanValue() || !ad.getDesignatedNameAttribute().booleanValue()) continue;
                if (ad.getType().getNameAttributeDef() != null) {
                    if (ad == ad.getType().getNameAttributeDef()) continue;
                    AttributeDefinition nd = ad.getType().getNameAttributeDef();
                    String sn = ((SchemaDefinitionDMW)ad.getDefinedIn()).getName().getNameString();
                    ResultException ex = new ResultException();
                    ex.addError("Only one attribute may be defined of type: " + ad.getType().getName());
                    ex.result.lastResult().moreMessages("You must use the \"" + nd.getName() + "\" attribute from the " + sn + " schema.");
                    ex.result.lastResult().moreMessages("This error was caused by the " + ad.getName() + " attribute definition.");
                    throw ex;
                }
                try {
                    ad.getType().setNameAttributeDef(ad);
                }
                catch (DmcValueException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public Iterator<SliceDefinition> getSlices() {
        return this.sliceDefs.values().iterator();
    }

    public Iterator<RuleCategory> getRuleCategories() {
        return this.ruleCategoryDefs.values().iterator();
    }

    public Iterator<RuleDefinition> getRuleDefinitions() {
        return this.ruleDefs.values().iterator();
    }

    public Iterator<ComplexTypeDefinition> getComplexTypes() {
        return this.complexTypeDefs.values().iterator();
    }

    public Iterator<DSDefinitionModule> getDSDefinitionModules() {
        return this.definitionModuleDefs.values().iterator();
    }

    public int getDSDefinitionModulesCount() {
        return this.definitionModuleDefs.size();
    }

    public Iterator<ExtendedReferenceTypeDefinition> getExtendedReferenceTypes() {
        return this.extendedReferenceTypeDefs.values().iterator();
    }

    @Override
    public DmcNamedObjectIF findNamedObjectMayClash(DmcObject object, DmcObjectName name, DmcNameClashResolverIF resolver, DmcAttributeInfo ai) throws DmcValueException {
        DmcNamedObjectIF rc = null;
        DotName dn = null;
        try {
            dn = new DotName(name.getNameString() + "." + ai.type);
            if (dn.getNameString().equals("ClassDefinition.ClassDefinition")) {
                return MetaSchema._ClassDefinition;
            }
            ArrayList<DmsDefinition> defs = this.clashMAP.get(dn);
            if (defs == null) {
                rc = this.globallyUniqueMAP.get(dn);
            } else if (defs.size() == 1) {
                rc = defs.get(0);
            } else {
                DmcNameClashObjectSet<DmsDefinition> nce = new DmcNameClashObjectSet<DmsDefinition>(defs);
                rc = resolver.resolveClash(object, ai, nce);
            }
        }
        catch (DmcValueException e) {
            e.printStackTrace();
        }
        return rc;
    }

    @Override
    public DmcNamedObjectIF resolveClash(DmcObject obj, DmcAttributeInfo ai, DmcNameClashObjectSet<?> ncos) throws DmcValueException {
        DmcNamedObjectIF rc = null;
        Iterator<DmcNamedObjectIF> matches = ncos.getMatches();
        DebugInfo.debug("\nResolving " + ai.name + " in:\n\n" + obj.toOIF() + "\n");
        obj.getConstructionClassInfo().getAttributeInfo(ai.name);
        if (obj instanceof DmsDefinitionDMO) {
            DmsDefinitionDMO defObj = (DmsDefinitionDMO)obj;
            while (matches.hasNext()) {
                DmcNamedObjectIF matchDef;
                DmcNamedObjectIF objif = matches.next();
                DebugInfo.debug(objif.toString());
                if (objif instanceof DmsDefinitionDMO) {
                    matchDef = (DmsDefinitionDMO)objif;
                    if (!defObj.getDefinedIn().getObjectName().getNameString().equals(((DmsDefinitionDMO)matchDef).getDefinedIn().getObjectName().getNameString())) continue;
                    rc = matchDef;
                    break;
                }
                if (!(objif instanceof DmsDefinition)) continue;
                matchDef = (DmsDefinition)objif;
                if (!defObj.getDefinedIn().getObjectName().getNameString().equals(((SchemaDefinitionDMW)((DSDefinition)matchDef).getDefinedIn()).getName().getNameString())) continue;
                rc = matchDef;
                break;
            }
        }
        return rc;
    }

    @Override
    public DmcObject findUniqueObject(DmcObjectName name) {
        return null;
    }
}

