/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms;

import java.net.URL;
import java.net.URLClassLoader;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcObjectName;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.AttributeDefinition;
import org.dmd.dms.ClassDefinition;
import org.dmd.dms.ComplexTypeDefinition;
import org.dmd.dms.MetaSchemaAG;
import org.dmd.dms.generated.dmo.MetaDMSAG;
import org.dmd.dms.generated.dmo.TypeDefinitionDMO;
import org.dmd.dms.generated.dmw.SchemaDefinitionDMW;
import org.dmd.dms.generated.dmw.TypeDefinitionDMW;
import org.dmd.dms.generated.enums.WrapperTypeEnum;
import org.dmd.util.exceptions.DebugInfo;

public class TypeDefinition
extends TypeDefinitionDMW {
    Class<?> attributeClass;
    Class<?> attributeClassSV;
    Class<?> attributeClassMV;
    Class<?> attributeClassMAP;
    Class<?> attributeClassSET;
    Class<?> nameValueClass;
    Class<?> wrapperClass;
    String auxHolderImport;
    String auxHolderClass;
    ComplexTypeDefinition complexType;

    public TypeDefinition() {
        super(new TypeDefinitionDMO(), MetaSchemaAG._TypeDefinition);
    }

    public TypeDefinition(ComplexTypeDefinition ctd) {
        this.complexType = ctd;
    }

    public TypeDefinition(TypeDefinitionDMO obj) {
        super(obj);
    }

    public ComplexTypeDefinition getComplexType() {
        return this.complexType;
    }

    protected TypeDefinition(String mn, Class<?> c) throws DmcValueException {
        super(mn);
        this.attributeClass = c;
        this.attributeClassSV = null;
        this.attributeClassMV = null;
        this.attributeClassMAP = null;
        this.attributeClassSET = null;
    }

    protected TypeDefinition(String mn, Class<?> c, Class<?> w) throws DmcValueException {
        super(mn);
        this.attributeClass = c;
        this.wrapperClass = w;
        this.attributeClassSV = null;
        this.attributeClassMV = null;
        this.attributeClassMAP = null;
        this.attributeClassSET = null;
    }

    public void setAuxHolderImport(String c) {
        this.auxHolderImport = c;
        int lastDot = c.lastIndexOf(".");
        this.auxHolderClass = c.substring(lastDot + 1);
    }

    public String getAuxHolderImport() {
        return this.auxHolderImport;
    }

    public String getAuxHolderClass() {
        return this.auxHolderClass;
    }

    public DmcObjectName getNameValue() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        DmcObjectName rc = null;
        if (this.getNameAttributeDef() == null) {
            throw new IllegalStateException("The " + this.getName() + " type does not have a designated name attribute definition!");
        }
        if (this.nameValueClass == null) {
            this.nameValueClass = Class.forName(this.getPrimitiveType());
            rc = (DmcObjectName)this.nameValueClass.newInstance();
        }
        return rc;
    }

    public DmcAttribute<?> getAttributeHolder(DmcAttributeInfo ai) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        DmcAttribute rc = null;
        try {
            switch (ai.valueType) {
                case SINGLE: {
                    if (this.attributeClassSV == null) {
                        this.attributeClassSV = Class.forName(this.getTypeName("SV"));
                    }
                    rc = (DmcAttribute)this.attributeClassSV.newInstance();
                    break;
                }
                case MULTI: {
                    if (this.attributeClassMV == null) {
                        this.attributeClassMV = Class.forName(this.getTypeName("MV"));
                    }
                    rc = (DmcAttribute)this.attributeClassMV.newInstance();
                    break;
                }
                case HASHMAPPED: 
                case TREEMAPPED: {
                    if (this.attributeClassMAP == null) {
                        this.attributeClassMAP = Class.forName(this.getTypeName("MAP"));
                    }
                    rc = (DmcAttribute)this.attributeClassMAP.newInstance();
                    break;
                }
                case HASHSET: 
                case TREESET: {
                    if (this.attributeClassSET == null) {
                        this.attributeClassSET = Class.forName(this.getTypeName("SET"));
                    }
                    rc = (DmcAttribute)this.attributeClassSET.newInstance();
                }
            }
        }
        catch (ClassNotFoundException e) {
            URL[] urls;
            DebugInfo.debug("Class not found while trying to get holder for: " + ai.toString());
            DebugInfo.debug(System.getProperty("java.class.path"));
            ClassLoader cl = ClassLoader.getSystemClassLoader();
            for (URL url : urls = ((URLClassLoader)cl).getURLs()) {
                DebugInfo.debug(url.getFile());
            }
            throw e;
        }
        if (rc == null) {
            throw new IllegalStateException("Could not instantiate holder for attribute: " + ai.toString());
        }
        rc.setAttributeInfo(ai);
        return rc;
    }

    String getTypeName(String suffix) {
        String tn = ((SchemaDefinitionDMW)this.getDefinedIn()).getSchemaPackage() + ".generated.types.DmcType" + this.getName().getNameString() + suffix;
        if (this.getIsExtendedRefType().booleanValue()) {
            return tn;
        }
        if (this.getIsRefType().booleanValue() && !this.getName().getNameString().endsWith("REF")) {
            tn = ((SchemaDefinitionDMW)this.getDefinedIn()).getSchemaPackage() + ".generated.types.DmcType" + this.getName().getNameString() + "REF" + suffix;
        }
        if (this.getIsEnumType().booleanValue()) {
            tn = ((SchemaDefinitionDMW)this.getDefinedIn()).getSchemaPackage() + ".generated.types.DmcType" + this.getEnumName() + suffix;
        }
        return tn;
    }

    public String getTypeImport(AttributeDefinition ad) {
        String rc = null;
        switch (ad.getValueType()) {
            case SINGLE: {
                rc = this.getTypeName("SV");
                break;
            }
            case MULTI: {
                rc = this.getTypeName("MV");
                break;
            }
            case HASHMAPPED: 
            case TREEMAPPED: {
                rc = this.getTypeName("MAP");
                break;
            }
            case HASHSET: 
            case TREESET: {
                rc = this.getTypeName("SET");
            }
        }
        return rc;
    }

    public String getContainerType(AttributeDefinition ad) {
        String tmp = null;
        switch (ad.getValueType()) {
            case SINGLE: {
                tmp = this.getTypeName("SV");
                break;
            }
            case MULTI: {
                tmp = this.getTypeName("MV");
                break;
            }
            case HASHMAPPED: 
            case TREEMAPPED: {
                tmp = this.getTypeName("MAP");
                break;
            }
            case HASHSET: 
            case TREESET: {
                tmp = this.getTypeName("SET");
            }
        }
        int lastDot = tmp.lastIndexOf(".");
        return tmp.substring(lastDot + 1);
    }

    public void adjustJavaClass() {
        ClassDefinition cd;
        block10: {
            cd = this.getOriginalClass();
            String genPackage = cd.getDMWPackage();
            if (cd.getUseWrapperType() == WrapperTypeEnum.BASE) {
                try {
                    cd.setJavaClass(genPackage + ".generated.dmw." + cd.getName() + "DMW");
                }
                catch (DmcValueException e) {
                    e.printStackTrace();
                }
            } else if (cd.getUseWrapperType() == WrapperTypeEnum.EXTENDED) {
                try {
                    if (((SchemaDefinitionDMW)cd.getDefinedIn()).getName().getNameString().equals(MetaDMSAG.instance().getSchemaName())) {
                        cd.setJavaClass(genPackage + "." + cd.getName());
                        break block10;
                    }
                    if (cd.getSubpackage() == null) {
                        cd.setJavaClass(genPackage + ".extended." + cd.getName());
                        break block10;
                    }
                    cd.setJavaClass(genPackage + ".extended." + cd.getSubpackage() + "." + cd.getName());
                }
                catch (DmcValueException e) {
                    e.printStackTrace();
                }
            } else {
                return;
            }
        }
        this.setAuxHolderImport(cd.getJavaClass());
    }
}

