/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.doc.web;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.TreeMap;
import org.dmd.dmc.DmcObject;
import org.dmd.dmc.types.DefinitionName;
import org.dmd.dms.ActionDefinition;
import org.dmd.dms.AttributeDefinition;
import org.dmd.dms.ClassDefinition;
import org.dmd.dms.RuleDefinition;
import org.dmd.dms.doc.web.Converter;
import org.dmd.dms.doc.web.TypeFormatter;
import org.dmd.dms.generated.dmo.RuleDataDMO;
import org.dmd.dms.generated.dmw.SchemaDefinitionDMW;
import org.dmd.dmw.DmwWrapper;
import org.dmd.util.exceptions.DebugInfo;

public class AttributeFormatter {
    public static void dumpDetails(BufferedWriter out, AttributeDefinition ad) throws IOException {
        out.write("<!-- " + DebugInfo.getWhereWeAreNow() + " -->\n");
        AttributeFormatter.attributeName(out, ad);
        AttributeFormatter.attributeType(out, ad);
        AttributeFormatter.description(out, ad);
        AttributeFormatter.usage(out, ad);
    }

    static void attributeName(BufferedWriter out, AttributeDefinition ad) throws IOException {
        out.write("    <tr> <td class=\"className\" colspan=\"3\"> <a name=\"" + ad.getName() + "\"> " + ad.getName() + " </a> </td></tr>\n");
    }

    public static String getValueType(AttributeDefinition ad) {
        StringBuffer vt = new StringBuffer();
        switch (ad.getDataType()) {
            case UNKNOWN: {
                vt.append("U ");
                break;
            }
            case PERSISTENT: {
                vt.append("P ");
                break;
            }
            case NONPERSISTENT: {
                vt.append("N ");
                break;
            }
            case TRANSIENT: {
                vt.append("T ");
            }
        }
        switch (ad.getValueType()) {
            case SINGLE: {
                vt.append("SV");
                break;
            }
            case MULTI: {
                if (ad.getIndexSize() == null) {
                    vt.append("MV");
                    break;
                }
                vt.append("MV[" + ad.getIndexSize() + "]");
                break;
            }
            case TREEMAPPED: {
                vt.append("TM");
                break;
            }
            case HASHMAPPED: {
                vt.append("HM");
                break;
            }
            case TREESET: {
                vt.append("TS");
                break;
            }
            case HASHSET: {
                vt.append("HS");
            }
        }
        return vt.toString();
    }

    static void attributeType(BufferedWriter out, AttributeDefinition ad) throws IOException {
        String vt = AttributeFormatter.getValueType(ad);
        String schema = ((SchemaDefinitionDMW)ad.getType().getDefinedIn()).getName().getNameString();
        String type = TypeFormatter.getTypeName(ad.getType());
        String designated = "";
        if (ad.getDesignatedNameAttribute().booleanValue()) {
            designated = "(designated naming attribute)";
        }
        out.write("    <tr>\n");
        out.write("      <td class=\"spacer\"> </td>\n");
        out.write("      <td colspan=\"2\"> <div class=\"valueType\"> " + vt + " </div> ");
        out.write("<div class=\"attrType\"> <a href=\"" + schema + ".html#" + type + "\">" + type + "</a> </div> " + designated + "\n");
        out.write("      </td>\n");
        out.write("    </tr>\n\n");
    }

    static void description(BufferedWriter out, AttributeDefinition ad) throws IOException {
        if (ad.getDescriptionSize() > 0) {
            ArrayList<DmcObject> referring = ad.getDMO().getReferringObjects();
            out.write("    <tr>\n");
            out.write("      <td class=\"spacer\"> </td>\n");
            out.write("      <td class=\"label\">Description</td>\n");
            out.write("      <td>\n");
            if (ad.getDescription() != null) {
                out.write("      " + Converter.convert(ad.getDescriptionWithNewlines()) + "\n");
            }
            out.write("      </td>\n");
            out.write("    </tr>\n\n");
            if (referring != null) {
                StringBuilder sb = new StringBuilder();
                for (DmcObject obj : referring) {
                    if (!(obj instanceof RuleDataDMO)) continue;
                    RuleDataDMO rd = (RuleDataDMO)obj;
                    sb.append("<tr> <td class=\"spacer\"> <td> </td> </td> <td class=\"attributeRule\">\n");
                    sb.append("<a class=\"blackText\" href=\"" + rd.getDefinedIn().getObjectName() + ".html#" + rd.getRuleName() + "\"> " + rd.getRuleTitle() + " </a>");
                    sb.append("</td> </tr>\n\n");
                }
                if (sb.length() > 0) {
                    out.write(sb.toString());
                }
            }
        }
    }

    static void usage(BufferedWriter out, AttributeDefinition ad) throws IOException {
        ArrayList<DmwWrapper> referring = ad.getReferringObjects();
        if (referring != null && referring.size() > 1) {
            TreeMap<DefinitionName, ClassDefinition> classes = new TreeMap<DefinitionName, ClassDefinition>();
            TreeMap<DefinitionName, RuleDefinition> rules = new TreeMap<DefinitionName, RuleDefinition>();
            TreeMap<DefinitionName, ActionDefinition> actions = new TreeMap<DefinitionName, ActionDefinition>();
            out.write("    <tr>\n");
            out.write("      <td class=\"spacer\"> </td>\n");
            out.write("      <td class=\"label\">Used in:</td>\n");
            out.write("      <td>\n");
            for (DmwWrapper wrapper : referring) {
                if (wrapper instanceof ClassDefinition) {
                    ClassDefinition cd = (ClassDefinition)wrapper;
                    classes.put(cd.getName(), cd);
                    continue;
                }
                if (!(wrapper instanceof ActionDefinition)) continue;
                ActionDefinition actd = (ActionDefinition)wrapper;
                actions.put(actd.getName(), actd);
            }
            out.write(AttributeFormatter.formatUsage(classes, rules, actions));
            out.write("      </td>\n");
            out.write("    </tr>\n\n");
        }
    }

    static String formatUsage(TreeMap<DefinitionName, ClassDefinition> cds, TreeMap<DefinitionName, RuleDefinition> rds, TreeMap<DefinitionName, ActionDefinition> ads) {
        String ref;
        StringBuffer sb = new StringBuffer();
        sb.append("        <table>\n");
        int count = 0;
        if (cds.size() > 0) {
            count = 0;
            for (ClassDefinition classDefinition : cds.values()) {
                if (count % 3 == 0) {
                    if (count > 3) {
                        sb.append("        </tr>\n");
                    }
                    sb.append("        <tr>\n");
                }
                ref = "<a href=\"" + ((SchemaDefinitionDMW)classDefinition.getDefinedIn()).getName() + ".html#" + classDefinition.getName() + "\">" + ((SchemaDefinitionDMW)classDefinition.getDefinedIn()).getName() + "</a>";
                sb.append("          <td> " + classDefinition.getName().getNameString() + " (" + ref + ") </td>\n");
                ++count;
            }
            sb.append("        </tr>\n");
        }
        if (rds.size() > 0) {
            count = 0;
            for (RuleDefinition ruleDefinition : rds.values()) {
                if (count % 3 == 0) {
                    if (count > 3) {
                        sb.append("        </tr>\n");
                    }
                    sb.append("        <tr>\n");
                }
                ref = "<a href=\"" + ((SchemaDefinitionDMW)ruleDefinition.getDefinedIn()).getName() + ".html#" + ruleDefinition.getName() + "\">" + ((SchemaDefinitionDMW)ruleDefinition.getDefinedIn()).getName() + "</a>";
                sb.append("          <td> " + ruleDefinition.getName().getNameString() + " (" + ref + ") </td>\n");
                ++count;
            }
            sb.append("        </tr>\n");
        }
        if (ads.size() > 0) {
            count = 0;
            for (ActionDefinition actionDefinition : ads.values()) {
                if (count % 3 == 0) {
                    if (count > 3) {
                        sb.append("      </tr>\n");
                    }
                    sb.append("      <tr>\n");
                }
                ref = "<a href=\"" + ((SchemaDefinitionDMW)actionDefinition.getDefinedIn()).getName() + ".html#" + actionDefinition.getName() + "\">" + ((SchemaDefinitionDMW)actionDefinition.getDefinedIn()).getName() + "</a>";
                sb.append("          <td> " + actionDefinition.getName().getNameString() + " (" + ref + ") </td>\n");
                ++count;
            }
            sb.append("      </tr>\n");
        }
        sb.append("        </table>\n");
        return sb.toString();
    }
}

