/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.doc.web;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.DefinitionName;
import org.dmd.dms.AttributeDefinition;
import org.dmd.dms.ComplexTypeDefinition;
import org.dmd.dms.SchemaManager;
import org.dmd.dms.TypeDefinition;
import org.dmd.dms.doc.web.Converter;
import org.dmd.dms.doc.web.TypeFormatter;
import org.dmd.dms.generated.dmw.SchemaDefinitionDMW;
import org.dmd.dms.generated.types.Field;
import org.dmd.dmw.DmwWrapper;

public class ComplexTypeFormatter {
    public static void dumpDetails(BufferedWriter out, SchemaManager schema, ComplexTypeDefinition td) throws IOException {
        ComplexTypeFormatter.typeName(out, td);
        ComplexTypeFormatter.description(out, td);
        ComplexTypeFormatter.fields(out, schema, td);
        ComplexTypeFormatter.usage(out, schema, td);
    }

    static void typeName(BufferedWriter out, ComplexTypeDefinition td) throws IOException {
        out.write("    <tr> <td class=\"typeName\" colspan=\"5\"> <a name=\"" + td.getName() + "\"> " + td.getName() + " </a> </td></tr>\n");
    }

    static void description(BufferedWriter out, ComplexTypeDefinition td) throws IOException {
        if (td.getDescription() != null) {
            out.write("    <tr>\n");
            out.write("      <td class=\"spacer\"> </td>\n");
            out.write("      <td class=\"label\">Description</td>\n");
            out.write("      <td colspan=\"4\"> " + Converter.convert(td.getDescriptionWithNewlines()) + " </td>\n");
            out.write("    </tr>\n\n");
        }
    }

    static void fields(BufferedWriter out, SchemaManager sm, ComplexTypeDefinition td) throws IOException {
        out.write("    <tr>\n");
        out.write("      <td class=\"spacer\"> </td>\n");
        out.write("      <td class=\"label\" colspan=\"3\">Field Separator: \n");
        if (td.getFieldSeparator() == null) {
            out.write("SPACE");
        } else {
            out.write("<strong> " + td.getFieldSeparator() + "</strong>");
        }
        out.write("</td>\n");
        out.write("    </tr>\n\n");
        Iterator<Field> fields = td.getField();
        int fieldNum = 1;
        if (fields != null) {
            while (fields.hasNext()) {
                Field field = fields.next();
                out.write("    <tr>\n");
                out.write("      <td class=\"spacer\"> </td>\n");
                out.write("      <td class=\"label\"> Field " + fieldNum + "</td>\n");
                out.write("      <td> " + field.getName() + " </td>\n");
                TypeDefinition fieldType = sm.tdef(field.getType().getObjectName().getNameString());
                if (fieldType == null) {
                    try {
                        fieldType = sm.findInternalType(new DefinitionName(field.getType().getObjectName().getNameString()));
                    }
                    catch (DmcValueException e) {
                        e.printStackTrace();
                    }
                }
                String type = TypeFormatter.getTypeName(fieldType);
                String schema = ((SchemaDefinitionDMW)fieldType.getDefinedIn()).getName().getNameString();
                out.write("      <td class=\"attrType\"> <a href=\"" + schema + ".html#" + type + "\">" + type + "</a> </td>\n");
                out.write("      <td> " + field.getDescription() + " </td>\n");
                out.write("    </tr>\n\n");
                ++fieldNum;
            }
        }
    }

    static void usage(BufferedWriter out, SchemaManager schema, ComplexTypeDefinition td) throws IOException {
        TypeDefinition internalType = schema.findInternalType(td.getName());
        ArrayList<DmwWrapper> referring = internalType.getReferringObjects();
        if (referring != null && referring.size() > 1) {
            TreeMap<DefinitionName, AttributeDefinition> attributes = new TreeMap<DefinitionName, AttributeDefinition>();
            for (DmwWrapper wrapper : referring) {
                if (!(wrapper instanceof AttributeDefinition)) continue;
                AttributeDefinition ad = (AttributeDefinition)wrapper;
                attributes.put(ad.getName(), ad);
            }
            if (attributes.size() > 0) {
                out.write("    <tr>\n");
                out.write("      <td class=\"spacer\"> </td>\n");
                out.write("      <td class=\"label\">Used in:</td>\n");
                out.write("      <td colspan =\"3\">\n");
                out.write(ComplexTypeFormatter.formatUsage(attributes));
                out.write("      </td>\n");
                out.write("    </tr>\n\n");
            }
        }
    }

    static String formatUsage(TreeMap<DefinitionName, AttributeDefinition> ads) {
        StringBuffer sb = new StringBuffer();
        sb.append("<table>\n");
        int count = 0;
        for (AttributeDefinition ad : ads.values()) {
            if (count % 3 == 0) {
                if (count > 3) {
                    sb.append("</tr>\n");
                }
                sb.append("  <tr>\n");
            }
            String ref = "<a href=\"" + ((SchemaDefinitionDMW)ad.getDefinedIn()).getName() + ".html#" + ad.getName() + "\">" + ((SchemaDefinitionDMW)ad.getDefinedIn()).getName() + "</a>";
            sb.append("    <td> " + ad.getName().getNameString() + " (" + ref + ") </td>\n");
            ++count;
        }
        sb.append("</tr>\n");
        sb.append("</table>\n");
        return sb.toString();
    }

    public static String getTypeName(TypeDefinition td) {
        String type = td.getName().getNameString();
        if (td.getIsRefType().booleanValue() && td.getOriginalClass() != null) {
            type = td.getOriginalClass().getName().getNameString();
        }
        if (td.getIsEnumType().booleanValue()) {
            type = td.getEnumName();
        }
        return type;
    }
}

