/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.doc.web;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.TreeMap;
import org.apache.commons.io.FileUtils;
import org.dmd.dmc.DmcNameClashException;
import org.dmd.dmc.DmcOmni;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.SchemaDefinition;
import org.dmd.dms.SchemaManager;
import org.dmd.dms.doc.web.SchemaPage;
import org.dmd.dms.doc.web.Summarizer;
import org.dmd.util.exceptions.DebugInfo;
import org.dmd.util.exceptions.ResultException;
import org.dmd.util.formatting.PrintfFormat;

public class DmsHtmlDocGenerator {
    TreeMap<Integer, SchemaDefinition> allSchemasByID = new TreeMap();
    TreeMap<String, SchemaDefinition> allSchemasByName = new TreeMap();
    int longest = 0;

    public DmsHtmlDocGenerator() {
        DmcOmni.instance().setTrackSchemaReferences(true);
        DmcOmni.instance().backRefTracking(true);
    }

    public void addReadSchemas(SchemaManager sm) throws IOException {
        Iterator<SchemaDefinition> sdit = sm.getSchemas();
        if (sdit != null) {
            while (sdit.hasNext()) {
                SchemaDefinition sd = sdit.next();
                this.allSchemasByID.put(sd.getSchemaBaseID(), sd);
                this.allSchemasByName.put(sd.getName().getNameString(), sd);
                if (sd.getName().getNameString().length() <= this.longest) continue;
                this.longest = sd.getName().getNameString().length();
            }
        }
    }

    public void dumpDocumentation(String outdir) throws IOException, DmcNameClashException {
        DebugInfo.debug(outdir);
        this.initDirs(outdir);
        URL url = this.getClass().getResource("dmsstyle.css");
        DebugInfo.debug("url: " + url.getFile());
        FileUtils.copyURLToFile((URL)url, (File)new File(outdir + File.separator + "dmsstyle.css"));
        try {
            SchemaManager manager = new SchemaManager();
            for (SchemaDefinition sd : this.allSchemasByID.values()) {
                if (manager.isSchema(sd.getName().getNameString()) != null) continue;
                manager.manageSchemaInternal(sd, false);
            }
            Summarizer summarizer = new Summarizer(manager, outdir);
            summarizer.dumpTextSummary();
            summarizer.dumpSchemaSummaryPage(outdir);
            PrintfFormat format = new PrintfFormat("%-" + this.longest + "s");
            for (SchemaDefinition sd : this.allSchemasByID.values()) {
                int end = sd.getSchemaBaseID() + sd.getSchemaIDRange();
                System.out.println(format.sprintf(sd.getName()) + " " + sd.getSchemaBaseID() + " - " + end);
                SchemaPage.dumpSchemaPage(outdir, manager, sd, summarizer);
            }
        }
        catch (ResultException e) {
            e.printStackTrace();
        }
        catch (DmcValueException e) {
            e.printStackTrace();
        }
    }

    void initDirs(String outdir) {
        File dmsdocdir = new File(outdir);
        if (!dmsdocdir.exists()) {
            dmsdocdir.mkdir();
        }
    }
}

