/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.doc.web;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import org.dmd.dmc.DmcNameClashException;
import org.dmd.dmc.util.DmcUncheckedObject;
import org.dmd.dms.AttributeDefinition;
import org.dmd.dms.ClassDefinition;
import org.dmd.dms.ComplexTypeDefinition;
import org.dmd.dms.DmsDefinition;
import org.dmd.dms.EnumDefinition;
import org.dmd.dms.ExtendedReferenceTypeDefinition;
import org.dmd.dms.RuleCategory;
import org.dmd.dms.RuleDefinition;
import org.dmd.dms.SchemaDefinition;
import org.dmd.dms.SchemaManager;
import org.dmd.dms.SliceDefinition;
import org.dmd.dms.TypeDefinition;
import org.dmd.dms.doc.web.AttributeFormatter;
import org.dmd.dms.doc.web.ClassFormatter;
import org.dmd.dms.doc.web.ComplexTypeFormatter;
import org.dmd.dms.doc.web.Converter;
import org.dmd.dms.doc.web.EnumFormatter;
import org.dmd.dms.doc.web.ExtendedReferenceTypeFormatter;
import org.dmd.dms.doc.web.RuleInstanceFormatter;
import org.dmd.dms.doc.web.StandardParts;
import org.dmd.dms.doc.web.Summarizer;
import org.dmd.dms.doc.web.TypeFormatter;
import org.dmd.dms.generated.dmo.MetaDMSAG;
import org.dmd.dms.generated.dmw.AttributeDefinitionDMW;
import org.dmd.dms.generated.dmw.ClassDefinitionDMW;
import org.dmd.dms.generated.dmw.ComplexTypeDefinitionDMW;
import org.dmd.dms.generated.dmw.EnumDefinitionDMW;
import org.dmd.dms.generated.dmw.ExtendedReferenceTypeDefinitionDMW;
import org.dmd.dms.generated.dmw.RuleCategoryDMW;
import org.dmd.dms.generated.dmw.RuleDefinitionDMW;
import org.dmd.dms.generated.dmw.SliceDefinitionDMW;
import org.dmd.dms.generated.dmw.TypeDefinitionDMW;
import org.dmd.util.exceptions.DebugInfo;

public class SchemaPage {
    static TreeMap<String, ClassDefinition> classes;
    static TreeMap<String, AttributeDefinition> attributes;
    static TreeMap<String, TypeDefinition> types;
    static TreeMap<String, ComplexTypeDefinition> complexTypes;
    static TreeMap<String, ExtendedReferenceTypeDefinition> extendedRefTypes;
    static TreeMap<String, EnumDefinition> enums;
    static TreeMap<String, SliceDefinition> slices;
    static TreeMap<String, RuleCategory> ruleCategories;
    static TreeMap<String, RuleDefinition> ruleDefinitions;
    static TreeMap<String, DmcUncheckedObject> parsedRules;

    public static void dumpSchemaPage(String outdir, SchemaManager sm, SchemaDefinition sd, Summarizer summarizer) throws IOException, DmcNameClashException {
        String ofn = outdir + File.separator + sd.getName() + ".html";
        BufferedWriter out = new BufferedWriter(new FileWriter(ofn));
        SchemaPage.initTrees(sd);
        StandardParts.writePageHeader(out, "The " + sd.getName() + " Schema");
        StandardParts.writeContentStart(out);
        SchemaPage.writeSchemaSummary(out, sm, sd);
        SchemaPage.writeClasses(out, sm);
        SchemaPage.writeAttributes(out);
        SchemaPage.writeTypes(out);
        SchemaPage.writeComplexTypes(out, sm);
        SchemaPage.writeExtendedReferenceTypes(out, sm);
        SchemaPage.writeEnums(out);
        RuleInstanceFormatter.dumpRuleInstanceDetails(out, sm, sd);
        StandardParts.writeContentEnd(out);
        out.write(summarizer.getSideBar());
        StandardParts.writePageFooter(out);
        out.close();
    }

    static void initTrees(SchemaDefinition sd) {
        Iterator<DmcUncheckedObject> parsed;
        classes = new TreeMap();
        attributes = new TreeMap();
        types = new TreeMap();
        complexTypes = new TreeMap();
        extendedRefTypes = new TreeMap();
        enums = new TreeMap();
        slices = new TreeMap();
        ruleCategories = new TreeMap();
        ruleDefinitions = new TreeMap();
        parsedRules = new TreeMap();
        for (DmsDefinition def : sd.getClassDefList()) {
            classes.put(((ClassDefinitionDMW)def).getObjectName().getNameString(), (ClassDefinition)def);
        }
        for (DmsDefinition def : sd.getAttributeDefList()) {
            attributes.put(((AttributeDefinitionDMW)def).getObjectName().getNameString(), (AttributeDefinition)def);
        }
        for (DmsDefinition def : sd.getTypeDefList()) {
            types.put(((TypeDefinitionDMW)def).getObjectName().getNameString(), (TypeDefinition)def);
        }
        for (DmsDefinition def : sd.getComplexTypeDefList()) {
            complexTypes.put(((ComplexTypeDefinitionDMW)def).getObjectName().getNameString(), (ComplexTypeDefinition)def);
        }
        for (DmsDefinition def : sd.getExtendedReferenceTypeDefList()) {
            extendedRefTypes.put(((ExtendedReferenceTypeDefinitionDMW)def).getObjectName().getNameString(), (ExtendedReferenceTypeDefinition)def);
        }
        for (DmsDefinition def : sd.getEnumDefList()) {
            enums.put(((EnumDefinitionDMW)def).getObjectName().getNameString(), (EnumDefinition)def);
        }
        if (sd.getSliceDefListSize() > 0) {
            for (DmsDefinition def : sd.getSliceDefList()) {
                slices.put(((SliceDefinitionDMW)def).getObjectName().getNameString(), (SliceDefinition)def);
            }
        }
        if (sd.getRuleCategoryListSize() > 0) {
            for (DmsDefinition def : sd.getRuleCategoryList()) {
                ruleCategories.put(((RuleCategoryDMW)def).getObjectName().getNameString(), (RuleCategory)def);
            }
        }
        if (sd.getRuleDefinitionListSize() > 0) {
            for (DmsDefinition def : sd.getRuleDefinitionList()) {
                ruleDefinitions.put(((RuleDefinitionDMW)def).getObjectName().getNameString(), (RuleDefinition)def);
            }
        }
        if ((parsed = sd.getParsedRules()) != null) {
            while (parsed.hasNext()) {
                DmcUncheckedObject uco = parsed.next();
                String ruleName = uco.getSV(MetaDMSAG.__ruleName.name);
                parsedRules.put(ruleName, uco);
            }
        }
    }

    static void writeHierarchy(BufferedWriter out, SchemaManager sm, SchemaDefinition sd) throws IOException {
        ArrayList<ClassDefinition> ofInterest = new ArrayList<ClassDefinition>();
        for (ClassDefinition cd : sm.getHierarchicObjects().values()) {
            if (!SchemaPage.wantThis(sd, cd)) continue;
            ofInterest.add(cd);
        }
        if (ofInterest.size() > 0) {
            out.write("<!-- " + DebugInfo.getWhereWeAreNow() + " -->\n\n");
            out.write("<div class=\"hierarchy\">\n\n");
            out.write("<h2> Instance Hierarchy </h2>\n\n");
            for (ClassDefinition cd : ofInterest) {
                SchemaPage.dumpHierarchy(out, cd, 0);
            }
            out.write("</div> <!-- hierarchy -->\n\n<p />\n");
        }
    }

    static void dumpHierarchy(BufferedWriter out, ClassDefinition cd, int depth) throws IOException {
        out.write("        <div class=\"hier" + depth + "\"> <a class=\"deflink\" href=\"#" + cd.getName() + "\"> " + cd.getName() + " </a> </div>\n\n");
        if (cd.getAllowedSubcomps() == null) {
            return;
        }
        for (ClassDefinition subcomp : cd.getAllowedSubcomps().values()) {
            SchemaPage.dumpHierarchy(out, subcomp, depth + 1);
        }
    }

    static boolean wantThis(SchemaDefinition sd, ClassDefinition cd) {
        if (cd.getDefinedIn() == sd) {
            return true;
        }
        if (cd.getAllowedSubcomps() == null) {
            return false;
        }
        for (ClassDefinition subcomp : cd.getAllowedSubcomps().values()) {
            if (!SchemaPage.wantThis(sd, subcomp)) continue;
            return true;
        }
        return false;
    }

    static void writeClasses(BufferedWriter out, SchemaManager sm) throws IOException {
        if (classes.size() == 0) {
            return;
        }
        out.write("<!-- " + DebugInfo.getWhereWeAreNow() + " -->\n\n");
        out.write("<div class=\"classDetails\">\n\n");
        out.write("<h2> Class Details </h2>\n\n");
        for (ClassDefinition cd : classes.values()) {
            ClassFormatter.dumpDetails(out, sm, cd);
        }
        out.write("</div> <!-- classDetails -->\n\n");
    }

    static void writeAttributes(BufferedWriter out) throws IOException {
        if (attributes.size() == 0) {
            return;
        }
        out.write("<!-- " + DebugInfo.getWhereWeAreNow() + " -->\n\n");
        out.write("<div class=\"attributeDetails\">\n\n");
        out.write("<h2> Attribute Details </h2>\n\n");
        out.write("  <table>\n\n");
        for (AttributeDefinition ad : attributes.values()) {
            AttributeFormatter.dumpDetails(out, ad);
        }
        out.write("  </table>\n\n");
        out.write("</div> <!-- attributeDetails -->\n\n");
    }

    static void writeTypes(BufferedWriter out) throws IOException {
        if (types.size() == 0) {
            return;
        }
        out.write("<!-- " + DebugInfo.getWhereWeAreNow() + " -->\n\n");
        out.write("<div class=\"typeDetails\">\n\n");
        out.write("<h2> Type Details </h2>\n\n");
        out.write("  <table>\n\n");
        for (TypeDefinition td : types.values()) {
            TypeFormatter.dumpDetails(out, td);
        }
        out.write("  </table>\n\n");
        out.write("</div> <!-- typeDetails -->\n\n");
    }

    static void writeComplexTypes(BufferedWriter out, SchemaManager sm) throws IOException {
        if (complexTypes.size() == 0) {
            return;
        }
        out.write("<!-- " + DebugInfo.getWhereWeAreNow() + " -->\n\n");
        out.write("<div class=\"complexTypeDetails\">\n\n");
        out.write("<h2> Complex Type Details </h2>\n\n");
        out.write("  <table>\n\n");
        for (ComplexTypeDefinition td : complexTypes.values()) {
            ComplexTypeFormatter.dumpDetails(out, sm, td);
        }
        out.write("  </table>\n\n");
        out.write("</div> <!-- typeDetails -->\n\n");
    }

    static void writeExtendedReferenceTypes(BufferedWriter out, SchemaManager sm) throws IOException {
        if (extendedRefTypes.size() == 0) {
            return;
        }
        out.write("<!-- " + DebugInfo.getWhereWeAreNow() + " -->\n\n");
        out.write("<div class=\"extendedReferenceTypeDetails\">\n\n");
        out.write("<h2> Extended Reference Type Details </h2>\n\n");
        out.write("  <table>\n\n");
        for (ExtendedReferenceTypeDefinition td : extendedRefTypes.values()) {
            ExtendedReferenceTypeFormatter.dumpDetails(out, sm, td);
        }
        out.write("  </table>\n\n");
        out.write("</div> <!-- typeDetails -->\n\n");
    }

    static void writeEnums(BufferedWriter out) throws IOException {
        if (enums.size() == 0) {
            return;
        }
        out.write("<!-- " + DebugInfo.getWhereWeAreNow() + " -->\n\n");
        out.write("<div class=\"enumDetails\">\n\n");
        out.write("<h2> Enum Details </h2>\n\n");
        out.write("  <table>\n\n");
        for (EnumDefinition ed : enums.values()) {
            EnumFormatter.dumpDetails(out, ed);
        }
        out.write("  </table>\n\n");
        out.write("</div> <!-- enumDetails -->\n\n");
    }

    static void writeSchemaSummary(BufferedWriter out, SchemaManager sm, SchemaDefinition sd) throws IOException {
        out.write("<!-- " + DebugInfo.getWhereWeAreNow() + " -->\n\n");
        out.write("  <div class=\"schemaName\"> " + sd.getName() + " </div>\n\n");
        SchemaPage.writeDescription(out, sd);
        out.write("  <div class=\"summary\">\n\n");
        SchemaPage.writeClassSummary(out, classes);
        SchemaPage.writeHierarchy(out, sm, sd);
        SchemaPage.writeTypeSummary(out, types);
        SchemaPage.writeComplexTypeSummary(out, complexTypes);
        SchemaPage.writeExtendedRefTypeSummary(out, extendedRefTypes);
        SchemaPage.writeEnumSummary(out, enums);
        SchemaPage.writeSliceSummary(out, slices);
        SchemaPage.writeRuleCategorySummary(out, ruleCategories);
        SchemaPage.writeRuleDefinitionSummary(out, ruleDefinitions);
        SchemaPage.writeRuleInstancesSummary(out, parsedRules);
        out.write("  </div> <!--  summary -->\n\n");
    }

    static void writeDescription(BufferedWriter out, SchemaDefinition sd) throws IOException {
        if (sd.getDescription() != null) {
            out.write("<!-- " + DebugInfo.getWhereWeAreNow() + " -->\n\n");
            out.write("    <div class=\"schemaDescription\">\n");
            out.write("    " + Converter.convert(sd.getDescriptionWithNewlines()) + "</td>\n");
            out.write("    </div>\n\n");
        }
    }

    static void writeClassSummary(BufferedWriter out, TreeMap<String, ClassDefinition> defs) throws IOException {
        if (defs.size() == 0) {
            return;
        }
        out.write("<!-- " + DebugInfo.getWhereWeAreNow() + " -->\n\n");
        out.write("    <div class=\"classList\">\n");
        out.write("    <h2> Classes (" + defs.size() + ")</h2>\n");
        out.write("    <table>\n");
        for (ClassDefinition def : defs.values()) {
            out.write("      <tr>\n");
            out.write("      <td class=\"spacer\"> </td>\n");
            out.write("      <td> <a class=\"deflink\" href=\"#" + def.getName() + "\"> " + def.getName() + " </a></td>\n");
            if (def.getIsNamedBy() != null) {
                if (def.getIsNamedBy().getType().getIsHierarchicName().booleanValue()) {
                    out.write("      <td> " + def.getIsNamedBy().getName() + " (H) </td>\n");
                } else {
                    out.write("      <td> " + def.getIsNamedBy().getName() + " </td>\n");
                }
            }
            out.write("      </tr>\n");
        }
        out.write("    </table>\n");
        out.write("    </div>");
    }

    static void writeTypeSummary(BufferedWriter out, TreeMap<String, TypeDefinition> defs) throws IOException {
        if (defs.size() == 0) {
            return;
        }
        out.write("<!-- " + DebugInfo.getWhereWeAreNow() + " -->\n\n");
        out.write("    <div class=\"typeList\">\n");
        out.write("    <h2>Types (" + defs.size() + ")</h2>\n");
        out.write("    <ul>\n");
        for (TypeDefinition def : defs.values()) {
            if (def.getInternallyGenerated().booleanValue()) continue;
            out.write("      <li> <a class=\"deflink\" href=\"#" + def.getName() + "\"> " + def.getName() + " </a></li>\n");
        }
        out.write("    </ul>\n");
        out.write("    </div>");
    }

    static void writeComplexTypeSummary(BufferedWriter out, TreeMap<String, ComplexTypeDefinition> defs) throws IOException {
        if (defs.size() == 0) {
            return;
        }
        out.write("<!-- " + DebugInfo.getWhereWeAreNow() + " -->\n\n");
        out.write("    <div class=\"complextypeList\">\n");
        out.write("    <h2>Complex Types (" + defs.size() + ")</h2>\n");
        out.write("    <ul>\n");
        for (ComplexTypeDefinition def : defs.values()) {
            out.write("      <li> <a class=\"deflink\" href=\"#" + def.getName() + "\"> " + def.getName() + " </a></li>\n");
        }
        out.write("    </ul>\n");
        out.write("    </div>");
    }

    static void writeExtendedRefTypeSummary(BufferedWriter out, TreeMap<String, ExtendedReferenceTypeDefinition> defs) throws IOException {
        if (defs.size() == 0) {
            return;
        }
        out.write("<!-- " + DebugInfo.getWhereWeAreNow() + " -->\n\n");
        out.write("    <div class=\"extendedreftypeList\">\n");
        out.write("    <h2>Extended Reference Types (" + defs.size() + ")</h2>\n");
        out.write("    <ul>\n");
        for (ExtendedReferenceTypeDefinition def : defs.values()) {
            out.write("      <li> <a class=\"deflink\" href=\"#" + def.getName() + "\"> " + def.getName() + " </a></li>\n");
        }
        out.write("    </ul>\n");
        out.write("    </div>");
    }

    static void writeEnumSummary(BufferedWriter out, TreeMap<String, EnumDefinition> defs) throws IOException {
        if (defs.size() == 0) {
            return;
        }
        out.write("<!-- " + DebugInfo.getWhereWeAreNow() + " -->\n\n");
        out.write("    <div class=\"enumList\">\n");
        out.write("    <h2>Enums (" + defs.size() + ")</h2>\n");
        out.write("    <ul>\n");
        for (EnumDefinition def : defs.values()) {
            out.write("      <li> <a class=\"deflink\" href=\"#" + def.getName() + "\"> " + def.getName() + " </a></li>\n");
        }
        out.write("    </ul>\n");
        out.write("    </div>");
    }

    static void writeSliceSummary(BufferedWriter out, TreeMap<String, SliceDefinition> defs) throws IOException {
        if (defs.size() == 0) {
            return;
        }
        out.write("<!-- " + DebugInfo.getWhereWeAreNow() + " -->\n\n");
        out.write("    <div class=\"sliceList\">\n");
        out.write("    <h2> Slices (" + defs.size() + ")</h2>\n");
        out.write("    <ul>\n");
        for (SliceDefinition def : defs.values()) {
            out.write("      <li> <a class=\"deflink\" href=\"#" + def.getName() + "\"> " + def.getName() + " </a></li>\n");
        }
        out.write("    </ul>\n");
        out.write("    </div>");
    }

    static void writeRuleCategorySummary(BufferedWriter out, TreeMap<String, RuleCategory> defs) throws IOException {
        if (defs.size() == 0) {
            return;
        }
        out.write("<!-- " + DebugInfo.getWhereWeAreNow() + " -->\n\n");
        out.write("    <div class=\"categories\">\n");
        out.write("    <h2> Rule Categories (" + defs.size() + ")</h2>\n");
        out.write("    <ul>\n");
        for (RuleCategory def : defs.values()) {
            out.write("      <li> <a class=\"deflink\" href=\"#" + def.getName() + "\"> " + def.getName() + " </a></li>\n");
        }
        out.write("    </ul>\n");
        out.write("    </div>");
    }

    static void writeRuleDefinitionSummary(BufferedWriter out, TreeMap<String, RuleDefinition> defs) throws IOException {
        if (defs.size() == 0) {
            return;
        }
        out.write("<!-- " + DebugInfo.getWhereWeAreNow() + " -->\n\n");
        out.write("    <div class=\"ruledefs\">\n");
        out.write("    <h2> Rule Definitions (" + defs.size() + ")</h2>\n");
        out.write("    <ul>\n");
        for (RuleDefinition def : defs.values()) {
            out.write("      <li> <a class=\"deflink\" href=\"#" + def.getName() + "Data\"> " + def.getName() + " </a></li>\n");
        }
        out.write("    </ul>\n");
        out.write("    </div>");
    }

    static void writeRuleInstancesSummary(BufferedWriter out, TreeMap<String, DmcUncheckedObject> defs) throws IOException {
        if (defs.size() == 0) {
            return;
        }
        out.write("<!-- " + DebugInfo.getWhereWeAreNow() + " -->\n\n");
        out.write("    <div class=\"ruledefs\">\n");
        out.write("    <h2> Rule Instances (" + defs.size() + ")</h2>\n");
        out.write("    <ul>\n");
        for (DmcUncheckedObject def : defs.values()) {
            String ruleName = def.getSV(MetaDMSAG.__ruleName.name);
            String ruleTitle = def.getSV(MetaDMSAG.__ruleTitle.name);
            out.write("      <li> <a class=\"deflink\" href=\"#" + ruleName + "\"> " + ruleTitle + " </a></li>\n");
        }
        out.write("    </ul>\n");
        out.write("    </div>");
    }
}

