/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.doc.web;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.TreeMap;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcNameClashException;
import org.dmd.dmc.DmcNamedObjectREF;
import org.dmd.dmc.DmcObject;
import org.dmd.dmc.DmcOmni;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.DmcValueExceptionSet;
import org.dmd.dmc.types.DmcTypeNamedObjectREF;
import org.dmd.dms.DmsDefinition;
import org.dmd.dms.SchemaDefinition;
import org.dmd.dms.SchemaManager;
import org.dmd.dms.doc.web.StandardParts;
import org.dmd.dms.generated.dmo.DmsDefinitionDMO;
import org.dmd.dms.generated.dmo.RuleDataDMO;
import org.dmd.dms.generated.dmw.DmsDefinitionDMW;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.util.exceptions.DebugInfo;

public class Summarizer {
    TreeMap<Integer, SchemaDefinition> allSchemasByID = new TreeMap();
    TreeMap<String, SchemaDefinition> allSchemasByName = new TreeMap();
    TreeMap<String, TreeMap<String, DmsDefinition>> definitionsByLetter = new TreeMap();
    String outDir;
    StringBuffer sidebar;
    StringBuffer idSummary;

    public Summarizer(SchemaManager sm, String od) throws DmcNameClashException {
        RuleDataDMO rule;
        Iterator<RuleDataDMO> rules;
        this.outDir = od;
        this.sidebar = new StringBuffer();
        this.idSummary = new StringBuffer();
        Iterator<SchemaDefinition> sdit = sm.getSchemas();
        if (sdit != null) {
            while (sdit.hasNext()) {
                SchemaDefinition sd = sdit.next();
                this.allSchemasByID.put(sd.getSchemaBaseID(), sd);
                this.allSchemasByName.put(sd.getName().getNameString(), sd);
            }
        }
        this.buildSidebar();
        this.buildIDSummary();
        DmcOmni.instance().setTrackSchemaReferences(true);
        DmcOmni.instance().backRefTracking(true);
        DebugInfo.debug("\n\nCHANGED REFERENCE RESOLUTION STUFF!!!\n\n");
        for (DmsDefinition def : sm.globallyUniqueMAP.values()) {
            this.unambignify(def.getDmcObject());
            def.getDMO().clearReferenceInfo();
        }
        for (SchemaDefinition sd : this.allSchemasByName.values()) {
            rules = sd.getParsedRulesDMOs(sm);
            while (rules.hasNext()) {
                rule = rules.next();
                this.unambignify(rule);
                rule.clearReferenceInfo();
            }
        }
        for (DmsDefinition def : sm.globallyUniqueMAP.values()) {
            this.addDefinition(def);
            try {
                def.resolveReferences(sm, sm);
            }
            catch (DmcValueExceptionSet e) {
                e.printStackTrace();
                DebugInfo.debug("While resolving:\n\n" + def.toOIF() + "\n\n");
            }
        }
        for (SchemaDefinition sd : this.allSchemasByName.values()) {
            rules = sd.getParsedRulesDMOs(sm);
            while (rules.hasNext()) {
                rule = rules.next();
                try {
                    rule.resolveReferences(sm, sm);
                }
                catch (DmcValueExceptionSet e) {
                    e.printStackTrace();
                }
            }
        }
    }

    void unambignify(DmcObject obj) {
        for (DmcAttribute<?> attr : obj.getAttributes().values()) {
            if (!(attr instanceof DmcTypeNamedObjectREF)) continue;
            if (attr.getAttributeInfo().valueType == ValueTypeEnum.SINGLE) {
                DmcNamedObjectREF ref = (DmcNamedObjectREF)attr.getSV();
                DmsDefinitionDMO dmo = null;
                if (ref.getObject() instanceof DmsDefinitionDMO) {
                    dmo = (DmsDefinitionDMO)ref.getObject();
                } else if (ref.getObject() instanceof DmsDefinitionDMW) {
                    dmo = ((DmsDefinitionDMW)ref.getObject()).getDMO();
                }
                if (dmo == null) continue;
                try {
                    ref.setName(dmo.getDotName().getParentName());
                }
                catch (DmcValueException e) {
                    e.printStackTrace();
                }
                continue;
            }
            Iterator<?> refs = attr.getMV();
            while (refs.hasNext()) {
                DmcNamedObjectREF ref = (DmcNamedObjectREF)refs.next();
                DmsDefinitionDMO dmo = null;
                if (ref.getObject() instanceof DmsDefinitionDMO) {
                    dmo = (DmsDefinitionDMO)ref.getObject();
                } else if (ref.getObject() instanceof DmsDefinitionDMW) {
                    dmo = ((DmsDefinitionDMW)ref.getObject()).getDMO();
                }
                if (dmo == null) continue;
                try {
                    ref.setName(dmo.getDotName().getParentName());
                }
                catch (DmcValueException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public String getSideBar() {
        return this.sidebar.toString();
    }

    void buildSidebar() {
        this.sidebar.append("<!-- " + DebugInfo.getWhereWeAreNow() + " -->\n");
        this.sidebar.append("    <div id=\"sidebar\">\n");
        for (SchemaDefinition sd : this.allSchemasByName.values()) {
            String name = sd.getName().getNameString();
            this.sidebar.append("        <a class=\"navLink\" href=\"" + name + ".html\"> " + name + "</a>\n");
        }
        this.sidebar.append("        <a class=\"navLink\" href=\"SchemaSummaryPage.html\"> Summary </a>\n");
        this.sidebar.append("    </div>\n");
    }

    void buildIDSummary() {
        this.idSummary.append("<div class=\"idSummary\">\n\n");
        this.idSummary.append("<h2> Schema Identifier Ranges </h2>\n\n");
        this.idSummary.append("  <table>\n\n");
        for (SchemaDefinition sd : this.allSchemasByID.values()) {
            int end = sd.getSchemaBaseID() + sd.getSchemaIDRange();
            String name = sd.getName().getNameString();
            this.idSummary.append("    <tr>\n");
            this.idSummary.append("      <td>\n");
            this.idSummary.append("    " + name + "\n");
            this.idSummary.append("      </td>\n");
            this.idSummary.append("      <td>\n");
            this.idSummary.append("      " + sd.getSchemaBaseID() + "\n");
            this.idSummary.append("      </td>\n");
            this.idSummary.append("      <td>\n");
            this.idSummary.append("      " + end + "\n");
            this.idSummary.append("      </td>\n");
            this.idSummary.append("    </tr>\n");
        }
        this.idSummary.append("  </table>\n\n");
        this.idSummary.append("</div> <!-- idSummary -->\n\n");
    }

    void addDefinition(DmsDefinition def) {
        String firstLetter = Character.toUpperCase(def.getName().getNameString().charAt(0)) + "";
        TreeMap<String, DmsDefinition> startingWith = this.definitionsByLetter.get(firstLetter);
        if (startingWith == null) {
            startingWith = new TreeMap();
            this.definitionsByLetter.put(firstLetter, startingWith);
        }
        startingWith.put(def.getName().getNameString(), def);
    }

    public void dumpTextSummary() {
        for (String firstLetter : this.definitionsByLetter.keySet()) {
            TreeMap<String, DmsDefinition> startingWith = this.definitionsByLetter.get(firstLetter);
            System.out.println("---------- " + firstLetter + " ----------  (" + startingWith.size() + ")");
            for (DmsDefinition def : startingWith.values()) {
                System.out.println("    " + def.getName().getNameString() + " (" + def.getDMO().referenceCount() + ")");
            }
        }
    }

    public void dumpSchemaSummaryPage(String outdir) throws IOException {
        String ofn = outdir + File.separator + "SchemaSummaryPage.html";
        BufferedWriter out = new BufferedWriter(new FileWriter(ofn));
        StandardParts.writePageHeader(out, "Schema Summary");
        StandardParts.writeContentStart(out);
        out.write(this.idSummary.toString());
        StandardParts.writeContentEnd(out);
        out.write(this.getSideBar());
        StandardParts.writePageFooter(out);
        out.close();
    }
}

