/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.doc.web;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import org.dmd.dmc.types.DefinitionName;
import org.dmd.dms.AttributeDefinition;
import org.dmd.dms.TypeDefinition;
import org.dmd.dms.generated.dmw.SchemaDefinitionDMW;
import org.dmd.dmw.DmwWrapper;

public class TypeFormatter {
    public static void dumpDetails(BufferedWriter out, TypeDefinition td) throws IOException {
        if (td.getInternallyGenerated().booleanValue()) {
            return;
        }
        TypeFormatter.typeName(out, td);
        TypeFormatter.description(out, td);
        TypeFormatter.isNameType(out, td);
        TypeFormatter.typeClass(out, td);
        TypeFormatter.primitivetype(out, td);
        TypeFormatter.keyType(out, td);
        TypeFormatter.nullReturnValue(out, td);
        TypeFormatter.usage(out, td);
    }

    static void typeName(BufferedWriter out, TypeDefinition td) throws IOException {
        out.write("    <tr> <td class=\"typeName\" colspan=\"3\"> <a name=\"" + td.getName() + "\"> " + td.getName() + " </a> </td></tr>\n");
    }

    static void description(BufferedWriter out, TypeDefinition td) throws IOException {
        if (td.getDescription() != null) {
            out.write("    <tr>\n");
            out.write("      <td class=\"spacer\"> </td>\n");
            out.write("      <td class=\"label\">Description</td>\n");
            out.write("      <td>\n");
            Iterator<String> descr = td.getDescription();
            while (descr.hasNext()) {
                out.write(descr.next() + "\n");
                if (!descr.hasNext()) continue;
                out.write("<p/>\n");
            }
            out.write("      </td>\n");
            out.write("    </tr>\n\n");
        }
    }

    static void isNameType(BufferedWriter out, TypeDefinition td) throws IOException {
        if (td.getIsNameType().booleanValue()) {
            out.write("    <tr>\n");
            out.write("      <td class=\"spacer\"> </td>\n");
            out.write("      <td class=\"label\">Name type</td>\n");
            if (td.getIsHierarchicName().booleanValue()) {
                out.write("      <td> Hierarchic </td>\n");
            } else {
                out.write("      <td> Flat </td>\n");
            }
            out.write("    </tr>\n\n");
            if (td.getNameAttributeDef() != null) {
                String schema = ((SchemaDefinitionDMW)td.getNameAttributeDef().getDefinedIn()).getName().getNameString();
                String an = td.getNameAttributeDef().getName().getNameString();
                out.write("    <tr>\n");
                out.write("      <td class=\"spacer\"> </td>\n");
                out.write("      <td class=\"label\">Name attribute</td>\n");
                out.write("      <td> <a href=\"" + schema + ".html#" + an + "\"> " + an + " </a> </td>\n");
                out.write("    </tr>\n\n");
            }
        }
    }

    static void typeClass(BufferedWriter out, TypeDefinition td) throws IOException {
        if (td.getTypeClassName() != null) {
            out.write("    <tr>\n");
            out.write("      <td class=\"spacer\"> </td>\n");
            out.write("      <td class=\"label\">Type class</td>\n");
            out.write("      <td>" + td.getTypeClassName() + "</td>\n");
            out.write("    </tr>\n\n");
        }
    }

    static void primitivetype(BufferedWriter out, TypeDefinition td) throws IOException {
        if (td.getPrimitiveType() != null) {
            out.write("    <tr>\n");
            out.write("      <td class=\"spacer\"> </td>\n");
            out.write("      <td class=\"label\">Primitive type</td>\n");
            out.write("      <td>" + td.getPrimitiveType() + "</td>\n");
            out.write("    </tr>\n\n");
        }
    }

    static void keyType(BufferedWriter out, TypeDefinition td) throws IOException {
        if (td.getKeyClass() != null) {
            out.write("    <tr>\n");
            out.write("      <td class=\"spacer\"> </td>\n");
            out.write("      <td class=\"label\">Keyed by</td>\n");
            out.write("      <td>" + td.getKeyClass() + "</td>\n");
            out.write("    </tr>\n\n");
        }
    }

    static void nullReturnValue(BufferedWriter out, TypeDefinition td) throws IOException {
        if (td.getNullReturnValue() != null) {
            out.write("    <tr>\n");
            out.write("      <td class=\"spacer\"> </td>\n");
            out.write("      <td class=\"label\">Null value</td>\n");
            out.write("      <td>" + td.getNullReturnValue() + "</td>\n");
            out.write("    </tr>\n\n");
        }
    }

    static void usage(BufferedWriter out, TypeDefinition td) throws IOException {
        ArrayList<DmwWrapper> referring = td.getReferringObjects();
        if (referring != null && referring.size() > 1) {
            TreeMap<DefinitionName, AttributeDefinition> attributes = new TreeMap<DefinitionName, AttributeDefinition>();
            out.write("    <tr>\n");
            out.write("      <td class=\"spacer\"> </td>\n");
            out.write("      <td class=\"label\">Used in:</td>\n");
            out.write("      <td>\n");
            for (DmwWrapper wrapper : referring) {
                if (!(wrapper instanceof AttributeDefinition)) continue;
                AttributeDefinition ad = (AttributeDefinition)wrapper;
                attributes.put(ad.getName(), ad);
            }
            out.write(TypeFormatter.formatUsage(attributes));
            out.write("      </td>\n");
            out.write("    </tr>\n\n");
        }
    }

    static String formatUsage(TreeMap<DefinitionName, AttributeDefinition> ads) {
        StringBuffer sb = new StringBuffer();
        sb.append("<table>\n");
        int count = 0;
        for (AttributeDefinition ad : ads.values()) {
            if (count % 3 == 0) {
                if (count > 3) {
                    sb.append("</tr>\n");
                }
                sb.append("  <tr>\n");
            }
            String ref = "<a href=\"" + ((SchemaDefinitionDMW)ad.getDefinedIn()).getName() + ".html#" + ad.getName() + "\">" + ((SchemaDefinitionDMW)ad.getDefinedIn()).getName() + "</a>";
            sb.append("    <td> " + ad.getName().getNameString() + " (" + ref + ") </td>\n");
            ++count;
        }
        sb.append("</tr>\n");
        sb.append("</table>\n");
        return sb.toString();
    }

    public static String getTypeName(TypeDefinition td) {
        String type = td.getName().getNameString();
        if (td.getIsRefType().booleanValue() && td.getOriginalClass() != null) {
            type = td.getOriginalClass().getName().getNameString();
        }
        if (td.getIsEnumType().booleanValue()) {
            type = td.getEnumName();
        }
        return type;
    }
}

