/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.generated.rulesdmo;

import java.util.ArrayList;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcClassInfo;
import org.dmd.dmc.DmcObject;
import org.dmd.dmc.DmcOmni;
import org.dmd.dmc.rules.AttributeRuleCollection;
import org.dmd.dmc.rules.DmcRuleExceptionSet;
import org.dmd.dmc.rules.RuleIF;
import org.dmd.dms.generated.rulesdmo.AttributeValidationIF;

public class AttributeValidationRuleCollection
extends AttributeRuleCollection<AttributeValidationIF> {
    @Override
    public void addRule(RuleIF r) {
        if (r instanceof AttributeValidationIF) {
            super.addThisRule((AttributeValidationIF)r);
        }
    }

    public void execute(DmcObject obj, DmcAttribute<?> attribute) throws DmcRuleExceptionSet {
        DmcClassInfo cI;
        DmcRuleExceptionSet rc = null;
        DmcAttributeInfo aI = attribute.getAttributeInfo();
        ArrayList ruleList = super.getRules(aI, cI = obj.getConstructionClassInfo());
        if (ruleList != null) {
            for (AttributeValidationIF rule : ruleList) {
                if (DmcOmni.instance().ruleTracing()) {
                    DmcOmni.instance().ruleExecuted("Applying: " + rule.getRuleTitle() + " to: " + cI.name + "." + aI.name);
                }
                try {
                    rule.execute(obj, attribute);
                }
                catch (DmcRuleExceptionSet e) {
                    if (rc == null) {
                        rc = e;
                    } else {
                        rc.add(e);
                    }
                    if (DmcOmni.instance().ruleTracing()) {
                        DmcOmni.instance().ruleFailed(e);
                    }
                    if (!rc.immediateHalt()) continue;
                    throw rc;
                }
            }
        }
        if ((ruleList = (ArrayList)this.globalRules.get(aI)) != null) {
            for (AttributeValidationIF rule : ruleList) {
                if (DmcOmni.instance().ruleTracing()) {
                    DmcOmni.instance().ruleExecuted("Applying global: " + rule.getRuleTitle() + " to: " + cI.name + "." + aI.name);
                }
                try {
                    rule.execute(obj, attribute);
                }
                catch (DmcRuleExceptionSet e) {
                    if (rc == null) {
                        rc = e;
                    } else {
                        rc.add(e);
                    }
                    if (DmcOmni.instance().ruleTracing()) {
                        DmcOmni.instance().ruleFailed(e);
                    }
                    if (!rc.immediateHalt()) continue;
                    throw rc;
                }
            }
        }
        if (rc != null) {
            throw rc;
        }
    }
}

