/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.generated.rulesdmo;

import java.util.ArrayList;
import org.dmd.dmc.DmcClassInfo;
import org.dmd.dmc.DmcObject;
import org.dmd.dmc.DmcOmni;
import org.dmd.dmc.rules.ClassRuleCollection;
import org.dmd.dmc.rules.DmcRuleExceptionSet;
import org.dmd.dmc.rules.RuleIF;
import org.dmd.dms.generated.rulesdmo.ObjectValidationIF;

public class ObjectValidationRuleCollection
extends ClassRuleCollection<ObjectValidationIF> {
    @Override
    public void addRule(RuleIF r) {
        if (r instanceof ObjectValidationIF) {
            super.addThisRule((ObjectValidationIF)r);
        }
    }

    public void execute(DmcObject obj) throws DmcRuleExceptionSet {
        DmcRuleExceptionSet rc = null;
        DmcClassInfo cI = obj.getConstructionClassInfo();
        ArrayList ruleList = super.getRules(cI);
        if (ruleList != null) {
            for (ObjectValidationIF rule : ruleList) {
                if (DmcOmni.instance().ruleTracing()) {
                    DmcOmni.instance().ruleExecuted("Applying: " + rule.getRuleTitle() + " to: " + cI.name);
                }
                try {
                    rule.execute(obj);
                }
                catch (DmcRuleExceptionSet e) {
                    if (rc == null) {
                        rc = e;
                    } else {
                        rc.add(e);
                    }
                    if (DmcOmni.instance().ruleTracing()) {
                        DmcOmni.instance().ruleFailed(e);
                    }
                    if (!rc.immediateHalt()) continue;
                    throw rc;
                }
            }
        }
        for (ObjectValidationIF rule : this.globalRules) {
            if (DmcOmni.instance().ruleTracing()) {
                DmcOmni.instance().ruleExecuted("Applying global: " + rule.getRuleTitle() + " to: " + cI.name);
            }
            try {
                rule.execute(obj);
            }
            catch (DmcRuleExceptionSet e) {
                if (rc == null) {
                    rc = e;
                } else {
                    rc.add(e);
                }
                if (DmcOmni.instance().ruleTracing()) {
                    DmcOmni.instance().ruleFailed(e);
                }
                if (!rc.immediateHalt()) continue;
                throw rc;
            }
        }
        if (rc != null) {
            throw rc;
        }
    }
}

