/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dms.generated.types.ActionDefinitionREF;
import org.dmd.dms.generated.types.DmcTypeActionDefinitionREF;

public class DmcTypeActionDefinitionREFSET
extends DmcTypeActionDefinitionREF
implements Serializable {
    private static final Iterator<ActionDefinitionREF> emptyList = new HashSet().iterator();
    protected Set<ActionDefinitionREF> value;

    public DmcTypeActionDefinitionREFSET() {
        this.value = null;
    }

    public DmcTypeActionDefinitionREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<ActionDefinitionREF>() : new TreeSet<ActionDefinitionREF>();
    }

    public DmcTypeActionDefinitionREFSET getNew() {
        return new DmcTypeActionDefinitionREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<ActionDefinitionREF> cloneIt() {
        DmcTypeActionDefinitionREFSET dmcTypeActionDefinitionREFSET = this;
        synchronized (dmcTypeActionDefinitionREFSET) {
            DmcTypeActionDefinitionREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (ActionDefinitionREF val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActionDefinitionREF add(Object v) throws DmcValueException {
        DmcTypeActionDefinitionREFSET dmcTypeActionDefinitionREFSET = this;
        synchronized (dmcTypeActionDefinitionREFSET) {
            ActionDefinitionREF rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActionDefinitionREF del(Object v) {
        DmcTypeActionDefinitionREFSET dmcTypeActionDefinitionREFSET = this;
        synchronized (dmcTypeActionDefinitionREFSET) {
            ActionDefinitionREF rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<ActionDefinitionREF> getMV() {
        DmcTypeActionDefinitionREFSET dmcTypeActionDefinitionREFSET = this;
        synchronized (dmcTypeActionDefinitionREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<ActionDefinitionREF>(this.value).iterator();
            }
            return new TreeSet<ActionDefinitionREF>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ActionDefinitionREF> getMVCopy() {
        DmcTypeActionDefinitionREFSET dmcTypeActionDefinitionREFSET = this;
        synchronized (dmcTypeActionDefinitionREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<ActionDefinitionREF>();
                }
                return new HashSet<ActionDefinitionREF>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<ActionDefinitionREF>(this.value);
            }
            return new TreeSet<ActionDefinitionREF>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeActionDefinitionREFSET dmcTypeActionDefinitionREFSET = this;
        synchronized (dmcTypeActionDefinitionREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeActionDefinitionREFSET dmcTypeActionDefinitionREFSET = this;
        synchronized (dmcTypeActionDefinitionREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                ActionDefinitionREF val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

