/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dms.generated.types.AttributeDefinitionREF;
import org.dmd.dms.generated.types.DmcTypeAttributeDefinitionREF;

public class DmcTypeAttributeDefinitionREFSET
extends DmcTypeAttributeDefinitionREF
implements Serializable {
    private static final Iterator<AttributeDefinitionREF> emptyList = new HashSet().iterator();
    protected Set<AttributeDefinitionREF> value;

    public DmcTypeAttributeDefinitionREFSET() {
        this.value = null;
    }

    public DmcTypeAttributeDefinitionREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<AttributeDefinitionREF>() : new TreeSet<AttributeDefinitionREF>();
    }

    public DmcTypeAttributeDefinitionREFSET getNew() {
        return new DmcTypeAttributeDefinitionREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<AttributeDefinitionREF> cloneIt() {
        DmcTypeAttributeDefinitionREFSET dmcTypeAttributeDefinitionREFSET = this;
        synchronized (dmcTypeAttributeDefinitionREFSET) {
            DmcTypeAttributeDefinitionREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (AttributeDefinitionREF val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AttributeDefinitionREF add(Object v) throws DmcValueException {
        DmcTypeAttributeDefinitionREFSET dmcTypeAttributeDefinitionREFSET = this;
        synchronized (dmcTypeAttributeDefinitionREFSET) {
            AttributeDefinitionREF rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AttributeDefinitionREF del(Object v) {
        DmcTypeAttributeDefinitionREFSET dmcTypeAttributeDefinitionREFSET = this;
        synchronized (dmcTypeAttributeDefinitionREFSET) {
            AttributeDefinitionREF rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<AttributeDefinitionREF> getMV() {
        DmcTypeAttributeDefinitionREFSET dmcTypeAttributeDefinitionREFSET = this;
        synchronized (dmcTypeAttributeDefinitionREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<AttributeDefinitionREF>(this.value).iterator();
            }
            return new TreeSet<AttributeDefinitionREF>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<AttributeDefinitionREF> getMVCopy() {
        DmcTypeAttributeDefinitionREFSET dmcTypeAttributeDefinitionREFSET = this;
        synchronized (dmcTypeAttributeDefinitionREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<AttributeDefinitionREF>();
                }
                return new HashSet<AttributeDefinitionREF>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<AttributeDefinitionREF>(this.value);
            }
            return new TreeSet<AttributeDefinitionREF>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeAttributeDefinitionREFSET dmcTypeAttributeDefinitionREFSET = this;
        synchronized (dmcTypeAttributeDefinitionREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeAttributeDefinitionREFSET dmcTypeAttributeDefinitionREFSET = this;
        synchronized (dmcTypeAttributeDefinitionREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                AttributeDefinitionREF val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

