/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.AttributeID;
import org.dmd.dmc.types.DmcTypeAttributeID;
import org.dmd.dms.generated.enums.ValueTypeEnum;

public class DmcTypeAttributeIDSET
extends DmcTypeAttributeID
implements Serializable {
    private static final Iterator<AttributeID> emptyList = new HashSet().iterator();
    protected Set<AttributeID> value;

    public DmcTypeAttributeIDSET() {
        this.value = null;
    }

    public DmcTypeAttributeIDSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<AttributeID>() : new TreeSet<AttributeID>();
    }

    public DmcTypeAttributeIDSET getNew() {
        return new DmcTypeAttributeIDSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<AttributeID> cloneIt() {
        DmcTypeAttributeIDSET dmcTypeAttributeIDSET = this;
        synchronized (dmcTypeAttributeIDSET) {
            DmcTypeAttributeIDSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (AttributeID val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AttributeID add(Object v) throws DmcValueException {
        DmcTypeAttributeIDSET dmcTypeAttributeIDSET = this;
        synchronized (dmcTypeAttributeIDSET) {
            AttributeID rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AttributeID del(Object v) {
        DmcTypeAttributeIDSET dmcTypeAttributeIDSET = this;
        synchronized (dmcTypeAttributeIDSET) {
            AttributeID rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<AttributeID> getMV() {
        DmcTypeAttributeIDSET dmcTypeAttributeIDSET = this;
        synchronized (dmcTypeAttributeIDSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<AttributeID>(this.value).iterator();
            }
            return new TreeSet<AttributeID>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<AttributeID> getMVCopy() {
        DmcTypeAttributeIDSET dmcTypeAttributeIDSET = this;
        synchronized (dmcTypeAttributeIDSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<AttributeID>();
                }
                return new HashSet<AttributeID>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<AttributeID>(this.value);
            }
            return new TreeSet<AttributeID>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeAttributeIDSET dmcTypeAttributeIDSET = this;
        synchronized (dmcTypeAttributeIDSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeAttributeIDSET dmcTypeAttributeIDSET = this;
        synchronized (dmcTypeAttributeIDSET) {
            if (this.value == null) {
                return false;
            }
            try {
                AttributeID val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

