/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.BaseTypeEnum;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dms.generated.types.DmcTypeBaseTypeEnum;

public class DmcTypeBaseTypeEnumSET
extends DmcTypeBaseTypeEnum
implements Serializable {
    private static final Iterator<BaseTypeEnum> emptyList = new HashSet().iterator();
    protected Set<BaseTypeEnum> value;

    public DmcTypeBaseTypeEnumSET() {
        this.value = null;
    }

    public DmcTypeBaseTypeEnumSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<BaseTypeEnum>() : new TreeSet<BaseTypeEnum>();
    }

    public DmcTypeBaseTypeEnumSET getNew() {
        return new DmcTypeBaseTypeEnumSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<BaseTypeEnum> cloneIt() {
        DmcTypeBaseTypeEnumSET dmcTypeBaseTypeEnumSET = this;
        synchronized (dmcTypeBaseTypeEnumSET) {
            DmcTypeBaseTypeEnumSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (BaseTypeEnum val : this.value) {
                try {
                    rc.add((Object)val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseTypeEnum add(Object v) throws DmcValueException {
        DmcTypeBaseTypeEnumSET dmcTypeBaseTypeEnumSET = this;
        synchronized (dmcTypeBaseTypeEnumSET) {
            BaseTypeEnum rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseTypeEnum del(Object v) {
        DmcTypeBaseTypeEnumSET dmcTypeBaseTypeEnumSET = this;
        synchronized (dmcTypeBaseTypeEnumSET) {
            BaseTypeEnum rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains((Object)rc)) {
                this.value.remove((Object)rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<BaseTypeEnum> getMV() {
        DmcTypeBaseTypeEnumSET dmcTypeBaseTypeEnumSET = this;
        synchronized (dmcTypeBaseTypeEnumSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<BaseTypeEnum>(this.value).iterator();
            }
            return new TreeSet<BaseTypeEnum>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<BaseTypeEnum> getMVCopy() {
        DmcTypeBaseTypeEnumSET dmcTypeBaseTypeEnumSET = this;
        synchronized (dmcTypeBaseTypeEnumSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<BaseTypeEnum>();
                }
                return new HashSet<BaseTypeEnum>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<BaseTypeEnum>(this.value);
            }
            return new TreeSet<BaseTypeEnum>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeBaseTypeEnumSET dmcTypeBaseTypeEnumSET = this;
        synchronized (dmcTypeBaseTypeEnumSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeBaseTypeEnumSET dmcTypeBaseTypeEnumSET = this;
        synchronized (dmcTypeBaseTypeEnumSET) {
            if (this.value == null) {
                return false;
            }
            try {
                BaseTypeEnum val = this.typeCheck(v);
                return this.value.contains((Object)val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

