/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.DmcTypeBoolean;
import org.dmd.dms.generated.enums.ValueTypeEnum;

public class DmcTypeBooleanSET
extends DmcTypeBoolean
implements Serializable {
    private static final Iterator<Boolean> emptyList = new HashSet().iterator();
    protected Set<Boolean> value;

    public DmcTypeBooleanSET() {
        this.value = null;
    }

    public DmcTypeBooleanSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<Boolean>() : new TreeSet<Boolean>();
    }

    public DmcTypeBooleanSET getNew() {
        return new DmcTypeBooleanSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<Boolean> cloneIt() {
        DmcTypeBooleanSET dmcTypeBooleanSET = this;
        synchronized (dmcTypeBooleanSET) {
            DmcTypeBooleanSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (Boolean val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean add(Object v) throws DmcValueException {
        DmcTypeBooleanSET dmcTypeBooleanSET = this;
        synchronized (dmcTypeBooleanSET) {
            Boolean rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean del(Object v) {
        DmcTypeBooleanSET dmcTypeBooleanSET = this;
        synchronized (dmcTypeBooleanSET) {
            Boolean rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Boolean> getMV() {
        DmcTypeBooleanSET dmcTypeBooleanSET = this;
        synchronized (dmcTypeBooleanSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<Boolean>(this.value).iterator();
            }
            return new TreeSet<Boolean>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Boolean> getMVCopy() {
        DmcTypeBooleanSET dmcTypeBooleanSET = this;
        synchronized (dmcTypeBooleanSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<Boolean>();
                }
                return new HashSet<Boolean>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<Boolean>(this.value);
            }
            return new TreeSet<Boolean>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeBooleanSET dmcTypeBooleanSET = this;
        synchronized (dmcTypeBooleanSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeBooleanSET dmcTypeBooleanSET = this;
        synchronized (dmcTypeBooleanSET) {
            if (this.value == null) {
                return false;
            }
            try {
                Boolean val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

