/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.generated.types;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.DmcTypeByte;

public class DmcTypeByteMV
extends DmcTypeByte
implements Serializable {
    private static final Iterator<Byte> emptyList = new ArrayList().iterator();
    protected ArrayList<Byte> value;

    public DmcTypeByteMV() {
    }

    public DmcTypeByteMV(DmcAttributeInfo ai) {
        super(ai);
    }

    public DmcTypeByteMV getNew() {
        return new DmcTypeByteMV(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<Byte> cloneIt() {
        DmcTypeByteMV dmcTypeByteMV = this;
        synchronized (dmcTypeByteMV) {
            DmcTypeByteMV rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            if (this.getAttributeInfo().indexSize == 0) {
                for (Byte val : this.value) {
                    try {
                        rc.add(val);
                    }
                    catch (DmcValueException e) {
                        throw new IllegalStateException("typeCheck() should never fail here!", e);
                    }
                }
            } else {
                for (int index = 0; index < this.value.size(); ++index) {
                    try {
                        rc.setMVnth(index, this.value.get(index));
                        continue;
                    }
                    catch (DmcValueException e) {
                        throw new IllegalStateException("typeCheck() should never fail here!", e);
                    }
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Byte add(Object v) throws DmcValueException {
        DmcTypeByteMV dmcTypeByteMV = this;
        synchronized (dmcTypeByteMV) {
            Byte rc = this.typeCheck(v);
            if (this.value == null) {
                this.value = new ArrayList();
            }
            this.value.add(rc);
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Byte del(Object v) {
        DmcTypeByteMV dmcTypeByteMV = this;
        synchronized (dmcTypeByteMV) {
            if (this.value == null) {
                return null;
            }
            Byte key = null;
            Byte rc = null;
            try {
                key = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            int indexof = this.value.indexOf(key);
            if (indexof != -1) {
                rc = this.value.get(indexof);
                this.value.remove(rc);
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Byte> getMV() {
        DmcTypeByteMV dmcTypeByteMV = this;
        synchronized (dmcTypeByteMV) {
            if (this.value == null) {
                return emptyList;
            }
            ArrayList<Byte> clone = new ArrayList<Byte>(this.value);
            return clone.iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Byte> getMVCopy() {
        DmcTypeByteMV dmcTypeByteMV = this;
        synchronized (dmcTypeByteMV) {
            if (this.value == null) {
                return new ArrayList<Byte>();
            }
            return new ArrayList<Byte>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeByteMV dmcTypeByteMV = this;
        synchronized (dmcTypeByteMV) {
            if (this.getAttributeInfo().indexSize == 0) {
                if (this.value == null) {
                    return 0;
                }
                return this.value.size();
            }
            return this.getAttributeInfo().indexSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Byte getMVnth(int index) {
        DmcTypeByteMV dmcTypeByteMV = this;
        synchronized (dmcTypeByteMV) {
            if (this.value == null) {
                return null;
            }
            return this.value.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Byte setMVnth(int index, Object v) throws DmcValueException {
        DmcTypeByteMV dmcTypeByteMV = this;
        synchronized (dmcTypeByteMV) {
            if (this.getAttributeInfo().indexSize == 0) {
                throw new IllegalStateException("Attribute: " + this.getAttributeInfo().name + " is not indexed. You can't use setMVnth().");
            }
            if (index < 0 || index >= this.getAttributeInfo().indexSize) {
                throw new IllegalStateException("Index " + index + " for attribute: " + this.getAttributeInfo().name + " is out of range: 0 <= index < " + this.getAttributeInfo().indexSize);
            }
            Byte rc = null;
            if (v != null) {
                rc = this.typeCheck(v);
            }
            if (this.value == null) {
                this.value = new ArrayList(this.getAttributeInfo().indexSize);
                for (int i = 0; i < this.getAttributeInfo().indexSize; ++i) {
                    this.value.add(null);
                }
            }
            this.value.set(index, rc);
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasValue() {
        DmcTypeByteMV dmcTypeByteMV = this;
        synchronized (dmcTypeByteMV) {
            boolean rc = false;
            if (this.getAttributeInfo().indexSize == 0) {
                throw new IllegalStateException("Attribute: " + this.getAttributeInfo().name + " is not indexed. You can't use hasValue().");
            }
            if (this.value == null) {
                return rc;
            }
            for (int i = 0; i < this.value.size(); ++i) {
                if (this.value.get(i) == null) continue;
                rc = true;
                break;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeByteMV dmcTypeByteMV = this;
        synchronized (dmcTypeByteMV) {
            if (this.value == null) {
                return false;
            }
            try {
                Byte val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

