/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.DmcTypeByte;
import org.dmd.dms.generated.enums.ValueTypeEnum;

public class DmcTypeByteSET
extends DmcTypeByte
implements Serializable {
    private static final Iterator<Byte> emptyList = new HashSet().iterator();
    protected Set<Byte> value;

    public DmcTypeByteSET() {
        this.value = null;
    }

    public DmcTypeByteSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<Byte>() : new TreeSet<Byte>();
    }

    public DmcTypeByteSET getNew() {
        return new DmcTypeByteSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<Byte> cloneIt() {
        DmcTypeByteSET dmcTypeByteSET = this;
        synchronized (dmcTypeByteSET) {
            DmcTypeByteSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (Byte val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Byte add(Object v) throws DmcValueException {
        DmcTypeByteSET dmcTypeByteSET = this;
        synchronized (dmcTypeByteSET) {
            Byte rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Byte del(Object v) {
        DmcTypeByteSET dmcTypeByteSET = this;
        synchronized (dmcTypeByteSET) {
            Byte rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Byte> getMV() {
        DmcTypeByteSET dmcTypeByteSET = this;
        synchronized (dmcTypeByteSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<Byte>(this.value).iterator();
            }
            return new TreeSet<Byte>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Byte> getMVCopy() {
        DmcTypeByteSET dmcTypeByteSET = this;
        synchronized (dmcTypeByteSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<Byte>();
                }
                return new HashSet<Byte>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<Byte>(this.value);
            }
            return new TreeSet<Byte>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeByteSET dmcTypeByteSET = this;
        synchronized (dmcTypeByteSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeByteSET dmcTypeByteSET = this;
        synchronized (dmcTypeByteSET) {
            if (this.value == null) {
                return false;
            }
            try {
                Byte val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

