/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.CamelCaseName;
import org.dmd.dmc.types.DmcTypeCamelCaseName;
import org.dmd.dms.generated.enums.ValueTypeEnum;

public class DmcTypeCamelCaseNameSET
extends DmcTypeCamelCaseName
implements Serializable {
    private static final Iterator<CamelCaseName> emptyList = new HashSet().iterator();
    protected Set<CamelCaseName> value;

    public DmcTypeCamelCaseNameSET() {
        this.value = null;
    }

    public DmcTypeCamelCaseNameSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<CamelCaseName>() : new TreeSet<CamelCaseName>();
    }

    public DmcTypeCamelCaseNameSET getNew() {
        return new DmcTypeCamelCaseNameSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<CamelCaseName> cloneIt() {
        DmcTypeCamelCaseNameSET dmcTypeCamelCaseNameSET = this;
        synchronized (dmcTypeCamelCaseNameSET) {
            DmcTypeCamelCaseNameSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (CamelCaseName val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CamelCaseName add(Object v) throws DmcValueException {
        DmcTypeCamelCaseNameSET dmcTypeCamelCaseNameSET = this;
        synchronized (dmcTypeCamelCaseNameSET) {
            CamelCaseName rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CamelCaseName del(Object v) {
        DmcTypeCamelCaseNameSET dmcTypeCamelCaseNameSET = this;
        synchronized (dmcTypeCamelCaseNameSET) {
            CamelCaseName rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<CamelCaseName> getMV() {
        DmcTypeCamelCaseNameSET dmcTypeCamelCaseNameSET = this;
        synchronized (dmcTypeCamelCaseNameSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<CamelCaseName>(this.value).iterator();
            }
            return new TreeSet<CamelCaseName>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<CamelCaseName> getMVCopy() {
        DmcTypeCamelCaseNameSET dmcTypeCamelCaseNameSET = this;
        synchronized (dmcTypeCamelCaseNameSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<CamelCaseName>();
                }
                return new HashSet<CamelCaseName>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<CamelCaseName>(this.value);
            }
            return new TreeSet<CamelCaseName>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeCamelCaseNameSET dmcTypeCamelCaseNameSET = this;
        synchronized (dmcTypeCamelCaseNameSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeCamelCaseNameSET dmcTypeCamelCaseNameSET = this;
        synchronized (dmcTypeCamelCaseNameSET) {
            if (this.value == null) {
                return false;
            }
            try {
                CamelCaseName val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

