/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dms.generated.types.ClassDefinitionREF;
import org.dmd.dms.generated.types.DmcTypeClassDefinitionREF;

public class DmcTypeClassDefinitionREFSET
extends DmcTypeClassDefinitionREF
implements Serializable {
    private static final Iterator<ClassDefinitionREF> emptyList = new HashSet().iterator();
    protected Set<ClassDefinitionREF> value;

    public DmcTypeClassDefinitionREFSET() {
        this.value = null;
    }

    public DmcTypeClassDefinitionREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<ClassDefinitionREF>() : new TreeSet<ClassDefinitionREF>();
    }

    public DmcTypeClassDefinitionREFSET getNew() {
        return new DmcTypeClassDefinitionREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<ClassDefinitionREF> cloneIt() {
        DmcTypeClassDefinitionREFSET dmcTypeClassDefinitionREFSET = this;
        synchronized (dmcTypeClassDefinitionREFSET) {
            DmcTypeClassDefinitionREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (ClassDefinitionREF val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClassDefinitionREF add(Object v) throws DmcValueException {
        DmcTypeClassDefinitionREFSET dmcTypeClassDefinitionREFSET = this;
        synchronized (dmcTypeClassDefinitionREFSET) {
            ClassDefinitionREF rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClassDefinitionREF del(Object v) {
        DmcTypeClassDefinitionREFSET dmcTypeClassDefinitionREFSET = this;
        synchronized (dmcTypeClassDefinitionREFSET) {
            ClassDefinitionREF rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<ClassDefinitionREF> getMV() {
        DmcTypeClassDefinitionREFSET dmcTypeClassDefinitionREFSET = this;
        synchronized (dmcTypeClassDefinitionREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<ClassDefinitionREF>(this.value).iterator();
            }
            return new TreeSet<ClassDefinitionREF>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ClassDefinitionREF> getMVCopy() {
        DmcTypeClassDefinitionREFSET dmcTypeClassDefinitionREFSET = this;
        synchronized (dmcTypeClassDefinitionREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<ClassDefinitionREF>();
                }
                return new HashSet<ClassDefinitionREF>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<ClassDefinitionREF>(this.value);
            }
            return new TreeSet<ClassDefinitionREF>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeClassDefinitionREFSET dmcTypeClassDefinitionREFSET = this;
        synchronized (dmcTypeClassDefinitionREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeClassDefinitionREFSET dmcTypeClassDefinitionREFSET = this;
        synchronized (dmcTypeClassDefinitionREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                ClassDefinitionREF val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

