/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.ClassFilter;
import org.dmd.dmc.types.DmcTypeClassFilter;
import org.dmd.dms.generated.enums.ValueTypeEnum;

public class DmcTypeClassFilterSET
extends DmcTypeClassFilter
implements Serializable {
    private static final Iterator<ClassFilter> emptyList = new HashSet().iterator();
    protected Set<ClassFilter> value;

    public DmcTypeClassFilterSET() {
        this.value = null;
    }

    public DmcTypeClassFilterSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<ClassFilter>() : new TreeSet<ClassFilter>();
    }

    public DmcTypeClassFilterSET getNew() {
        return new DmcTypeClassFilterSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<ClassFilter> cloneIt() {
        DmcTypeClassFilterSET dmcTypeClassFilterSET = this;
        synchronized (dmcTypeClassFilterSET) {
            DmcTypeClassFilterSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (ClassFilter val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClassFilter add(Object v) throws DmcValueException {
        DmcTypeClassFilterSET dmcTypeClassFilterSET = this;
        synchronized (dmcTypeClassFilterSET) {
            ClassFilter rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClassFilter del(Object v) {
        DmcTypeClassFilterSET dmcTypeClassFilterSET = this;
        synchronized (dmcTypeClassFilterSET) {
            ClassFilter rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<ClassFilter> getMV() {
        DmcTypeClassFilterSET dmcTypeClassFilterSET = this;
        synchronized (dmcTypeClassFilterSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<ClassFilter>(this.value).iterator();
            }
            return new TreeSet<ClassFilter>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ClassFilter> getMVCopy() {
        DmcTypeClassFilterSET dmcTypeClassFilterSET = this;
        synchronized (dmcTypeClassFilterSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<ClassFilter>();
                }
                return new HashSet<ClassFilter>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<ClassFilter>(this.value);
            }
            return new TreeSet<ClassFilter>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeClassFilterSET dmcTypeClassFilterSET = this;
        synchronized (dmcTypeClassFilterSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeClassFilterSET dmcTypeClassFilterSET = this;
        synchronized (dmcTypeClassFilterSET) {
            if (this.value == null) {
                return false;
            }
            try {
                ClassFilter val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

