/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.ClassInfoRef;
import org.dmd.dmc.types.DmcTypeClassInfoRef;
import org.dmd.dms.generated.enums.ValueTypeEnum;

public class DmcTypeClassInfoRefSET
extends DmcTypeClassInfoRef
implements Serializable {
    private static final Iterator<ClassInfoRef> emptyList = new HashSet().iterator();
    protected Set<ClassInfoRef> value;

    public DmcTypeClassInfoRefSET() {
        this.value = null;
    }

    public DmcTypeClassInfoRefSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<ClassInfoRef>() : new TreeSet<ClassInfoRef>();
    }

    public DmcTypeClassInfoRefSET getNew() {
        return new DmcTypeClassInfoRefSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<ClassInfoRef> cloneIt() {
        DmcTypeClassInfoRefSET dmcTypeClassInfoRefSET = this;
        synchronized (dmcTypeClassInfoRefSET) {
            DmcTypeClassInfoRefSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (ClassInfoRef val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClassInfoRef add(Object v) throws DmcValueException {
        DmcTypeClassInfoRefSET dmcTypeClassInfoRefSET = this;
        synchronized (dmcTypeClassInfoRefSET) {
            ClassInfoRef rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClassInfoRef del(Object v) {
        DmcTypeClassInfoRefSET dmcTypeClassInfoRefSET = this;
        synchronized (dmcTypeClassInfoRefSET) {
            ClassInfoRef rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<ClassInfoRef> getMV() {
        DmcTypeClassInfoRefSET dmcTypeClassInfoRefSET = this;
        synchronized (dmcTypeClassInfoRefSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<ClassInfoRef>(this.value).iterator();
            }
            return new TreeSet<ClassInfoRef>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ClassInfoRef> getMVCopy() {
        DmcTypeClassInfoRefSET dmcTypeClassInfoRefSET = this;
        synchronized (dmcTypeClassInfoRefSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<ClassInfoRef>();
                }
                return new HashSet<ClassInfoRef>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<ClassInfoRef>(this.value);
            }
            return new TreeSet<ClassInfoRef>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeClassInfoRefSET dmcTypeClassInfoRefSET = this;
        synchronized (dmcTypeClassInfoRefSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeClassInfoRefSET dmcTypeClassInfoRefSET = this;
        synchronized (dmcTypeClassInfoRefSET) {
            if (this.value == null) {
                return false;
            }
            try {
                ClassInfoRef val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

