/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dms.generated.types.ConcinnityREF;
import org.dmd.dms.generated.types.DmcTypeConcinnityREF;

public class DmcTypeConcinnityREFSET
extends DmcTypeConcinnityREF
implements Serializable {
    private static final Iterator<ConcinnityREF> emptyList = new HashSet().iterator();
    protected Set<ConcinnityREF> value;

    public DmcTypeConcinnityREFSET() {
        this.value = null;
    }

    public DmcTypeConcinnityREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<ConcinnityREF>() : new TreeSet<ConcinnityREF>();
    }

    public DmcTypeConcinnityREFSET getNew() {
        return new DmcTypeConcinnityREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<ConcinnityREF> cloneIt() {
        DmcTypeConcinnityREFSET dmcTypeConcinnityREFSET = this;
        synchronized (dmcTypeConcinnityREFSET) {
            DmcTypeConcinnityREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (ConcinnityREF val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConcinnityREF add(Object v) throws DmcValueException {
        DmcTypeConcinnityREFSET dmcTypeConcinnityREFSET = this;
        synchronized (dmcTypeConcinnityREFSET) {
            ConcinnityREF rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConcinnityREF del(Object v) {
        DmcTypeConcinnityREFSET dmcTypeConcinnityREFSET = this;
        synchronized (dmcTypeConcinnityREFSET) {
            ConcinnityREF rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<ConcinnityREF> getMV() {
        DmcTypeConcinnityREFSET dmcTypeConcinnityREFSET = this;
        synchronized (dmcTypeConcinnityREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<ConcinnityREF>(this.value).iterator();
            }
            return new TreeSet<ConcinnityREF>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ConcinnityREF> getMVCopy() {
        DmcTypeConcinnityREFSET dmcTypeConcinnityREFSET = this;
        synchronized (dmcTypeConcinnityREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<ConcinnityREF>();
                }
                return new HashSet<ConcinnityREF>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<ConcinnityREF>(this.value);
            }
            return new TreeSet<ConcinnityREF>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeConcinnityREFSET dmcTypeConcinnityREFSET = this;
        synchronized (dmcTypeConcinnityREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeConcinnityREFSET dmcTypeConcinnityREFSET = this;
        synchronized (dmcTypeConcinnityREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                ConcinnityREF val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

