/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dms.generated.types.DSDefinitionREF;
import org.dmd.dms.generated.types.DmcTypeDSDefinitionREF;

public class DmcTypeDSDefinitionREFSET
extends DmcTypeDSDefinitionREF
implements Serializable {
    private static final Iterator<DSDefinitionREF> emptyList = new HashSet().iterator();
    protected Set<DSDefinitionREF> value;

    public DmcTypeDSDefinitionREFSET() {
        this.value = null;
    }

    public DmcTypeDSDefinitionREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<DSDefinitionREF>() : new TreeSet<DSDefinitionREF>();
    }

    public DmcTypeDSDefinitionREFSET getNew() {
        return new DmcTypeDSDefinitionREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<DSDefinitionREF> cloneIt() {
        DmcTypeDSDefinitionREFSET dmcTypeDSDefinitionREFSET = this;
        synchronized (dmcTypeDSDefinitionREFSET) {
            DmcTypeDSDefinitionREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (DSDefinitionREF val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DSDefinitionREF add(Object v) throws DmcValueException {
        DmcTypeDSDefinitionREFSET dmcTypeDSDefinitionREFSET = this;
        synchronized (dmcTypeDSDefinitionREFSET) {
            DSDefinitionREF rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DSDefinitionREF del(Object v) {
        DmcTypeDSDefinitionREFSET dmcTypeDSDefinitionREFSET = this;
        synchronized (dmcTypeDSDefinitionREFSET) {
            DSDefinitionREF rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<DSDefinitionREF> getMV() {
        DmcTypeDSDefinitionREFSET dmcTypeDSDefinitionREFSET = this;
        synchronized (dmcTypeDSDefinitionREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<DSDefinitionREF>(this.value).iterator();
            }
            return new TreeSet<DSDefinitionREF>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DSDefinitionREF> getMVCopy() {
        DmcTypeDSDefinitionREFSET dmcTypeDSDefinitionREFSET = this;
        synchronized (dmcTypeDSDefinitionREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<DSDefinitionREF>();
                }
                return new HashSet<DSDefinitionREF>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<DSDefinitionREF>(this.value);
            }
            return new TreeSet<DSDefinitionREF>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeDSDefinitionREFSET dmcTypeDSDefinitionREFSET = this;
        synchronized (dmcTypeDSDefinitionREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeDSDefinitionREFSET dmcTypeDSDefinitionREFSET = this;
        synchronized (dmcTypeDSDefinitionREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                DSDefinitionREF val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

