/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.DataTypeEnum;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dms.generated.types.DmcTypeDataTypeEnum;

public class DmcTypeDataTypeEnumSET
extends DmcTypeDataTypeEnum
implements Serializable {
    private static final Iterator<DataTypeEnum> emptyList = new HashSet().iterator();
    protected Set<DataTypeEnum> value;

    public DmcTypeDataTypeEnumSET() {
        this.value = null;
    }

    public DmcTypeDataTypeEnumSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<DataTypeEnum>() : new TreeSet<DataTypeEnum>();
    }

    public DmcTypeDataTypeEnumSET getNew() {
        return new DmcTypeDataTypeEnumSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<DataTypeEnum> cloneIt() {
        DmcTypeDataTypeEnumSET dmcTypeDataTypeEnumSET = this;
        synchronized (dmcTypeDataTypeEnumSET) {
            DmcTypeDataTypeEnumSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (DataTypeEnum val : this.value) {
                try {
                    rc.add((Object)val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataTypeEnum add(Object v) throws DmcValueException {
        DmcTypeDataTypeEnumSET dmcTypeDataTypeEnumSET = this;
        synchronized (dmcTypeDataTypeEnumSET) {
            DataTypeEnum rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataTypeEnum del(Object v) {
        DmcTypeDataTypeEnumSET dmcTypeDataTypeEnumSET = this;
        synchronized (dmcTypeDataTypeEnumSET) {
            DataTypeEnum rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains((Object)rc)) {
                this.value.remove((Object)rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<DataTypeEnum> getMV() {
        DmcTypeDataTypeEnumSET dmcTypeDataTypeEnumSET = this;
        synchronized (dmcTypeDataTypeEnumSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<DataTypeEnum>(this.value).iterator();
            }
            return new TreeSet<DataTypeEnum>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DataTypeEnum> getMVCopy() {
        DmcTypeDataTypeEnumSET dmcTypeDataTypeEnumSET = this;
        synchronized (dmcTypeDataTypeEnumSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<DataTypeEnum>();
                }
                return new HashSet<DataTypeEnum>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<DataTypeEnum>(this.value);
            }
            return new TreeSet<DataTypeEnum>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeDataTypeEnumSET dmcTypeDataTypeEnumSET = this;
        synchronized (dmcTypeDataTypeEnumSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeDataTypeEnumSET dmcTypeDataTypeEnumSET = this;
        synchronized (dmcTypeDataTypeEnumSET) {
            if (this.value == null) {
                return false;
            }
            try {
                DataTypeEnum val = this.typeCheck(v);
                return this.value.contains((Object)val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

