/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.generated.types;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.DmcTypeDate;
import org.dmd.dms.generated.enums.ValueTypeEnum;

public class DmcTypeDateSET
extends DmcTypeDate
implements Serializable {
    private static final Iterator<Date> emptyList = new HashSet().iterator();
    protected Set<Date> value;

    public DmcTypeDateSET() {
        this.value = null;
    }

    public DmcTypeDateSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<Date>() : new TreeSet<Date>();
    }

    public DmcTypeDateSET getNew() {
        return new DmcTypeDateSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<Date> cloneIt() {
        DmcTypeDateSET dmcTypeDateSET = this;
        synchronized (dmcTypeDateSET) {
            DmcTypeDateSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (Date val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date add(Object v) throws DmcValueException {
        DmcTypeDateSET dmcTypeDateSET = this;
        synchronized (dmcTypeDateSET) {
            Date rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date del(Object v) {
        DmcTypeDateSET dmcTypeDateSET = this;
        synchronized (dmcTypeDateSET) {
            Date rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Date> getMV() {
        DmcTypeDateSET dmcTypeDateSET = this;
        synchronized (dmcTypeDateSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<Date>(this.value).iterator();
            }
            return new TreeSet<Date>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Date> getMVCopy() {
        DmcTypeDateSET dmcTypeDateSET = this;
        synchronized (dmcTypeDateSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<Date>();
                }
                return new HashSet<Date>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<Date>(this.value);
            }
            return new TreeSet<Date>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeDateSET dmcTypeDateSET = this;
        synchronized (dmcTypeDateSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeDateSET dmcTypeDateSET = this;
        synchronized (dmcTypeDateSET) {
            if (this.value == null) {
                return false;
            }
            try {
                Date val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

