/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.DebugEnum;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dms.generated.types.DmcTypeDebugEnum;

public class DmcTypeDebugEnumSET
extends DmcTypeDebugEnum
implements Serializable {
    private static final Iterator<DebugEnum> emptyList = new HashSet().iterator();
    protected Set<DebugEnum> value;

    public DmcTypeDebugEnumSET() {
        this.value = null;
    }

    public DmcTypeDebugEnumSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<DebugEnum>() : new TreeSet<DebugEnum>();
    }

    public DmcTypeDebugEnumSET getNew() {
        return new DmcTypeDebugEnumSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<DebugEnum> cloneIt() {
        DmcTypeDebugEnumSET dmcTypeDebugEnumSET = this;
        synchronized (dmcTypeDebugEnumSET) {
            DmcTypeDebugEnumSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (DebugEnum val : this.value) {
                try {
                    rc.add((Object)val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DebugEnum add(Object v) throws DmcValueException {
        DmcTypeDebugEnumSET dmcTypeDebugEnumSET = this;
        synchronized (dmcTypeDebugEnumSET) {
            DebugEnum rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DebugEnum del(Object v) {
        DmcTypeDebugEnumSET dmcTypeDebugEnumSET = this;
        synchronized (dmcTypeDebugEnumSET) {
            DebugEnum rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains((Object)rc)) {
                this.value.remove((Object)rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<DebugEnum> getMV() {
        DmcTypeDebugEnumSET dmcTypeDebugEnumSET = this;
        synchronized (dmcTypeDebugEnumSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<DebugEnum>(this.value).iterator();
            }
            return new TreeSet<DebugEnum>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DebugEnum> getMVCopy() {
        DmcTypeDebugEnumSET dmcTypeDebugEnumSET = this;
        synchronized (dmcTypeDebugEnumSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<DebugEnum>();
                }
                return new HashSet<DebugEnum>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<DebugEnum>(this.value);
            }
            return new TreeSet<DebugEnum>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeDebugEnumSET dmcTypeDebugEnumSET = this;
        synchronized (dmcTypeDebugEnumSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeDebugEnumSET dmcTypeDebugEnumSET = this;
        synchronized (dmcTypeDebugEnumSET) {
            if (this.value == null) {
                return false;
            }
            try {
                DebugEnum val = this.typeCheck(v);
                return this.value.contains((Object)val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

