/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.DefinitionName;
import org.dmd.dmc.types.DmcTypeDefinitionName;
import org.dmd.dms.generated.enums.ValueTypeEnum;

public class DmcTypeDefinitionNameSET
extends DmcTypeDefinitionName
implements Serializable {
    private static final Iterator<DefinitionName> emptyList = new HashSet().iterator();
    protected Set<DefinitionName> value;

    public DmcTypeDefinitionNameSET() {
        this.value = null;
    }

    public DmcTypeDefinitionNameSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<DefinitionName>() : new TreeSet<DefinitionName>();
    }

    public DmcTypeDefinitionNameSET getNew() {
        return new DmcTypeDefinitionNameSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<DefinitionName> cloneIt() {
        DmcTypeDefinitionNameSET dmcTypeDefinitionNameSET = this;
        synchronized (dmcTypeDefinitionNameSET) {
            DmcTypeDefinitionNameSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (DefinitionName val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DefinitionName add(Object v) throws DmcValueException {
        DmcTypeDefinitionNameSET dmcTypeDefinitionNameSET = this;
        synchronized (dmcTypeDefinitionNameSET) {
            DefinitionName rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DefinitionName del(Object v) {
        DmcTypeDefinitionNameSET dmcTypeDefinitionNameSET = this;
        synchronized (dmcTypeDefinitionNameSET) {
            DefinitionName rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<DefinitionName> getMV() {
        DmcTypeDefinitionNameSET dmcTypeDefinitionNameSET = this;
        synchronized (dmcTypeDefinitionNameSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<DefinitionName>(this.value).iterator();
            }
            return new TreeSet<DefinitionName>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DefinitionName> getMVCopy() {
        DmcTypeDefinitionNameSET dmcTypeDefinitionNameSET = this;
        synchronized (dmcTypeDefinitionNameSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<DefinitionName>();
                }
                return new HashSet<DefinitionName>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<DefinitionName>(this.value);
            }
            return new TreeSet<DefinitionName>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeDefinitionNameSET dmcTypeDefinitionNameSET = this;
        synchronized (dmcTypeDefinitionNameSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeDefinitionNameSET dmcTypeDefinitionNameSET = this;
        synchronized (dmcTypeDefinitionNameSET) {
            if (this.value == null) {
                return false;
            }
            try {
                DefinitionName val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

