/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dms.generated.types.DependencyImplementationREF;
import org.dmd.dms.generated.types.DmcTypeDependencyImplementationREF;

public class DmcTypeDependencyImplementationREFSET
extends DmcTypeDependencyImplementationREF
implements Serializable {
    private static final Iterator<DependencyImplementationREF> emptyList = new HashSet().iterator();
    protected Set<DependencyImplementationREF> value;

    public DmcTypeDependencyImplementationREFSET() {
        this.value = null;
    }

    public DmcTypeDependencyImplementationREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<DependencyImplementationREF>() : new TreeSet<DependencyImplementationREF>();
    }

    public DmcTypeDependencyImplementationREFSET getNew() {
        return new DmcTypeDependencyImplementationREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<DependencyImplementationREF> cloneIt() {
        DmcTypeDependencyImplementationREFSET dmcTypeDependencyImplementationREFSET = this;
        synchronized (dmcTypeDependencyImplementationREFSET) {
            DmcTypeDependencyImplementationREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (DependencyImplementationREF val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DependencyImplementationREF add(Object v) throws DmcValueException {
        DmcTypeDependencyImplementationREFSET dmcTypeDependencyImplementationREFSET = this;
        synchronized (dmcTypeDependencyImplementationREFSET) {
            DependencyImplementationREF rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DependencyImplementationREF del(Object v) {
        DmcTypeDependencyImplementationREFSET dmcTypeDependencyImplementationREFSET = this;
        synchronized (dmcTypeDependencyImplementationREFSET) {
            DependencyImplementationREF rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<DependencyImplementationREF> getMV() {
        DmcTypeDependencyImplementationREFSET dmcTypeDependencyImplementationREFSET = this;
        synchronized (dmcTypeDependencyImplementationREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<DependencyImplementationREF>(this.value).iterator();
            }
            return new TreeSet<DependencyImplementationREF>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DependencyImplementationREF> getMVCopy() {
        DmcTypeDependencyImplementationREFSET dmcTypeDependencyImplementationREFSET = this;
        synchronized (dmcTypeDependencyImplementationREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<DependencyImplementationREF>();
                }
                return new HashSet<DependencyImplementationREF>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<DependencyImplementationREF>(this.value);
            }
            return new TreeSet<DependencyImplementationREF>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeDependencyImplementationREFSET dmcTypeDependencyImplementationREFSET = this;
        synchronized (dmcTypeDependencyImplementationREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeDependencyImplementationREFSET dmcTypeDependencyImplementationREFSET = this;
        synchronized (dmcTypeDependencyImplementationREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                DependencyImplementationREF val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

