/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dms.generated.types.DependencyREF;
import org.dmd.dms.generated.types.DmcTypeDependencyREF;

public class DmcTypeDependencyREFSET
extends DmcTypeDependencyREF
implements Serializable {
    private static final Iterator<DependencyREF> emptyList = new HashSet().iterator();
    protected Set<DependencyREF> value;

    public DmcTypeDependencyREFSET() {
        this.value = null;
    }

    public DmcTypeDependencyREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<DependencyREF>() : new TreeSet<DependencyREF>();
    }

    public DmcTypeDependencyREFSET getNew() {
        return new DmcTypeDependencyREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<DependencyREF> cloneIt() {
        DmcTypeDependencyREFSET dmcTypeDependencyREFSET = this;
        synchronized (dmcTypeDependencyREFSET) {
            DmcTypeDependencyREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (DependencyREF val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DependencyREF add(Object v) throws DmcValueException {
        DmcTypeDependencyREFSET dmcTypeDependencyREFSET = this;
        synchronized (dmcTypeDependencyREFSET) {
            DependencyREF rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DependencyREF del(Object v) {
        DmcTypeDependencyREFSET dmcTypeDependencyREFSET = this;
        synchronized (dmcTypeDependencyREFSET) {
            DependencyREF rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<DependencyREF> getMV() {
        DmcTypeDependencyREFSET dmcTypeDependencyREFSET = this;
        synchronized (dmcTypeDependencyREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<DependencyREF>(this.value).iterator();
            }
            return new TreeSet<DependencyREF>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DependencyREF> getMVCopy() {
        DmcTypeDependencyREFSET dmcTypeDependencyREFSET = this;
        synchronized (dmcTypeDependencyREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<DependencyREF>();
                }
                return new HashSet<DependencyREF>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<DependencyREF>(this.value);
            }
            return new TreeSet<DependencyREF>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeDependencyREFSET dmcTypeDependencyREFSET = this;
        synchronized (dmcTypeDependencyREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeDependencyREFSET dmcTypeDependencyREFSET = this;
        synchronized (dmcTypeDependencyREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                DependencyREF val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

