/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcObject;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.DmcTypeDmcObject;
import org.dmd.dms.generated.enums.ValueTypeEnum;

public class DmcTypeDmcObjectSET
extends DmcTypeDmcObject
implements Serializable {
    private static final Iterator<DmcObject> emptyList = new HashSet().iterator();
    protected Set<DmcObject> value;

    public DmcTypeDmcObjectSET() {
        this.value = null;
    }

    public DmcTypeDmcObjectSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<DmcObject>() : new TreeSet<DmcObject>();
    }

    public DmcTypeDmcObjectSET getNew() {
        return new DmcTypeDmcObjectSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<DmcObject> cloneIt() {
        DmcTypeDmcObjectSET dmcTypeDmcObjectSET = this;
        synchronized (dmcTypeDmcObjectSET) {
            DmcTypeDmcObjectSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (DmcObject val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcObject add(Object v) throws DmcValueException {
        DmcTypeDmcObjectSET dmcTypeDmcObjectSET = this;
        synchronized (dmcTypeDmcObjectSET) {
            DmcObject rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcObject del(Object v) {
        DmcTypeDmcObjectSET dmcTypeDmcObjectSET = this;
        synchronized (dmcTypeDmcObjectSET) {
            DmcObject rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<DmcObject> getMV() {
        DmcTypeDmcObjectSET dmcTypeDmcObjectSET = this;
        synchronized (dmcTypeDmcObjectSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<DmcObject>(this.value).iterator();
            }
            return new TreeSet<DmcObject>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DmcObject> getMVCopy() {
        DmcTypeDmcObjectSET dmcTypeDmcObjectSET = this;
        synchronized (dmcTypeDmcObjectSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<DmcObject>();
                }
                return new HashSet<DmcObject>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<DmcObject>(this.value);
            }
            return new TreeSet<DmcObject>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeDmcObjectSET dmcTypeDmcObjectSET = this;
        synchronized (dmcTypeDmcObjectSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeDmcObjectSET dmcTypeDmcObjectSET = this;
        synchronized (dmcTypeDmcObjectSET) {
            if (this.value == null) {
                return false;
            }
            try {
                DmcObject val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

