/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dms.generated.types.DmcTypeDmsDefinitionREF;
import org.dmd.dms.generated.types.DmsDefinitionREF;

public class DmcTypeDmsDefinitionREFSET
extends DmcTypeDmsDefinitionREF
implements Serializable {
    private static final Iterator<DmsDefinitionREF> emptyList = new HashSet().iterator();
    protected Set<DmsDefinitionREF> value;

    public DmcTypeDmsDefinitionREFSET() {
        this.value = null;
    }

    public DmcTypeDmsDefinitionREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<DmsDefinitionREF>() : new TreeSet<DmsDefinitionREF>();
    }

    public DmcTypeDmsDefinitionREFSET getNew() {
        return new DmcTypeDmsDefinitionREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<DmsDefinitionREF> cloneIt() {
        DmcTypeDmsDefinitionREFSET dmcTypeDmsDefinitionREFSET = this;
        synchronized (dmcTypeDmsDefinitionREFSET) {
            DmcTypeDmsDefinitionREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (DmsDefinitionREF val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmsDefinitionREF add(Object v) throws DmcValueException {
        DmcTypeDmsDefinitionREFSET dmcTypeDmsDefinitionREFSET = this;
        synchronized (dmcTypeDmsDefinitionREFSET) {
            DmsDefinitionREF rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmsDefinitionREF del(Object v) {
        DmcTypeDmsDefinitionREFSET dmcTypeDmsDefinitionREFSET = this;
        synchronized (dmcTypeDmsDefinitionREFSET) {
            DmsDefinitionREF rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<DmsDefinitionREF> getMV() {
        DmcTypeDmsDefinitionREFSET dmcTypeDmsDefinitionREFSET = this;
        synchronized (dmcTypeDmsDefinitionREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<DmsDefinitionREF>(this.value).iterator();
            }
            return new TreeSet<DmsDefinitionREF>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DmsDefinitionREF> getMVCopy() {
        DmcTypeDmsDefinitionREFSET dmcTypeDmsDefinitionREFSET = this;
        synchronized (dmcTypeDmsDefinitionREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<DmsDefinitionREF>();
                }
                return new HashSet<DmsDefinitionREF>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<DmsDefinitionREF>(this.value);
            }
            return new TreeSet<DmsDefinitionREF>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeDmsDefinitionREFSET dmcTypeDmsDefinitionREFSET = this;
        synchronized (dmcTypeDmsDefinitionREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeDmsDefinitionREFSET dmcTypeDmsDefinitionREFSET = this;
        synchronized (dmcTypeDmsDefinitionREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                DmsDefinitionREF val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

