/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.DmcTypeDotName;
import org.dmd.dmc.types.DotName;
import org.dmd.dms.generated.enums.ValueTypeEnum;

public class DmcTypeDotNameSET
extends DmcTypeDotName
implements Serializable {
    private static final Iterator<DotName> emptyList = new HashSet().iterator();
    protected Set<DotName> value;

    public DmcTypeDotNameSET() {
        this.value = null;
    }

    public DmcTypeDotNameSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<DotName>() : new TreeSet<DotName>();
    }

    public DmcTypeDotNameSET getNew() {
        return new DmcTypeDotNameSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<DotName> cloneIt() {
        DmcTypeDotNameSET dmcTypeDotNameSET = this;
        synchronized (dmcTypeDotNameSET) {
            DmcTypeDotNameSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (DotName val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DotName add(Object v) throws DmcValueException {
        DmcTypeDotNameSET dmcTypeDotNameSET = this;
        synchronized (dmcTypeDotNameSET) {
            DotName rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DotName del(Object v) {
        DmcTypeDotNameSET dmcTypeDotNameSET = this;
        synchronized (dmcTypeDotNameSET) {
            DotName rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<DotName> getMV() {
        DmcTypeDotNameSET dmcTypeDotNameSET = this;
        synchronized (dmcTypeDotNameSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<DotName>(this.value).iterator();
            }
            return new TreeSet<DotName>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DotName> getMVCopy() {
        DmcTypeDotNameSET dmcTypeDotNameSET = this;
        synchronized (dmcTypeDotNameSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<DotName>();
                }
                return new HashSet<DotName>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<DotName>(this.value);
            }
            return new TreeSet<DotName>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeDotNameSET dmcTypeDotNameSET = this;
        synchronized (dmcTypeDotNameSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeDotNameSET dmcTypeDotNameSET = this;
        synchronized (dmcTypeDotNameSET) {
            if (this.value == null) {
                return false;
            }
            try {
                DotName val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

