/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.DmcTypeDouble;
import org.dmd.dms.generated.enums.ValueTypeEnum;

public class DmcTypeDoubleSET
extends DmcTypeDouble
implements Serializable {
    private static final Iterator<Double> emptyList = new HashSet().iterator();
    protected Set<Double> value;

    public DmcTypeDoubleSET() {
        this.value = null;
    }

    public DmcTypeDoubleSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<Double>() : new TreeSet<Double>();
    }

    public DmcTypeDoubleSET getNew() {
        return new DmcTypeDoubleSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<Double> cloneIt() {
        DmcTypeDoubleSET dmcTypeDoubleSET = this;
        synchronized (dmcTypeDoubleSET) {
            DmcTypeDoubleSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (Double val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Double add(Object v) throws DmcValueException {
        DmcTypeDoubleSET dmcTypeDoubleSET = this;
        synchronized (dmcTypeDoubleSET) {
            Double rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Double del(Object v) {
        DmcTypeDoubleSET dmcTypeDoubleSET = this;
        synchronized (dmcTypeDoubleSET) {
            Double rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Double> getMV() {
        DmcTypeDoubleSET dmcTypeDoubleSET = this;
        synchronized (dmcTypeDoubleSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<Double>(this.value).iterator();
            }
            return new TreeSet<Double>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Double> getMVCopy() {
        DmcTypeDoubleSET dmcTypeDoubleSET = this;
        synchronized (dmcTypeDoubleSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<Double>();
                }
                return new HashSet<Double>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<Double>(this.value);
            }
            return new TreeSet<Double>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeDoubleSET dmcTypeDoubleSET = this;
        synchronized (dmcTypeDoubleSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeDoubleSET dmcTypeDoubleSET = this;
        synchronized (dmcTypeDoubleSET) {
            if (this.value == null) {
                return false;
            }
            try {
                Double val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

