/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dms.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dms.generated.types.DmcTypeEnumDefinitionREF;
import org.dmd.dms.generated.types.EnumDefinitionREF;

public class DmcTypeEnumDefinitionREFSET
extends DmcTypeEnumDefinitionREF
implements Serializable {
    private static final Iterator<EnumDefinitionREF> emptyList = new HashSet().iterator();
    protected Set<EnumDefinitionREF> value;

    public DmcTypeEnumDefinitionREFSET() {
        this.value = null;
    }

    public DmcTypeEnumDefinitionREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<EnumDefinitionREF>() : new TreeSet<EnumDefinitionREF>();
    }

    public DmcTypeEnumDefinitionREFSET getNew() {
        return new DmcTypeEnumDefinitionREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<EnumDefinitionREF> cloneIt() {
        DmcTypeEnumDefinitionREFSET dmcTypeEnumDefinitionREFSET = this;
        synchronized (dmcTypeEnumDefinitionREFSET) {
            DmcTypeEnumDefinitionREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (EnumDefinitionREF val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnumDefinitionREF add(Object v) throws DmcValueException {
        DmcTypeEnumDefinitionREFSET dmcTypeEnumDefinitionREFSET = this;
        synchronized (dmcTypeEnumDefinitionREFSET) {
            EnumDefinitionREF rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnumDefinitionREF del(Object v) {
        DmcTypeEnumDefinitionREFSET dmcTypeEnumDefinitionREFSET = this;
        synchronized (dmcTypeEnumDefinitionREFSET) {
            EnumDefinitionREF rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<EnumDefinitionREF> getMV() {
        DmcTypeEnumDefinitionREFSET dmcTypeEnumDefinitionREFSET = this;
        synchronized (dmcTypeEnumDefinitionREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<EnumDefinitionREF>(this.value).iterator();
            }
            return new TreeSet<EnumDefinitionREF>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<EnumDefinitionREF> getMVCopy() {
        DmcTypeEnumDefinitionREFSET dmcTypeEnumDefinitionREFSET = this;
        synchronized (dmcTypeEnumDefinitionREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<EnumDefinitionREF>();
                }
                return new HashSet<EnumDefinitionREF>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<EnumDefinitionREF>(this.value);
            }
            return new TreeSet<EnumDefinitionREF>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeEnumDefinitionREFSET dmcTypeEnumDefinitionREFSET = this;
        synchronized (dmcTypeEnumDefinitionREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeEnumDefinitionREFSET dmcTypeEnumDefinitionREFSET = this;
        synchronized (dmcTypeEnumDefinitionREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                EnumDefinitionREF val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

